/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineDataSource;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;

public class GeneSearchConversion
extends DataThread {
    private HashMap<String, Chromosome> geneNameMap;
    private LineDataSource dataSource;

    public GeneSearchConversion(URL url, GBrowser browser) {
        super(browser);
        try {
            this.dataSource = new LineDataSource(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void processDataRequest(DataRequest request) {
        if (this.geneNameMap == null) {
            this.geneNameMap = new HashMap();
            try {
                this.readFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        GeneRequest geneRequest = (GeneRequest)request;
        String searchString = geneRequest.getSearchString();
        Chromosome chr = this.geneNameMap.get(searchString.toLowerCase());
        LinkedList<RegionContent> resultList = new LinkedList<RegionContent>();
        if (chr != null) {
            resultList.add(new RegionContent(new Region(null, null, chr), null));
        }
        super.createDataResult(new GeneResult(geneRequest.getStatus(), resultList, searchString));
    }

    private void readFile() throws IOException {
        String line;
        while ((line = this.dataSource.readLine()) != null) {
            String[] cols = line.split("\t");
            if (cols.length != 2) continue;
            String chr = cols[0];
            String geneName = cols[1];
            this.geneNameMap.put(geneName.toLowerCase(), new Chromosome(chr));
        }
    }
}

