/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BedLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import org.broad.tribble.readers.TabixReader;

public class BedTabixToRegionConversion
extends DataThread {
    private TabixDataSource dataSource;
    private BedLineParser parser = new BedLineParser(false);

    public BedTabixToRegionConversion(URL tabixFile, URL tabixIndexFile, GBrowser browser) {
        super(browser);
        try {
            this.dataSource = new TabixDataSource(tabixFile, tabixIndexFile);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void clean() {
        this.dataSource.clean();
    }

    @Override
    protected void processDataRequest(DataRequest request) {
        TabixReader.Iterator iterator = this.dataSource.getTabixIterator(request);
        try {
            LinkedList<RegionContent> resultList = new LinkedList<RegionContent>();
            if (iterator != null) {
                String line;
                while ((line = iterator.next()) != null) {
                    this.parser.setLine(line);
                    Region region = this.parser.getRegion();
                    resultList.add(new RegionContent(region));
                }
            }
            super.createDataResult(new DataResult(request.getStatus(), resultList));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.getClass().getName() + " - " + this.dataSource;
    }
}

