/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutComponent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutContainer;

public class LayoutTool {
    public static void doLayout(LayoutContainer container, int layoutHeight) {
        int componentFillHeight = 0;
        if (LayoutTool.inferLayoutMode(container) != LayoutMode.FIXED) {
            componentFillHeight = LayoutTool.getComponentFillHeight(container, layoutHeight);
        }
        for (LayoutComponent layoutComponent : container.getLayoutComponents()) {
            int childHeight;
            if (layoutComponent.getLayoutMode() == LayoutMode.FIXED) {
                childHeight = layoutComponent.getHeight();
            } else {
                childHeight = layoutComponent.getMinHeight() + componentFillHeight;
                layoutComponent.setHeight(childHeight);
            }
            if (!(layoutComponent instanceof LayoutContainer)) continue;
            LayoutContainer childContainer = (LayoutContainer)((Object)layoutComponent);
            LayoutTool.doLayout(childContainer, childHeight);
        }
    }

    private static int getComponentFillHeight(LayoutContainer container, int layoutHeight) {
        int fillHeight = layoutHeight - LayoutTool.getMinHeightSum(container);
        return fillHeight / LayoutTool.getFillComponentCount(container);
    }

    private static int getFillComponentCount(LayoutContainer container) {
        int count = 0;
        for (LayoutComponent layoutComponent : container.getLayoutComponents()) {
            if (!layoutComponent.isVisible() || layoutComponent.getLayoutMode() == LayoutMode.FIXED) continue;
            ++count;
        }
        return count;
    }

    public static int getMinHeightSum(LayoutContainer container) {
        int height = 0;
        for (LayoutComponent layoutComponent : container.getLayoutComponents()) {
            if (!layoutComponent.isVisible()) continue;
            if (layoutComponent.getLayoutMode() == LayoutMode.FIXED) {
                height += layoutComponent.getHeight();
                continue;
            }
            height += layoutComponent.getMinHeight();
        }
        return height;
    }

    public static LayoutMode inferLayoutMode(LayoutContainer container) {
        for (LayoutComponent layoutComponent : container.getLayoutComponents()) {
            if (!layoutComponent.isVisible() || layoutComponent.getLayoutMode() == LayoutMode.FIXED) continue;
            return LayoutMode.FILL;
        }
        return LayoutMode.FIXED;
    }

    public static int getHeight(LayoutContainer container, int layoutHeight) {
        if (LayoutTool.inferLayoutMode(container) == LayoutMode.FIXED) {
            return LayoutTool.getMinHeightSum(container);
        }
        return layoutHeight;
    }

    public static int getFullHeight(LayoutContainer container) {
        int height = 0;
        for (LayoutComponent layoutComponent : container.getLayoutComponents()) {
            if (!layoutComponent.isVisible()) continue;
            height += Math.max(layoutComponent.getFullHeight(), layoutComponent.getHeight());
        }
        return height;
    }

    public static void setFullLayoutMode(LayoutContainer container, boolean enabled) {
        for (LayoutComponent layoutComponent : container.getLayoutComponents()) {
            if (layoutComponent instanceof LayoutContainer) {
                LayoutContainer childContainer = (LayoutContainer)((Object)layoutComponent);
                LayoutTool.setFullLayoutMode(childContainer, enabled);
                continue;
            }
            if (enabled) {
                if (layoutComponent.getLayoutMode() != LayoutMode.FILL) continue;
                layoutComponent.setLayoutMode(LayoutMode.FULL);
                continue;
            }
            layoutComponent.setDefaultLayoutMode();
        }
    }

    public static enum LayoutMode {
        FIXED,
        FILL,
        FULL;

    }
}

