/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToCoverageConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToCoverageEstimateConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToDetailsConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.GtfToFeatureConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.IndexedFastaConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.AnnotationManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GeneIndexActions;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BedLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BedTabixToRegionConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.ChromosomeBinarySearch;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CnaConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CnaLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CytobandConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.GeneSearchConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.GtfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineToRegionConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.VcfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.SamBamUtils;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.TreeSet;

public class Interpretation {
    private TrackType type;
    private DataUrl primaryData;
    private DataUrl indexData;
    private String name;
    private CnaConversion cnaDataThread;
    private GtfToFeatureConversion gtfDataThread;
    private LineToRegionConversion vcfDataThread;
    private LineToRegionConversion bedDataThread;
    private TreeSet<Chromosome> chrNames;

    public Interpretation(TrackType type, DataUrl primaryData) {
        this.type = type;
        this.primaryData = primaryData;
    }

    public TrackType getType() {
        return this.type;
    }

    public void setType(TrackType type) {
        this.type = type;
    }

    public DataUrl getPrimaryData() {
        return this.primaryData;
    }

    public void setPrimaryData(DataUrl primaryData) {
        this.primaryData = primaryData;
    }

    public DataUrl getIndexData() {
        return this.indexData;
    }

    public void setIndexData(DataUrl indexData) {
        this.indexData = indexData;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.primaryData.getName();
    }

    public static CytobandConversion getCytobandDataThread(GBrowser browser) {
        URL cytobandUrl = browser.getAnnotationUrl(browser.getGenome(), AnnotationManager.AnnotationType.CYTOBANDS);
        if (cytobandUrl != null) {
            return new CytobandConversion(cytobandUrl, browser);
        }
        return null;
    }

    public static GeneIndexActions getGeneSearchDataThread(GBrowser browser) {
        AnnotationManager.Genome genome = browser.getGenome();
        GtfToFeatureConversion gtfDataThread = Interpretation.getAnnotationDataThread(browser);
        if (gtfDataThread != null) {
            URL geneUrl = browser.getAnnotationManager().getAnnotation(genome, AnnotationManager.AnnotationType.GENE_CHRS).getUrl();
            GeneSearchConversion geneRequestHandler = new GeneSearchConversion(geneUrl, browser);
            return new GeneIndexActions(browser.getPlot().getDataView().getQueueManager(), gtfDataThread, geneRequestHandler);
        }
        return null;
    }

    public static GtfToFeatureConversion getAnnotationDataThread(GBrowser browser) {
        AnnotationManager.Genome genome = browser.getGenome();
        URL gtfUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.GTF);
        URL gtfTabixUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.GTF_TABIX);
        URL gtfIndexUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.GTF_TABIX_INDEX);
        GtfToFeatureConversion gtfDataThread = null;
        if (gtfUrl != null) {
            gtfDataThread = new GtfToFeatureConversion(gtfUrl, null, browser);
        } else if (gtfTabixUrl != null && gtfIndexUrl != null) {
            gtfDataThread = new GtfToFeatureConversion(gtfTabixUrl, gtfIndexUrl, browser);
        }
        return gtfDataThread;
    }

    public static BedTabixToRegionConversion getRepeatDataThread(GBrowser browser) {
        AnnotationManager.Genome genome = browser.getGenome();
        URL repeatUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REPEAT);
        URL repeatIndexUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REPEAT_INDEX);
        if (repeatUrl != null && repeatIndexUrl != null) {
            return new BedTabixToRegionConversion(repeatUrl, repeatIndexUrl, browser);
        }
        return null;
    }

    public static IndexedFastaConversion getReferenceDataThread(GBrowser browser) {
        AnnotationManager.Genome genome = browser.getGenome();
        URL fastaUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REFERENCE);
        URL fastaIndexUrl = browser.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REFERENCE_INDEX);
        IndexedFastaConversion refSeqDataThread = null;
        if (fastaUrl != null && fastaIndexUrl != null) {
            refSeqDataThread = new IndexedFastaConversion(fastaUrl, fastaIndexUrl, browser);
        }
        return refSeqDataThread;
    }

    public BamToDetailsConversion getBamDetailsDataThread(GBrowser browser) {
        if (this.getType() == TrackType.READS) {
            try {
                BamDataSource dataSource = new BamDataSource(this.getPrimaryData().getUrl(), this.getIndexData().getUrl());
                return new BamToDetailsConversion(dataSource, browser);
            }
            catch (IOException | URISyntaxException e) {
                browser.reportException(e);
            }
        }
        return null;
    }

    public BamToCoverageConversion getBamCoverageDataThread(GBrowser browser) {
        if (this.getType() == TrackType.READS) {
            try {
                BamDataSource dataSource = new BamDataSource(this.getPrimaryData().getUrl(), this.getIndexData().getUrl());
                return new BamToCoverageConversion(dataSource, browser);
            }
            catch (IOException | URISyntaxException e) {
                browser.reportException(e);
            }
        }
        return null;
    }

    public BamToCoverageEstimateConversion getBamCoverageEstimateDataThread(GBrowser browser) {
        if (this.getType() == TrackType.READS) {
            try {
                BamDataSource dataSource = new BamDataSource(this.getPrimaryData().getUrl(), this.getIndexData().getUrl());
                return new BamToCoverageEstimateConversion(dataSource, browser);
            }
            catch (IOException | URISyntaxException e) {
                browser.reportException(e);
            }
        }
        return null;
    }

    public LineToRegionConversion getBedDataThread(GBrowser browser) {
        if (this.getType() == TrackType.REGIONS && this.bedDataThread == null) {
            try {
                this.bedDataThread = new LineToRegionConversion(this.getPrimaryData().getUrl(), new BedLineParser(true), browser);
            }
            catch (IOException | URISyntaxException e) {
                browser.reportException(e);
            }
        }
        return this.bedDataThread;
    }

    public LineToRegionConversion getVcfDataThread(GBrowser browser) {
        if (this.getType() == TrackType.VCF && this.vcfDataThread == null) {
            try {
                this.vcfDataThread = new LineToRegionConversion(this.getPrimaryData().getUrl(), new VcfLineParser(), browser);
            }
            catch (IOException | URISyntaxException e) {
                browser.reportException(e);
            }
        }
        return this.vcfDataThread;
    }

    public GtfToFeatureConversion getGtfDataThread(GBrowser browser) {
        if (this.getType() == TrackType.VCF && this.gtfDataThread == null) {
            try {
                this.gtfDataThread = new GtfToFeatureConversion(this.getPrimaryData().getUrl(), null, browser);
            }
            catch (IOException e) {
                browser.reportException(e);
            }
        }
        return this.gtfDataThread;
    }

    public CnaConversion getCnaDataThread(GBrowser browser) {
        if ((this.getType() == TrackType.CNA_FREQUENCIES || this.getType() == TrackType.CNA_CALLS || this.getType() == TrackType.CNA_LOGRATIOS) && this.cnaDataThread == null) {
            try {
                this.cnaDataThread = new CnaConversion(new RandomAccessLineDataSource(this.getPrimaryData().getUrl()), browser);
            }
            catch (IOException | URISyntaxException e) {
                browser.reportException(e);
            }
        }
        return this.cnaDataThread;
    }

    public TreeSet<Chromosome> getChromosomeNames() throws URISyntaxException, IOException, UnsortedDataException, GBrowserException {
        boolean isCna;
        TreeSet<Chromosome> chromosomes = new TreeSet<Chromosome>();
        if (this.getType() == TrackType.READS) {
            URL bam = this.getPrimaryData().getUrl();
            URL index = this.getIndexData().getUrl();
            for (String string : SamBamUtils.readChromosomeNames(bam, index)) {
                chromosomes.add(new Chromosome(string));
            }
        }
        boolean isBed = this.getType() == TrackType.REGIONS;
        boolean isVcf = this.getType() == TrackType.VCF;
        boolean isGtf = this.getType() == TrackType.GTF;
        boolean bl = isCna = this.getType() == TrackType.CNA_FREQUENCIES || this.getType() == TrackType.CNA_CALLS || this.getType() == TrackType.CNA_LOGRATIOS;
        if (isBed || isVcf || isGtf || isCna) {
            DataUrl data = this.getPrimaryData();
            ChromosomeBinarySearch chrSearch = null;
            if (isBed) {
                chrSearch = new ChromosomeBinarySearch(data.getUrl(), new BedLineParser(true));
            } else if (isVcf) {
                chrSearch = new ChromosomeBinarySearch(data.getUrl(), new VcfLineParser());
            } else if (isGtf) {
                chrSearch = new ChromosomeBinarySearch(data.getUrl(), new GtfLineParser());
            } else if (isCna) {
                chrSearch = new ChromosomeBinarySearch(data.getUrl(), new CnaLineParser());
            }
            this.chrNames = chrSearch.getChromosomes();
            chromosomes.addAll(this.chrNames);
        }
        return chromosomes;
    }

    public static enum TrackType {
        CYTOBANDS(false),
        GENES(false),
        TRANSCRIPTS(true),
        REFERENCE(true),
        REGIONS(true),
        READS(true),
        HIDDEN(false),
        VCF(true),
        GTF(true),
        CNA_CALLS(true),
        CNA_LOGRATIOS(true),
        CNA_FREQUENCIES(true);

        public boolean isToggleable;

        private TrackType(boolean toggleable) {
            this.isToggleable = toggleable;
        }
    }
}

