/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToCoverageConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToCoverageEstimateConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToDetailsConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.GtfToFeatureConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.IndexedFastaConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.AnnotationManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.AnnotationScrollGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserSettings;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GeneIndexActions;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Interpretation;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ScrollGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TooltipAugmentedChartPanel;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ViewLimiter;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BedTabixToRegionConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CnaConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CytobandConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineToRegionConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack3D;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.StatusTitleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackFactory;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.util.BrowserLauncher;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;

public class GBrowser
implements ComponentListener {
    static final String WAITPANEL = "waitpanel";
    static final String PLOTPANEL = "plotpanel";
    private List<TrackDefinition> tracks = new LinkedList<TrackDefinition>();
    private GBrowserPlot plot;
    private JPanel plotPanel = new JPanel(new CardLayout());
    private AnnotationManager annotationManager;
    private GeneIndexActions gia;
    private ViewLimiter viewLimiter;
    protected boolean geneSearchDone;
    private GBrowserSettings settings;
    private List<Interpretation> interpretations;
    private LinkedList<String> sampleNames;

    public void initialise() throws Exception {
        this.annotationManager = new AnnotationManager(this);
        this.annotationManager.initialize();
        this.settings = new GBrowserSettings();
        this.settings.initialise(this);
    }

    private void createAvailableTracks() {
        this.tracks.add(new TrackDefinition(AnnotationManager.AnnotationType.GTF_TABIX.getId(), new Interpretation(Interpretation.TrackType.GENES, null)));
        this.tracks.add(new TrackDefinition(AnnotationManager.AnnotationType.CYTOBANDS.getId(), new Interpretation(Interpretation.TrackType.CYTOBANDS, null)));
        for (int i = 0; i < this.interpretations.size(); ++i) {
            Interpretation interpretation = this.interpretations.get(i);
            this.tracks.add(new TrackDefinition(interpretation.getName(), interpretation));
        }
        this.settings.updateDatasetSwitches();
    }

    public void setFullHeight(boolean fullHeight) {
        this.plot.setFullLayoutMode(fullHeight);
    }

    public JComponent getVisualisation(List<Interpretation> interpretations) throws IOException {
        this.interpretations = interpretations;
        this.settings.updateInterpretations();
        this.tracks.clear();
        this.createAvailableTracks();
        JPanel waitPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        waitPanel.add((Component)new JLabel("<html><p style=\"font-size: larger\">Please select genome and click " + this.settings.getGoButtonText() + "</p></html>"), c);
        this.plotPanel.add((Component)waitPanel, WAITPANEL);
        return this.plotPanel;
    }

    public void updateCoverageScale() {
        this.plot.setReadScale(this.settings.getCoverageScale());
    }

    public AnnotationManager.Genome getGenome() {
        return this.settings.getGenome();
    }

    public void updateTracks() {
        this.plot.getOverviewView().clean();
        this.plot.getDataView().clean();
        this.plot.chartPanel.clean();
        ScrollGroup overview = new ScrollGroup("Overview");
        AnnotationScrollGroup annotations = new AnnotationScrollGroup();
        SeparatorTrack3D separator = new SeparatorTrack3D(true);
        separator.setView(this.plot.getDataView());
        this.plot.getDataView().addTrackGroup(new TrackGroup(separator));
        for (TrackDefinition track : this.tracks) {
            if (!track.checkBox.isSelected()) continue;
            switch (track.interpretation.getType()) {
                case CYTOBANDS: {
                    CytobandConversion cytobandDataThread = Interpretation.getCytobandDataThread(this);
                    if (cytobandDataThread == null) break;
                    overview.addTrackGroup(TrackFactory.getCytobandTrackGroup(this.plot, cytobandDataThread));
                    this.viewLimiter = new ViewLimiter(this.plot.getOverviewView().getQueueManager(), cytobandDataThread, this.plot.getOverviewView());
                    this.plot.getDataView().setViewLimiter(this.viewLimiter);
                    this.plot.getOverviewView().setViewLimiter(this.viewLimiter);
                    break;
                }
                case GENES: {
                    GtfToFeatureConversion gtfRequestHandler = Interpretation.getAnnotationDataThread(this);
                    BedTabixToRegionConversion repeatRequestHandler = Interpretation.getRepeatDataThread(this);
                    this.gia = Interpretation.getGeneSearchDataThread(this);
                    TrackGroup geneGroup = TrackFactory.getGeneTrackGroup(this.plot, gtfRequestHandler, repeatRequestHandler, false);
                    track.setTrackGroup(geneGroup);
                    annotations.addTrackGroup(geneGroup);
                    break;
                }
                case REFERENCE: {
                    break;
                }
                case TRANSCRIPTS: {
                    break;
                }
            }
        }
        this.plot.getOverviewView().addScrollGroup(overview);
        this.plot.getDataView().addScrollGroup(annotations);
        this.plot.getDataView().addTrackGroup(TrackFactory.getThickSeparatorTrackGroup(this.plot));
        ScrollGroup samples = new ScrollGroup("Samples", true);
        boolean firstReadTrack = true;
        for (TrackDefinition track : this.tracks) {
            if (!track.checkBox.isSelected() || track.interpretation.getType() != Interpretation.TrackType.READS) continue;
            if (!firstReadTrack) {
                samples.addTrackGroup(TrackFactory.getThinSeparatorTrackGroup(this.plot));
            } else {
                firstReadTrack = false;
            }
            IndexedFastaConversion refSeqRequestHandler = Interpretation.getReferenceDataThread(this);
            BamToDetailsConversion details = track.interpretation.getBamDetailsDataThread(this);
            BamToCoverageConversion coverage = track.interpretation.getBamCoverageDataThread(this);
            BamToCoverageEstimateConversion estimate = track.interpretation.getBamCoverageEstimateDataThread(this);
            TrackGroup readGroup = TrackFactory.getReadTrackGroup(this.plot, details, coverage, estimate, refSeqRequestHandler, track.interpretation.getPrimaryData().getName());
            track.setTrackGroup(readGroup);
            samples.addTrackGroup(readGroup);
        }
        if (firstReadTrack) {
            samples.setScrollEnabled(false);
            IndexedFastaConversion refSeqRequestHandler = Interpretation.getReferenceDataThread(this);
            if (refSeqRequestHandler != null) {
                TrackGroup readGroup = TrackFactory.getReadTrackGroup(this.plot, null, null, null, refSeqRequestHandler, this.settings.getGenome().toString());
                samples.addTrackGroup(readGroup);
            }
        }
        this.plot.getDataView().addScrollGroup(samples);
        this.plot.getDataView().addTrackGroup(TrackFactory.getThickSeparatorTrackGroup(this.plot));
        ScrollGroup analysis = new ScrollGroup("Analysis", false);
        boolean firstPeakTrack = true;
        StatusTitleTrack titleTrack = null;
        for (TrackDefinition track : this.tracks) {
            if (!track.checkBox.isSelected()) continue;
            switch (track.interpretation.getType()) {
                case REGIONS: 
                case VCF: 
                case GTF: 
                case CNA_FREQUENCIES: 
                case CNA_CALLS: 
                case CNA_LOGRATIOS: {
                    if (!firstPeakTrack) {
                        analysis.addTrackGroup(TrackFactory.getThinSeparatorTrackGroup(this.plot));
                    } else {
                        firstPeakTrack = false;
                    }
                    titleTrack = new StatusTitleTrack(track.interpretation.getPrimaryData().getName(), Color.black);
                    titleTrack.setView(this.plot.getDataView());
                    analysis.addTrack(titleTrack);
                    break;
                }
            }
            switch (track.interpretation.getType()) {
                case REGIONS: {
                    LineToRegionConversion bed = track.interpretation.getBedDataThread(this);
                    analysis.addTrackGroup(TrackFactory.getPeakTrackGroup(this.plot, bed));
                    titleTrack.addDataThread(bed);
                    break;
                }
                case VCF: {
                    LineToRegionConversion vcf = track.interpretation.getVcfDataThread(this);
                    analysis.addTrackGroup(TrackFactory.getPeakTrackGroup(this.plot, vcf));
                    titleTrack.addDataThread(vcf);
                    break;
                }
                case GTF: {
                    analysis.setScrollEnabled(true);
                    GtfToFeatureConversion gtfConversion = track.interpretation.getGtfDataThread(this);
                    analysis.addTrackGroup(TrackFactory.getGeneTrackGroup(this.plot, gtfConversion, null, true));
                    titleTrack.addDataThread(gtfConversion);
                    break;
                }
                case CNA_FREQUENCIES: 
                case CNA_CALLS: 
                case CNA_LOGRATIOS: {
                    analysis.setScrollEnabled(true);
                    CnaConversion cnaData = track.interpretation.getCnaDataThread(this);
                    LinkedList<String> internalSampleNames = cnaData.getSampleNames();
                    this.sampleNames = this.getSampleNames(internalSampleNames, track.interpretation.getPrimaryData());
                    boolean showFrequencies = track.interpretation.getType() == Interpretation.TrackType.CNA_FREQUENCIES;
                    boolean showCalls = track.interpretation.getType() == Interpretation.TrackType.CNA_CALLS;
                    boolean showLogratios = track.interpretation.getType() == Interpretation.TrackType.CNA_LOGRATIOS;
                    analysis.addTrackGroup(TrackFactory.getCnaTrackGroup(this.plot, cnaData, this.sampleNames, showFrequencies, showCalls, showLogratios));
                    titleTrack.addDataThread(cnaData);
                    break;
                }
            }
        }
        if (analysis.getTrackGroups().size() > 0) {
            this.plot.getDataView().addScrollGroup(analysis);
        }
        SeparatorTrack3D separator2 = new SeparatorTrack3D(false);
        separator2.setView(this.plot.getDataView());
        this.plot.getDataView().addTrackGroup(new TrackGroup(separator2));
        this.plot.initializeTracks();
    }

    public URL getAnnotationUrl(AnnotationManager.Genome genome, AnnotationManager.AnnotationType type) {
        AnnotationManager.GenomeAnnotation annotation = this.annotationManager.getAnnotation(genome, type);
        if (annotation != null) {
            return annotation.getUrl();
        }
        return null;
    }

    public void showVisualisation() {
        if (this.plot != null) {
            this.plot.clean();
        }
        TooltipAugmentedChartPanel chartPanel = new TooltipAugmentedChartPanel();
        this.plot = new GBrowserPlot(chartPanel, true);
        chartPanel.setPlot(this.plot);
        this.plot.getDataView().setBpRegion(new RegionDouble((double)this.settings.getLocation().longValue() - (double)this.settings.getViewSize().longValue() / 2.0, (double)this.settings.getLocation().longValue() + (double)this.settings.getViewSize().longValue() / 2.0, this.settings.getChromosome()));
        this.plot.addDataRegionListener(this.settings);
        this.updateCoverageScale();
        this.updateTracks();
        this.settings.updateTracks();
        chartPanel.setChart(new JFreeChart((Plot)this.plot));
        chartPanel.setCursor(new Cursor(12));
        for (GBrowserView view : this.plot.getViews()) {
            chartPanel.addMouseListener(view);
            chartPanel.addMouseMotionListener(view);
            chartPanel.addMouseWheelListener(view);
        }
        if (this.plotPanel.getComponentCount() == 2) {
            this.plotPanel.remove(1);
        }
        this.setFullHeight(this.settings.isFullHeight());
        this.plotPanel.add((Component)((Object)chartPanel), PLOTPANEL);
        this.plotPanel.addComponentListener(this);
        CardLayout cl = (CardLayout)this.plotPanel.getLayout();
        cl.show(this.plotPanel, PLOTPANEL);
    }

    private GeneIndexActions getGeneIndexActions() {
        if (this.gia == null) {
            this.showDialog("Gene search failed", "Gene search is not initialized, is annotation data missing?", null, true, false, true, false);
        }
        return this.gia;
    }

    public void requestGeneSearch(String gene) {
        this.runBlockingTask("searching gene", new Runnable(){

            @Override
            public void run() {
                int TIME_OUT = 30000;
                int INTERVAL = 100;
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() < startTime + (long)TIME_OUT && !GBrowser.this.geneSearchDone) {
                    try {
                        Thread.sleep(INTERVAL);
                    }
                    catch (InterruptedException e) {}
                }
                if (GBrowser.this.geneSearchDone) {
                    GBrowser.this.geneSearchDone = false;
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GBrowser.this.showDialog("Search failed", "Unexpected error happened in the search. Please inform the developers if the problem persists.", null, true, false, false, false);
                        }
                    });
                }
            }
        });
        this.getGeneIndexActions().requestLocation(gene, new GeneIndexActions.GeneLocationListener(){

            @Override
            public void geneLocation(Region geneLocation) {
                GBrowser.this.geneSearchDone = true;
                if (geneLocation == null) {
                    GBrowser.this.settings.processLocationPanelInput();
                    GBrowser.this.showDialog("Not found", "Gene was not found", null, false, false, false, false);
                } else {
                    Chromosome resultChr = new Chromosome(geneLocation.start.chr);
                    if (GBrowser.this.settings.setChromosome(resultChr)) {
                        GBrowser.this.setLocation(GBrowser.this.settings.getChromosome(), geneLocation.start.bp, geneLocation.end.bp);
                    } else {
                        GBrowser.this.showDialog("Different chromosome", "Searched gene was found from chromosome " + resultChr + " but there is no data for that chromosome", "" + geneLocation, true, false, false, false);
                    }
                }
            }
        });
    }

    public void setLocation(Chromosome chr, Long start, Long end) {
        this.settings.setChromosome(chr);
        if (end == null) {
            end = start;
        }
        this.settings.setCoordinateFields((end + start) / 2L, (end - start) * 2L);
        this.plot.moveDataBpRegion(this.settings.getChromosome(), this.settings.getLocation(), this.settings.getViewSize());
        this.plot.setReadScale(this.settings.getCoverageScale());
    }

    public void removeVisualisation() {
        this.plotPanel.removeComponentListener(this);
        this.plotPanel.removeAll();
        if (this.plot != null) {
            this.plot.clean();
            this.plot = null;
        }
        if (this.tracks != null) {
            this.tracks.clear();
        }
        this.gia = null;
    }

    public LinkedList<Chromosome> getChromosomeNames() throws IOException {
        TreeSet<Chromosome> chromosomes = new TreeSet<Chromosome>();
        try {
            for (Interpretation interpretation : this.interpretations) {
                if (interpretation.getType() != Interpretation.TrackType.READS) continue;
                chromosomes.addAll(interpretation.getChromosomeNames());
            }
            if (chromosomes.isEmpty()) {
                for (Interpretation interpretation : this.getInterpretations()) {
                    if (interpretation.getType() == Interpretation.TrackType.READS) continue;
                    chromosomes.addAll(interpretation.getChromosomeNames());
                }
            }
        }
        catch (GBrowserException | URISyntaxException e) {
            this.reportException(e);
        }
        LinkedList<Chromosome> list = new LinkedList<Chromosome>();
        for (Chromosome chromosome : chromosomes) {
            list.add(chromosome);
        }
        return list;
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.plot.redraw();
    }

    public List<Interpretation> getInterpretations() {
        return this.interpretations;
    }

    public String getExternalLinkUrl(AnnotationManager.AnnotationType browser) {
        URL url;
        this.settings.getGenome();
        AnnotationManager.GenomeAnnotation urlAnnotation = this.annotationManager.getAnnotation(this.settings.getGenome(), browser);
        if (urlAnnotation != null && (url = urlAnnotation.getUrl()) != null && this.plot != null && this.plot.getDataView() != null && this.plot.getDataView().getBpRegion() != null) {
            String stringUrl = url.toString();
            Region region = this.plot.getDataView().getBpRegion();
            stringUrl = stringUrl.replace("[CHR]", region.start.chr.toNormalisedString());
            stringUrl = stringUrl.replace("[START]", region.start.bp.toString());
            stringUrl = stringUrl.replace("[END]", region.end.bp.toString());
            return stringUrl;
        }
        return "";
    }

    public void openExternalBrowser(String url) {
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception e) {
            this.reportException(e);
        }
    }

    public JPanel getParameterPanel() {
        return this.settings.getParameterPanel();
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public List<TrackDefinition> getTracks() {
        return this.tracks;
    }

    public void reportException(Exception e) {
        e.printStackTrace();
    }

    public void showDialog(String title, String message, String details, boolean warning, boolean dialogShowDetails, boolean modal, boolean closeBrowser) {
        System.out.println("showDialog not implemented: " + title + "\t" + message + "\t" + details);
    }

    public void runBlockingTask(String taskName, Runnable runnable) {
        System.out.println("runBlockingTask: " + taskName);
        new Thread(runnable).start();
    }

    public void initialiseUserDatas() throws IOException {
    }

    public ImageIcon getIcon(String path) {
        System.out.println("getIcon not implemented");
        return new ImageIcon();
    }

    public void openDownloadAnnotationsDialog(AnnotationManager.Genome genome) {
        try {
            this.getAnnotationManager().downloadAnnotations(genome);
        }
        catch (IOException e) {
            this.reportException(e);
        }
    }

    @Deprecated
    public URL getRemoteAnnotationsUrl() throws Exception {
        System.out.println("getRemoteAnnotationsUrl not implemented");
        return null;
    }

    public List<URL> getRemoteAnnotationFiles() throws Exception {
        System.out.println("getRemoteAnnotationFiles not implemented");
        return null;
    }

    public File getLocalAnnotationDir() throws IOException {
        System.out.println("getLocalAnnotationDir not implemented");
        return null;
    }

    public LinkedList<String> getSampleNames(LinkedList<String> internalSampleNames, DataUrl dataUrl) {
        return internalSampleNames;
    }

    public void updateData() {
        this.updateTracks();
        this.settings.updateVisibilityForTracks();
        this.plot.updateData();
    }

    public GBrowserPlot getPlot() {
        return this.plot;
    }

    public static class TrackDefinition {
        public Interpretation interpretation;
        public JCheckBox checkBox;
        public String name;
        public TrackGroup trackGroup = null;

        public TrackDefinition(String name, Interpretation interpretation) {
            this.name = name;
            this.interpretation = interpretation;
        }

        public void setTrackGroup(TrackGroup trackGroup) {
            this.trackGroup = trackGroup;
        }
    }
}

