/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.web.adminweb.ui;

import com.vaadin.data.hbnutil.ContainerFilter;
import com.vaadin.data.hbnutil.IdContainerFilter;
import com.vaadin.data.hbnutil.StringContainerFilter;
import com.vaadin.event.ShortcutListener;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import fi.csc.chipster.web.adminweb.data.DateContainerFilter;
import fi.csc.chipster.web.adminweb.data.JobLogContainer;
import fi.csc.chipster.web.adminweb.ui.JobLogView;
import java.util.Arrays;
import java.util.Collection;

public class JobLogFilter
extends HorizontalLayout {
    private static final Collection<String> SEARCH_COLUMNS = Arrays.asList("username", "operation", "compHost", "startTime", "endTime", "wallclockTime", "status");
    private JobLogView view;
    private TextField searchStringField;
    private NativeSelect columnToSearch;
    private ContainerFilter containerFilter;

    public JobLogFilter(final JobLogView view) {
        this.view = view;
        this.searchStringField = new TextField();
        this.searchStringField.addShortcutListener(new ShortcutListener("Search", 13, null){

            public void handleAction(Object sender, Object target) {
                view.applyFilters();
            }
        });
        this.columnToSearch = new NativeSelect();
        Button clearButton = new Button();
        clearButton.setIcon((Resource)new ThemeResource("crystal/button_cancel-bw.png"));
        clearButton.setDescription("Remove filter");
        clearButton.addStyleName("search-button");
        for (int i = 0; i < JobLogContainer.NATURAL_COL_ORDER.length; ++i) {
            if (!SEARCH_COLUMNS.contains(JobLogContainer.NATURAL_COL_ORDER[i])) continue;
            this.columnToSearch.addItem(JobLogContainer.NATURAL_COL_ORDER[i]);
            this.columnToSearch.setItemCaption(JobLogContainer.NATURAL_COL_ORDER[i], JobLogContainer.COL_HEADERS_ENGLISH[i]);
        }
        this.columnToSearch.setValue((Object)"username");
        this.columnToSearch.setNullSelectionAllowed(false);
        clearButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                JobLogFilter.this.getView().clearFilters(JobLogFilter.this);
            }
        });
        this.addComponent((Component)this.columnToSearch);
        this.addComponent((Component)this.searchStringField);
        this.addComponent((Component)clearButton);
        this.addStyleName("search-filter-bg");
        this.addStyleName("search-filter");
    }

    public String toString() {
        return this.columnToSearch.getValue() + " = *" + (String)this.searchStringField.getValue() + "*";
    }

    public ContainerFilter getContainerFilter() {
        if (this.searchStringField.getValue() == "") {
            this.containerFilter = null;
        } else if (this.columnToSearch.getValue().equals("startTime") || this.columnToSearch.getValue().equals("endTime")) {
            try {
                this.containerFilter = new DateContainerFilter(this.columnToSearch.getValue(), (String)this.searchStringField.getValue());
            }
            catch (NumberFormatException e) {
                Notification.show((String)e.getMessage(), (Notification.Type)Notification.Type.WARNING_MESSAGE);
                this.containerFilter = null;
            }
        } else if (this.columnToSearch.getValue().equals("wallclockTime")) {
            try {
                this.containerFilter = new IdContainerFilter(this.columnToSearch.getValue(), Integer.valueOf(Integer.parseInt((String)this.searchStringField.getValue())));
            }
            catch (NumberFormatException e) {
                Notification.show((String)("Search term " + this.columnToSearch.getValue() + " must be numeric"), (Notification.Type)Notification.Type.WARNING_MESSAGE);
                this.containerFilter = null;
            }
        } else {
            this.containerFilter = new StringContainerFilter(this.columnToSearch.getValue(), (String)this.searchStringField.getValue(), true, false);
        }
        return this.containerFilter;
    }

    public JobLogView getView() {
        return this.view;
    }

    public void clear() {
        this.searchStringField.setValue("");
        this.containerFilter = null;
    }
}

