/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.net.URI;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.eclipse.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.annotations.AnnotationDecorator;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassInheritanceHandler;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.annotations.ContainerInitializerAnnotationHandler;
import org.eclipse.jetty.annotations.ServletContainerInitializerListener;
import org.eclipse.jetty.annotations.WebFilterAnnotationHandler;
import org.eclipse.jetty.annotations.WebListenerAnnotationHandler;
import org.eclipse.jetty.annotations.WebServletAnnotationHandler;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.MetaDataComplete;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebDescriptor;

public class AnnotationConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(AnnotationConfiguration.class);
    public static final String CLASS_INHERITANCE_MAP = "org.eclipse.jetty.classInheritanceMap";
    public static final String CONTAINER_INITIALIZERS = "org.eclipse.jetty.containerInitializers";

    public void preConfigure(WebAppContext context) throws Exception {
    }

    public void configure(WebAppContext context) throws Exception {
        List<ServletContainerInitializer> nonExcludedInitializers;
        boolean metadataComplete = context.getMetaData().isMetaDataComplete();
        context.addDecorator((ServletContextHandler.Decorator)new AnnotationDecorator(context));
        AnnotationParser parser = null;
        if (!metadataComplete) {
            if (context.getServletContext().getEffectiveMajorVersion() >= 3 || context.isConfigurationDiscovered()) {
                parser = this.createAnnotationParser();
                parser.registerAnnotationHandler("javax.servlet.annotation.WebServlet", new WebServletAnnotationHandler(context));
                parser.registerAnnotationHandler("javax.servlet.annotation.WebFilter", new WebFilterAnnotationHandler(context));
                parser.registerAnnotationHandler("javax.servlet.annotation.WebListener", new WebListenerAnnotationHandler(context));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Metadata-complete==true,  not processing discoverable servlet annotations for context " + context, new Object[0]);
        }
        if ((parser = this.registerServletContainerInitializerAnnotationHandlers(context, parser, nonExcludedInitializers = this.getNonExcludedInitializers(context))) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scanning all classses for annotations: webxmlVersion=" + context.getServletContext().getEffectiveMajorVersion() + " configurationDiscovered=" + context.isConfigurationDiscovered(), new Object[0]);
            }
            this.parseContainerPath(context, parser);
            this.parseWebInfClasses(context, parser);
            this.parseWebInfLib(context, parser);
        }
    }

    protected AnnotationParser createAnnotationParser() {
        return new AnnotationParser();
    }

    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.addDecorator((ServletContextHandler.Decorator)new AnnotationDecorator(context));
    }

    public AnnotationParser registerServletContainerInitializerAnnotationHandlers(WebAppContext context, AnnotationParser parser, List<ServletContainerInitializer> scis) throws Exception {
        if (scis == null || scis.isEmpty()) {
            return parser;
        }
        ServletContainerInitializerListener listener = new ServletContainerInitializerListener();
        listener.setWebAppContext(context);
        context.addEventListener((EventListener)((Object)listener));
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        context.setAttribute(CONTAINER_INITIALIZERS, initializers);
        for (ServletContainerInitializer service : scis) {
            HandlesTypes annotation = service.getClass().getAnnotation(HandlesTypes.class);
            ContainerInitializer initializer = new ContainerInitializer();
            initializer.setTarget(service);
            initializers.add(initializer);
            if (annotation != null) {
                Class[] classes = annotation.value();
                if (classes != null) {
                    initializer.setInterestedTypes(classes);
                    if (parser == null) {
                        parser = this.createAnnotationParser();
                    }
                    if (context.getAttribute(CLASS_INHERITANCE_MAP) == null) {
                        ClassInheritanceHandler classHandler = new ClassInheritanceHandler();
                        context.setAttribute(CLASS_INHERITANCE_MAP, (Object)classHandler.getMap());
                        parser.registerClassHandler(classHandler);
                    }
                    for (Class c : classes) {
                        if (!c.isAnnotation()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Registering annotation handler for " + c.getName(), new Object[0]);
                        }
                        parser.registerAnnotationHandler(c.getName(), new ContainerInitializerAnnotationHandler(initializer, c));
                    }
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("No classes in HandlesTypes on initializer " + service.getClass(), new Object[0]);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("No annotation on initializer " + service.getClass(), new Object[0]);
        }
        return parser;
    }

    public boolean isFromExcludedJar(WebAppContext context, ServletContainerInitializer service) throws Exception {
        List orderedJars = context.getMetaData().getOrderedWebInfJars();
        if (context.getMetaData().getOrdering() == null) {
            return false;
        }
        if (orderedJars.isEmpty()) {
            return true;
        }
        String loadingJarName = Thread.currentThread().getContextClassLoader().getResource(service.getClass().getName().replace('.', '/') + ".class").toString();
        int i = loadingJarName.indexOf(".jar");
        if (i < 0) {
            return false;
        }
        loadingJarName = (loadingJarName = loadingJarName.substring(0, i + 4)).startsWith("jar:") ? loadingJarName.substring(4) : loadingJarName;
        URI loadingJarURI = Resource.newResource((String)loadingJarName).getURI();
        boolean found = false;
        Iterator itor = orderedJars.iterator();
        while (!found && itor.hasNext()) {
            Resource r = (Resource)itor.next();
            found = r.getURI().equals(loadingJarURI);
        }
        return !found;
    }

    public List<ServletContainerInitializer> getNonExcludedInitializers(WebAppContext context) throws Exception {
        ArrayList<ServletContainerInitializer> nonExcludedInitializers = new ArrayList<ServletContainerInitializer>();
        ServiceLoader<ServletContainerInitializer> loadedInitializers = ServiceLoader.load(ServletContainerInitializer.class, context.getClassLoader());
        if (loadedInitializers != null) {
            for (ServletContainerInitializer service : loadedInitializers) {
                if (this.isFromExcludedJar(context, service)) continue;
                nonExcludedInitializers.add(service);
            }
        }
        return nonExcludedInitializers;
    }

    public void parseContainerPath(final WebAppContext context, AnnotationParser parser) throws Exception {
        LOG.debug("Scanning container jars", new Object[0]);
        this.clearAnnotationList(parser.getAnnotationHandlers());
        ArrayList<URI> containerUris = new ArrayList<URI>();
        for (Resource r : context.getMetaData().getOrderedContainerJars()) {
            URI uri = r.getURI();
            containerUris.add(uri);
        }
        parser.parse(containerUris.toArray(new URI[containerUris.size()]), new ClassNameResolver(){

            @Override
            public boolean isExcluded(String name) {
                if (context.isSystemClass(name)) {
                    return false;
                }
                return context.isServerClass(name);
            }

            @Override
            public boolean shouldOverride(String name) {
                return context.isParentLoaderPriority();
            }
        });
        ArrayList<DiscoveredAnnotation> annotations = new ArrayList<DiscoveredAnnotation>();
        this.gatherAnnotations(annotations, parser.getAnnotationHandlers());
        context.getMetaData().addDiscoveredAnnotations(annotations);
    }

    public void parseWebInfLib(final WebAppContext context, AnnotationParser parser) throws Exception {
        List frags = context.getMetaData().getFragments();
        ArrayList webInfUris = new ArrayList();
        List jars = context.getMetaData().getOrderedWebInfJars();
        if (jars == null || jars.isEmpty()) {
            jars = context.getMetaData().getWebInfJars();
        }
        for (Resource r : jars) {
            this.clearAnnotationList(parser.getAnnotationHandlers());
            URI uri = r.getURI();
            FragmentDescriptor f = this.getFragmentFromJar(r, frags);
            if (f != null && this.isMetaDataComplete((WebDescriptor)f)) continue;
            parser.parse(uri, new ClassNameResolver(){

                @Override
                public boolean isExcluded(String name) {
                    if (context.isSystemClass(name)) {
                        return true;
                    }
                    if (context.isServerClass(name)) {
                        return false;
                    }
                    return false;
                }

                @Override
                public boolean shouldOverride(String name) {
                    return !context.isParentLoaderPriority();
                }
            });
            ArrayList<DiscoveredAnnotation> annotations = new ArrayList<DiscoveredAnnotation>();
            this.gatherAnnotations(annotations, parser.getAnnotationHandlers());
            context.getMetaData().addDiscoveredAnnotations(r, annotations);
        }
    }

    public void parseWebInfClasses(final WebAppContext context, AnnotationParser parser) throws Exception {
        Resource classesDir;
        LOG.debug("Scanning classes in WEB-INF/classes", new Object[0]);
        if (context.getWebInf() != null && (classesDir = context.getWebInf().addPath("classes/")).exists()) {
            this.clearAnnotationList(parser.getAnnotationHandlers());
            parser.parse(classesDir, new ClassNameResolver(){

                @Override
                public boolean isExcluded(String name) {
                    if (context.isSystemClass(name)) {
                        return true;
                    }
                    if (context.isServerClass(name)) {
                        return false;
                    }
                    return false;
                }

                @Override
                public boolean shouldOverride(String name) {
                    return !context.isParentLoaderPriority();
                }
            });
            ArrayList<DiscoveredAnnotation> annotations = new ArrayList<DiscoveredAnnotation>();
            this.gatherAnnotations(annotations, parser.getAnnotationHandlers());
            context.getMetaData().addDiscoveredAnnotations(annotations);
        }
    }

    public FragmentDescriptor getFragmentFromJar(Resource jar, List<FragmentDescriptor> frags) throws Exception {
        FragmentDescriptor d = null;
        for (FragmentDescriptor frag : frags) {
            Resource fragResource = frag.getResource();
            if (!Resource.isContainedIn((Resource)fragResource, (Resource)jar)) continue;
            d = frag;
            break;
        }
        return d;
    }

    public boolean isMetaDataComplete(WebDescriptor d) {
        return d != null && d.getMetaDataComplete() == MetaDataComplete.True;
    }

    protected void clearAnnotationList(List<AnnotationParser.DiscoverableAnnotationHandler> handlers) {
        if (handlers == null) {
            return;
        }
        for (AnnotationParser.DiscoverableAnnotationHandler h : handlers) {
            if (!(h instanceof AbstractDiscoverableAnnotationHandler)) continue;
            ((AbstractDiscoverableAnnotationHandler)h).resetList();
        }
    }

    protected void gatherAnnotations(List<DiscoveredAnnotation> annotations, List<AnnotationParser.DiscoverableAnnotationHandler> handlers) {
        for (AnnotationParser.DiscoverableAnnotationHandler h : handlers) {
            if (!(h instanceof AbstractDiscoverableAnnotationHandler)) continue;
            annotations.addAll(((AbstractDiscoverableAnnotationHandler)h).getAnnotationList());
        }
    }
}

