/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.gui.ShowResultSet;
import org.emboss.jemboss.gui.filetree.FileNode;
import org.emboss.jemboss.gui.filetree.RemoteFileNode;
import org.emboss.jemboss.soap.FileList;
import org.emboss.jemboss.soap.FileRoots;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.PrivateRequest;

public class RemoteDragTree
extends JTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
ActionListener,
Autoscroll {
    private JembossParams mysettings;
    private static FileRoots froots;
    private JPopupMenu popup;
    private String fs = new String(System.getProperty("file.separator"));
    private String ls = new String(System.getProperty("line.separator"));
    private Vector openNode;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private static final int AUTOSCROLL_MARGIN = 45;
    private Insets autoscrollInsets = new Insets(0, 0, 0, 0);

    public RemoteDragTree(final JembossParams jembossParams, FileRoots fileRoots) {
        this.mysettings = jembossParams;
        froots = fileRoots;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.setDropTarget(new DropTarget(this, this));
        DefaultTreeModel defaultTreeModel = this.createTreeModel(" ");
        this.setModel(defaultTreeModel);
        this.createTreeModelListener();
        this.getSelectionModel().setSelectionMode(4);
        this.addMouseListener(new PopupListener());
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Refresh");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.popup.add(new JSeparator());
        JMenu jMenu = new JMenu("Open With");
        this.popup.add(jMenu);
        jMenuItem = new JMenuItem("Jemboss Aligmnment Editor");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Text Editor");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Rename...");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("New Folder...");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete...");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.popup.add(new JSeparator());
        jMenuItem = new JMenuItem("De-select All");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && RemoteDragTree.this.isFileSelection()) {
                    RemoteDragTree.this.setCursor(RemoteDragTree.this.cbusy);
                    RemoteFileNode remoteFileNode = (RemoteFileNode)RemoteDragTree.this.getLastSelectedPathComponent();
                    if (remoteFileNode == null) {
                        return;
                    }
                    if (remoteFileNode.isLeaf()) {
                        RemoteDragTree.showFilePane(remoteFileNode.getFullName(), jembossParams);
                    }
                    RemoteDragTree.this.setCursor(RemoteDragTree.this.cdone);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                if (treePath != null) {
                    RemoteDragTree.this.setCursor(RemoteDragTree.this.cbusy);
                    RemoteFileNode remoteFileNode = (RemoteFileNode)treePath.getLastPathComponent();
                    if (!remoteFileNode.isExplored()) {
                        RemoteDragTree.this.exploreNode(remoteFileNode);
                    }
                    RemoteDragTree.this.setCursor(RemoteDragTree.this.cdone);
                }
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
    }

    public void refreshRoot() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel = this.createTreeModel(" ");
        this.setModel(defaultTreeModel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        RemoteFileNode remoteFileNode = this.getSelectedNode();
        if (remoteFileNode == null) {
            JOptionPane.showMessageDialog(null, "No file selected.", "Warning", 2);
            return;
        }
        String string = remoteFileNode.getFullName();
        String string2 = remoteFileNode.getPathName();
        String string3 = remoteFileNode.getRootDir();
        RemoteFileNode remoteFileNode2 = remoteFileNode;
        if (jMenuItem.getText().equals("Refresh")) {
            this.refreshRoot();
        } else if (jMenuItem.getText().equals("Jemboss Aligmnment Editor")) {
            Vector<String> vector = new Vector<String>();
            String string4 = "fileroot=" + froots.getCurrentRoot();
            vector.addElement(string4);
            vector.addElement(string);
            try {
                PrivateRequest privateRequest = new PrivateRequest(this.mysettings, "EmbreoFile", "get_file", vector);
                AlignJFrame alignJFrame = new AlignJFrame((String)privateRequest.getHash().get("contents"), string);
                alignJFrame.setVisible(true);
            }
            catch (JembossSoapException jembossSoapException) {
                System.out.println("RemoteDragTree :: JembossSoapException " + string);
            }
        } else if (jMenuItem.getText().equals("Text Editor")) {
            RemoteDragTree.showFilePane(string, this.mysettings);
        } else if (jMenuItem.getText().equals("New Folder...")) {
            final String string5 = JOptionPane.showInputDialog(null, "Folder Name", "Create New Folder in", 3);
            String string6 = null;
            if (remoteFileNode.isLeaf()) {
                remoteFileNode2 = (RemoteFileNode)remoteFileNode.getParent();
                string6 = remoteFileNode2.getFullName() + "/" + string5;
            } else {
                string6 = remoteFileNode.getFullName() + "/" + string5;
            }
            String string7 = remoteFileNode2.getServerName();
            if (!string7.endsWith("/")) {
                string7 = string7.concat("/");
            }
            if (this.nodeExists(remoteFileNode2, string7 = string7.concat(string5))) {
                return;
            }
            if (string5 != null && !string5.equals("")) {
                final RemoteFileNode remoteFileNode3 = remoteFileNode2;
                Vector<String> vector = new Vector<String>();
                vector.addElement("fileroot=" + string3);
                vector.addElement(string6);
                try {
                    this.setCursor(this.cbusy);
                    PrivateRequest privateRequest = new PrivateRequest(this.mysettings, "EmbreoFile", "mkdir", vector);
                    this.setCursor(this.cdone);
                    Runnable runnable = new Runnable(){

                        public void run() {
                            RemoteDragTree.this.addObject(remoteFileNode3, string5, true);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
                catch (JembossSoapException jembossSoapException) {
                    this.setCursor(this.cdone);
                }
            }
        } else if (jMenuItem.getText().equals("Delete...")) {
            int n;
            RemoteFileNode[] remoteFileNodeArray = this.getSelectedNodes();
            String string8 = "";
            for (n = 0; n < remoteFileNodeArray.length; ++n) {
                string8 = string8.concat(remoteFileNodeArray[n].getServerName() + this.ls);
            }
            n = JOptionPane.showConfirmDialog(null, "Delete" + this.ls + string8 + "?", "Delete " + string8, 0);
            if (n == 0) {
                for (int i = 0; i < remoteFileNodeArray.length; ++i) {
                    this.deleteNode(remoteFileNodeArray[i]);
                }
            }
        } else if (jMenuItem.getText().equals("De-select All")) {
            this.clearSelection();
        } else if (jMenuItem.getText().equals("Rename...") && remoteFileNode.isLeaf()) {
            String string9 = (String)JOptionPane.showInputDialog(null, "New File Name", "Rename " + string, 3, null, null, string);
            remoteFileNode2 = (RemoteFileNode)remoteFileNode.getParent();
            if (string9 != null && !string9.equals("")) {
                RemoteFileNode remoteFileNode4;
                String string10 = null;
                string10 = string2.endsWith("/") ? string2 + string9 : string2 + "/" + string9;
                String string11 = ((RemoteFileNode)remoteFileNode.getParent()).getFullName();
                if (string9.indexOf("/") > 0) {
                    int n = string9.lastIndexOf("/");
                    string11 = string9.substring(0, n);
                }
                if (!this.nodeExists(remoteFileNode4 = this.getNode(string11), string10)) {
                    this.rename(string3, string, string2, string9, remoteFileNode, remoteFileNode4);
                }
            }
        }
    }

    private void deleteNode(final RemoteFileNode remoteFileNode) {
        this.setCursor(this.cbusy);
        String string = remoteFileNode.getRootDir();
        String string2 = remoteFileNode.getFullName();
        Vector<String> vector = new Vector<String>();
        vector.addElement("fileroot=" + string);
        vector.addElement(string2);
        if (remoteFileNode.isLeaf()) {
            try {
                PrivateRequest privateRequest = new PrivateRequest(this.mysettings, "EmbreoFile", "delFile", vector);
                Runnable runnable = new Runnable(){

                    public void run() {
                        RemoteDragTree.this.deleteObject(remoteFileNode);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
            catch (JembossSoapException jembossSoapException) {
                this.setCursor(this.cdone);
            }
        } else {
            try {
                FileList fileList = new FileList(this.mysettings, string, string2);
                Vector vector2 = fileList.fileVector();
                if (vector2.size() > 0) {
                    JOptionPane.showMessageDialog(null, "Cannot delete" + this.ls + remoteFileNode.getServerName() + this.ls + "this directory is not empty", "Warning", 0);
                } else {
                    PrivateRequest privateRequest = new PrivateRequest(this.mysettings, "EmbreoFile", "delDir", vector);
                    Runnable runnable = new Runnable(){

                        public void run() {
                            RemoteDragTree.this.deleteObject(remoteFileNode);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
            catch (JembossSoapException jembossSoapException) {
                this.setCursor(this.cdone);
            }
        }
        this.setCursor(this.cdone);
    }

    public void exploreNode(RemoteFileNode remoteFileNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        remoteFileNode.explore();
        this.openNode.add(remoteFileNode);
        defaultTreeModel.nodeStructureChanged(remoteFileNode);
    }

    public boolean nodeExists(RemoteFileNode remoteFileNode, String string) {
        RemoteFileNode remoteFileNode2 = this.getChildNode(remoteFileNode, string);
        if (remoteFileNode2 != null) {
            String string2 = System.getProperty("line.separator");
            JOptionPane.showMessageDialog(null, string + string2 + " already exists!", "File Exists", 0);
            return true;
        }
        return false;
    }

    private void rename(String string, String string2, String string3, final String string4, final RemoteFileNode remoteFileNode, final RemoteFileNode remoteFileNode2) {
        Vector<String> vector = new Vector<String>();
        vector.addElement("fileroot=" + string);
        vector.addElement(string2);
        vector.addElement(string3 + "/" + string4);
        try {
            this.setCursor(this.cbusy);
            PrivateRequest privateRequest = new PrivateRequest(this.mysettings, "EmbreoFile", "rename", vector);
            this.setCursor(this.cdone);
            Runnable runnable = new Runnable(){

                public void run() {
                    RemoteDragTree.this.addObject(remoteFileNode2, string4, false);
                    RemoteDragTree.this.deleteObject(remoteFileNode);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        catch (JembossSoapException jembossSoapException) {
            this.setCursor(this.cdone);
        }
    }

    public void addObject(RemoteFileNode remoteFileNode, String string, boolean bl) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        if (remoteFileNode == null) {
            return;
        }
        String string2 = remoteFileNode.getFullName();
        if (string2.equals(" ")) {
            string2 = "";
        }
        if (string.indexOf("/") > -1) {
            string = string.substring(string.lastIndexOf("/") + 1);
        }
        RemoteFileNode remoteFileNode2 = null;
        if (!remoteFileNode.isExplored()) {
            this.exploreNode(remoteFileNode);
            remoteFileNode2 = this.getNode(remoteFileNode.getServerName() + "/" + string);
        } else {
            int n;
            remoteFileNode2 = new RemoteFileNode(this.mysettings, froots, string, null, string2, bl);
            int n2 = n = remoteFileNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                String string3 = ((RemoteFileNode)remoteFileNode.getChildAt(i)).getFile();
                if (string3.compareTo(string) > 0) {
                    n2 = i;
                    break;
                }
                if (string3.compareTo(string) != 0) continue;
                n2 = -1;
                break;
            }
            if (n2 != -1) {
                defaultTreeModel.insertNodeInto(remoteFileNode2, remoteFileNode, n2);
            }
        }
        this.scrollPathToVisible(new TreePath(remoteFileNode2.getPath()));
    }

    public void deleteObject(RemoteFileNode remoteFileNode) {
        RemoteFileNode remoteFileNode2 = (RemoteFileNode)remoteFileNode.getParent();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.removeNodeFromParent(remoteFileNode);
    }

    public byte[] getLocalFile(File file) {
        byte[] byArray = null;
        try {
            long l = file.length();
            byArray = new byte[(int)l];
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read file: " + file);
        }
        return byArray;
    }

    public RemoteFileNode getSelectedNode() {
        TreePath treePath = this.getLeadSelectionPath();
        if (treePath == null) {
            return null;
        }
        RemoteFileNode remoteFileNode = (RemoteFileNode)treePath.getLastPathComponent();
        return remoteFileNode;
    }

    public RemoteFileNode[] getSelectedNodes() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        int n = treePathArray.length;
        RemoteFileNode[] remoteFileNodeArray = new RemoteFileNode[n];
        for (int i = 0; i < n; ++i) {
            remoteFileNodeArray[i] = (RemoteFileNode)treePathArray[i].getLastPathComponent();
        }
        return remoteFileNodeArray;
    }

    public boolean isFileSelection() {
        TreePath treePath = this.getLeadSelectionPath();
        if (treePath == null) {
            return false;
        }
        RemoteFileNode remoteFileNode = (RemoteFileNode)treePath.getLastPathComponent();
        return !remoteFileNode.isDirectory();
    }

    public String getFilename() {
        TreePath treePath = this.getLeadSelectionPath();
        RemoteFileNode remoteFileNode = (RemoteFileNode)treePath.getLastPathComponent();
        return remoteFileNode.getServerName();
    }

    private DefaultTreeModel createTreeModel(String string) {
        this.setCursor(this.cbusy);
        RemoteFileNode remoteFileNode = new RemoteFileNode(this.mysettings, froots, string, null, null);
        remoteFileNode.explore();
        this.openNode = new Vector();
        this.openNode.add(remoteFileNode);
        this.setCursor(this.cdone);
        return new DefaultTreeModel(remoteFileNode);
    }

    private RemoteFileNode getNode(String string) {
        RemoteFileNode remoteFileNode;
        Enumeration enumeration = this.openNode.elements();
        while (enumeration.hasMoreElements()) {
            remoteFileNode = (RemoteFileNode)enumeration.nextElement();
            String string2 = remoteFileNode.getFullName();
            if (!string2.equals(string)) continue;
            return remoteFileNode;
        }
        enumeration = this.openNode.elements();
        while (enumeration.hasMoreElements()) {
            remoteFileNode = this.getChildNode((RemoteFileNode)enumeration.nextElement(), string);
            if (remoteFileNode == null) continue;
            return remoteFileNode;
        }
        return null;
    }

    private RemoteFileNode getChildNode(RemoteFileNode remoteFileNode, String string) {
        Enumeration<TreeNode> enumeration = remoteFileNode.children();
        while (enumeration.hasMoreElements()) {
            RemoteFileNode remoteFileNode2 = (RemoteFileNode)enumeration.nextElement();
            String string2 = remoteFileNode2.getServerName();
            if (!string.equals(string2)) continue;
            return remoteFileNode2;
        }
        return null;
    }

    public static void showFilePane(String string, JembossParams jembossParams) {
        try {
            Vector<String> vector = new Vector<String>();
            String string2 = "fileroot=" + froots.getCurrentRoot();
            vector.addElement(string2);
            vector.addElement(string);
            PrivateRequest privateRequest = new PrivateRequest(jembossParams, "EmbreoFile", "get_file", vector);
            Hashtable<String, byte[]> hashtable = new Hashtable<String, byte[]>();
            Object v = privateRequest.getHash().get("contents");
            if (v instanceof String) {
                hashtable.put(string, ((String)v).getBytes());
            } else {
                hashtable.put(string, (byte[])v);
            }
            ShowResultSet showResultSet = new ShowResultSet(hashtable, jembossParams);
            showResultSet.setTitle("Remote File");
        }
        catch (JembossSoapException jembossSoapException) {
            // empty catch block
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        if (inputEvent instanceof MouseEvent && ((MouseEvent)inputEvent).isPopupTrigger()) {
            return;
        }
        if (this.isFileSelection()) {
            dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, this.getSelectedNode(), this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(FileNode.FILENODE) || dropTargetDragEvent.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE)) {
            dropTargetDragEvent.acceptDrag(3);
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        block15: {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE)) {
                try {
                    Point point = dropTargetDropEvent.getLocation();
                    TreePath treePath = this.getPathForLocation(point.x, point.y);
                    if (treePath == null) break block15;
                    RemoteFileNode remoteFileNode = (RemoteFileNode)transferable.getTransferData(RemoteFileNode.REMOTEFILENODE);
                    remoteFileNode = this.getNode(remoteFileNode.getServerName());
                    Object var6_11 = null;
                    RemoteFileNode remoteFileNode2 = (RemoteFileNode)treePath.getLastPathComponent();
                    String string = remoteFileNode2.getRootDir();
                    String string2 = null;
                    string2 = remoteFileNode2.getFile().equals(" ") ? remoteFileNode.getFile() : remoteFileNode2.getFile() + "/" + remoteFileNode.getFile();
                    if (!this.nodeExists(remoteFileNode2, remoteFileNode2.getServerName() + remoteFileNode.getFile())) {
                        this.rename(remoteFileNode.getRootDir(), remoteFileNode.getFullName(), remoteFileNode2.getPathName(), string2, remoteFileNode, remoteFileNode2);
                    }
                }
                catch (Exception exception) {}
            } else if (transferable.isDataFlavorSupported(FileNode.FILENODE)) {
                try {
                    Point point = dropTargetDropEvent.getLocation();
                    TreePath treePath = this.getPathForLocation(point.x, point.y);
                    if (treePath == null) break block15;
                    FileNode fileNode = (FileNode)transferable.getTransferData(FileNode.FILENODE);
                    File file = fileNode.getFile();
                    String string = null;
                    RemoteFileNode remoteFileNode = (RemoteFileNode)treePath.getLastPathComponent();
                    String string3 = remoteFileNode.getRootDir();
                    RemoteFileNode remoteFileNode3 = remoteFileNode;
                    if (remoteFileNode.isLeaf()) {
                        remoteFileNode3 = (RemoteFileNode)remoteFileNode.getParent();
                        string = remoteFileNode3.getFullName() + "/" + file.getName();
                    } else {
                        string = remoteFileNode.getFullName() + "/" + file.getName();
                    }
                    if (!this.nodeExists(remoteFileNode3, remoteFileNode3.getServerName() + file.getName())) {
                        try {
                            Vector<Object> vector = new Vector<Object>();
                            byte[] byArray = this.getLocalFile(file);
                            vector.addElement("fileroot=" + string3);
                            vector.addElement(string);
                            vector.addElement(byArray);
                            this.setCursor(this.cbusy);
                            PrivateRequest privateRequest = new PrivateRequest(this.mysettings, "EmbreoFile", "put_file", vector);
                            this.setCursor(this.cdone);
                            RemoteFileNode remoteFileNode4 = remoteFileNode;
                            remoteFileNode4 = remoteFileNode4.isLeaf() ? (RemoteFileNode)remoteFileNode.getParent() : remoteFileNode;
                            if (remoteFileNode4.isExplored()) {
                                this.addObject(remoteFileNode4, file.getName(), false);
                                break block15;
                            }
                            this.exploreNode(remoteFileNode4);
                            RemoteFileNode remoteFileNode5 = this.getNode(remoteFileNode4.getServerName() + "/" + file.getName());
                            this.scrollPathToVisible(new TreePath(remoteFileNode5.getPath()));
                        }
                        catch (Exception exception) {
                            this.setCursor(this.cdone);
                            System.out.println("RemoteDragTree: caught exception " + string3 + " Destination: " + string + " Local File " + file.toString());
                        }
                        break block15;
                    }
                    dropTargetDropEvent.rejectDrop();
                }
                catch (Exception exception) {}
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(FileNode.FILENODE)) {
            Point point = dropTargetDragEvent.getLocation();
            TreePath treePath = this.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                dropTargetDragEvent.rejectDrag();
            } else {
                this.setSelectionPath(treePath);
                dropTargetDragEvent.acceptDrag(3);
            }
        } else if (dropTargetDragEvent.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE)) {
            Point point = dropTargetDragEvent.getLocation();
            TreePath treePath = this.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            RemoteFileNode remoteFileNode = (RemoteFileNode)treePath.getLastPathComponent();
            if (!remoteFileNode.isDirectory()) {
                dropTargetDragEvent.rejectDrag();
            } else {
                this.setSelectionPath(treePath);
                dropTargetDragEvent.acceptDrag(3);
            }
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void autoscroll(Point point) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getVisibleRect();
        int n5 = rectangle.y + rectangle.height;
        int n6 = rectangle.x + rectangle.width;
        if (point.y - rectangle.y < 45 && rectangle.y > 0) {
            n = 45;
        }
        if (point.x - rectangle.x < 45 && rectangle.x > 0) {
            n2 = 45;
        }
        if (n5 - point.y < 45 && n5 < dimension.height) {
            n3 = 45;
        }
        if (n6 - point.x < 45 && n6 < dimension.width) {
            n4 = 45;
        }
        rectangle.x += n4 - n2;
        rectangle.y += n3 - n;
        this.scrollRectToVisible(rectangle);
    }

    public Insets getAutoscrollInsets() {
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getVisibleRect();
        this.autoscrollInsets.top = rectangle.y + 45;
        this.autoscrollInsets.left = rectangle.x + 45;
        this.autoscrollInsets.bottom = dimension.height - (rectangle.y + rectangle.height) + 45;
        this.autoscrollInsets.right = dimension.width - (rectangle.x + rectangle.width) + 45;
        return this.autoscrollInsets;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                RemoteDragTree.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

