/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.emboss.jemboss.editor.GraphicSequenceCollection;

public class PrintAlignment {
    public PrintAlignment(GraphicSequenceCollection graphicSequenceCollection) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        PageFormat pageFormat = new PageFormat();
        pageFormat = printerJob.pageDialog(pageFormat);
        int n = this.showOptions(graphicSequenceCollection, pageFormat);
        graphicSequenceCollection.setNumberOfResiduesPerLine(n);
        book.append(graphicSequenceCollection, pageFormat, graphicSequenceCollection.getNumberPages(pageFormat, n));
        printerJob.setPageable(book);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.err.println("Printing error: " + printerException);
            }
        }
    }

    private int showOptions(GraphicSequenceCollection graphicSequenceCollection, PageFormat pageFormat) {
        JPanel jPanel = new JPanel();
        Box box = Box.createHorizontalBox();
        String string = Integer.toString(graphicSequenceCollection.getResiduesPerLine(pageFormat));
        JLabel jLabel = new JLabel("Residues per line: [max:" + string + "]");
        JTextField jTextField = new JTextField(string);
        box.add(jLabel);
        box.add(jTextField);
        box.add(Box.createHorizontalGlue());
        jPanel.add(box);
        JOptionPane.showMessageDialog(null, jPanel, "Options", -1);
        return Integer.parseInt(jTextField.getText());
    }
}

