/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportDisposedIOException;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MasterConnector
implements Service,
BrokerServiceAware {
    private static final Log LOG = LogFactory.getLog(MasterConnector.class);
    private BrokerService broker;
    private URI remoteURI;
    private URI localURI;
    private Transport localBroker;
    private Transport remoteBroker;
    private TransportConnector connector;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean stoppedBeforeStart = new AtomicBoolean(false);
    private final IdGenerator idGenerator = new IdGenerator();
    private String userName;
    private String password;
    private ConnectionInfo connectionInfo;
    private SessionInfo sessionInfo;
    private ProducerInfo producerInfo;
    private final AtomicBoolean masterActive = new AtomicBoolean();
    private BrokerInfo brokerInfo;
    private boolean firstConnection = true;
    private boolean failedToStart;

    public MasterConnector() {
    }

    public MasterConnector(String remoteUri) throws URISyntaxException {
        this.remoteURI = new URI(remoteUri);
    }

    public void setBrokerService(BrokerService broker) {
        List<TransportConnector> transportConnectors;
        this.broker = broker;
        if (this.localURI == null) {
            this.localURI = broker.getVmConnectorURI();
        }
        if (this.connector == null && !(transportConnectors = broker.getTransportConnectors()).isEmpty()) {
            this.connector = transportConnectors.get(0);
        }
    }

    public boolean isSlave() {
        return this.masterActive.get();
    }

    protected void restartBridge() throws Exception {
        this.localBroker.oneway(this.connectionInfo);
        this.remoteBroker.oneway(this.connectionInfo);
        this.localBroker.oneway(this.sessionInfo);
        this.remoteBroker.oneway(this.sessionInfo);
        this.remoteBroker.oneway(this.producerInfo);
        this.remoteBroker.oneway(this.brokerInfo);
    }

    public void start() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        if (this.remoteURI == null) {
            throw new IllegalArgumentException("You must specify a remoteURI");
        }
        this.localBroker = TransportFactory.connect(this.localURI);
        this.remoteBroker = TransportFactory.connect(this.remoteURI);
        LOG.info((Object)("Starting a slave connection between " + this.localBroker + " and " + this.remoteBroker));
        this.localBroker.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object command) {
            }

            public void onException(IOException error) {
                if (MasterConnector.this.started.get()) {
                    MasterConnector.this.serviceLocalException(error);
                }
            }
        });
        this.remoteBroker.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object o) {
                Command command = (Command)o;
                if (MasterConnector.this.started.get()) {
                    MasterConnector.this.serviceRemoteCommand(command);
                }
            }

            public void onException(IOException error) {
                if (MasterConnector.this.started.get()) {
                    MasterConnector.this.serviceRemoteException(error);
                }
            }

            public void transportResumed() {
                try {
                    if (!MasterConnector.this.firstConnection) {
                        MasterConnector.this.localBroker = TransportFactory.connect(MasterConnector.this.localURI);
                        MasterConnector.this.localBroker.setTransportListener(new DefaultTransportListener(){

                            public void onCommand(Object command) {
                            }

                            public void onException(IOException error) {
                                if (MasterConnector.this.started.get()) {
                                    MasterConnector.this.serviceLocalException(error);
                                }
                            }
                        });
                        MasterConnector.this.localBroker.start();
                        MasterConnector.this.restartBridge();
                        LOG.info((Object)("Slave connection between " + MasterConnector.this.localBroker + " and " + MasterConnector.this.remoteBroker + " has been reestablished."));
                    } else {
                        MasterConnector.this.firstConnection = false;
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"MasterConnector failed to send BrokerInfo in transportResumed:", (Throwable)e);
                }
                catch (Exception e) {
                    LOG.error((Object)"MasterConnector failed to restart localBroker in transportResumed:", (Throwable)e);
                }
            }
        });
        try {
            this.localBroker.start();
            this.remoteBroker.start();
            this.startBridge();
            this.masterActive.set(true);
        }
        catch (Exception e) {
            this.masterActive.set(false);
            if (!this.stoppedBeforeStart.get()) {
                LOG.error((Object)("Failed to start network bridge: " + e), (Throwable)e);
            } else {
                LOG.info((Object)"Slave stopped before connected to the master.");
            }
            this.setFailedToStart(true);
        }
    }

    protected void startBridge() throws Exception {
        this.connectionInfo = new ConnectionInfo();
        this.connectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
        this.connectionInfo.setClientId(this.idGenerator.generateId());
        this.connectionInfo.setUserName(this.userName);
        this.connectionInfo.setPassword(this.password);
        this.connectionInfo.setBrokerMasterConnector(true);
        this.sessionInfo = new SessionInfo(this.connectionInfo, 1L);
        this.producerInfo = new ProducerInfo(this.sessionInfo, 1L);
        this.producerInfo.setResponseRequired(false);
        this.brokerInfo = this.connector != null ? this.connector.getBrokerInfo() : new BrokerInfo();
        this.brokerInfo.setBrokerName(this.broker.getBrokerName());
        this.brokerInfo.setPeerBrokerInfos(this.broker.getBroker().getPeerBrokerInfos());
        this.brokerInfo.setSlaveBroker(true);
        this.brokerInfo.setPassiveSlave(this.broker.isPassiveSlave());
        this.restartBridge();
        LOG.info((Object)("Slave connection between " + this.localBroker + " and " + this.remoteBroker + " has been established."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (!this.started.compareAndSet(true, false) || !this.masterActive.get()) {
            return;
        }
        this.masterActive.set(false);
        try {
            this.remoteBroker.oneway(new ShutdownInfo());
            this.localBroker.oneway(new ShutdownInfo());
        }
        catch (IOException e) {
            LOG.debug((Object)"Caught exception stopping", (Throwable)e);
        }
        finally {
            ServiceStopper ss = new ServiceStopper();
            ss.stop(this.localBroker);
            ss.stop(this.remoteBroker);
            ss.throwFirstException();
        }
    }

    public void stopBeforeConnected() throws Exception {
        this.masterActive.set(false);
        this.started.set(false);
        this.stoppedBeforeStart.set(true);
        ServiceStopper ss = new ServiceStopper();
        ss.stop(this.localBroker);
        ss.stop(this.remoteBroker);
    }

    protected void serviceRemoteException(IOException error) {
        LOG.error((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown: " + error.getMessage()), (Throwable)error);
        this.shutDown();
    }

    protected void serviceRemoteCommand(Command command) {
        try {
            if (command.isMessageDispatch()) {
                MessageDispatch md = (MessageDispatch)command;
                command = md.getMessage();
            }
            if (command.getDataStructureType() == 11) {
                LOG.warn((Object)"The Master has shutdown");
                this.shutDown();
            } else {
                boolean responseRequired = command.isResponseRequired();
                int commandId = command.getCommandId();
                if (responseRequired) {
                    Response response = (Response)this.localBroker.request(command);
                    response.setCorrelationId(commandId);
                    this.remoteBroker.oneway(response);
                } else {
                    this.localBroker.oneway(command);
                }
            }
        }
        catch (IOException e) {
            this.serviceRemoteException(e);
        }
    }

    protected void serviceLocalException(Throwable error) {
        if (!(error instanceof TransportDisposedIOException) || this.localBroker.isDisposed()) {
            LOG.info((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown: " + error.getMessage()), error);
            ServiceSupport.dispose(this);
        } else {
            LOG.info((Object)error.getMessage());
        }
    }

    public URI getLocalURI() {
        return this.localURI;
    }

    public void setLocalURI(URI localURI) {
        this.localURI = localURI;
    }

    public URI getRemoteURI() {
        return this.remoteURI;
    }

    public void setRemoteURI(URI remoteURI) {
        this.remoteURI = remoteURI;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    private void shutDown() {
        this.masterActive.set(false);
        this.broker.masterFailed();
        ServiceSupport.dispose(this);
    }

    public boolean isStoppedBeforeStart() {
        return this.stoppedBeforeStart.get();
    }

    public boolean isFailedToStart() {
        return this.failedToStart;
    }

    public void setFailedToStart(boolean failedToStart) {
        this.failedToStart = failedToStart;
    }
}

