/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.DynamicIndexCreator;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.interval.IntervalIndexCreator;
import org.broad.tribble.index.interval.IntervalTreeIndex;
import org.broad.tribble.index.linear.LinearIndex;
import org.broad.tribble.index.linear.LinearIndexCreator;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;
import org.broad.tribble.util.ParsingUtils;

public class IndexFactory {
    private static Logger log = Logger.getLogger(IndexFactory.class);

    public static Index loadIndex(String indexFile) {
        Index idx = null;
        InputStream is = null;
        FilterInputStream dis = null;
        try {
            try {
                is = indexFile.endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(ParsingUtils.openInputStream(indexFile)), 512000) : new BufferedInputStream(ParsingUtils.openInputStream(indexFile), 512000);
                dis = new LittleEndianInputStream(is);
                int magicNumber = ((LittleEndianInputStream)dis).readInt();
                int type = ((LittleEndianInputStream)dis).readInt();
                Class indexClass = IndexType.getIndexType(type).getIndexType();
                idx = (Index)indexClass.newInstance();
                idx.read((LittleEndianInputStream)dis);
            }
            catch (IOException ex) {
                throw new TribbleException.UnableToReadIndexFile("Unable to read index file", indexFile, ex);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error closing indexFile: " + indexFile), (Throwable)e);
            }
        }
        return idx;
    }

    public static Index createLinearIndex(File inputFile, FeatureCodec codec) {
        return IndexFactory.createIndex(inputFile, codec, IndexType.LINEAR);
    }

    public static Index createLinearIndex(File inputFile, FeatureCodec codec, int binSize) {
        return IndexFactory.createIndex(inputFile, codec, IndexType.LINEAR, binSize);
    }

    public static Index createIntervalIndex(File inputFile, FeatureCodec codec) {
        return IndexFactory.createIndex(inputFile, codec, IndexType.INTERVAL_TREE);
    }

    public static Index createIntervalIndex(File inputFile, FeatureCodec codec, int binSize) {
        return IndexFactory.createIndex(inputFile, codec, IndexType.INTERVAL_TREE, binSize);
    }

    public static Index createDynamicIndex(File inputFile, FeatureCodec codec) {
        return IndexFactory.createDynamicIndex(inputFile, codec, IndexBalanceApproach.FOR_SEEK_TIME);
    }

    public static Index createIndex(File inputFile, FeatureCodec codec, IndexType type) {
        return IndexFactory.createIndex(inputFile, codec, type, type.getDefaultBinSize());
    }

    public static Index createIndex(File inputFile, FeatureCodec codec, IndexType type, int binSize) {
        if (!type.canCreate()) {
            throw new TribbleException("Tribble can only read, not create indices of type " + type.name());
        }
        IndexCreator idx = type.getIndexCreator();
        idx.initialize(inputFile, binSize);
        return IndexFactory.createIndex(new FeatureIterator(inputFile, codec), idx);
    }

    public static void writeIndex(Index idx, File idxFile) throws IOException {
        FilterOutputStream stream = null;
        try {
            stream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(idxFile)));
            idx.write((LittleEndianOutputStream)stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static Index createDynamicIndex(File inputFile, FeatureCodec codec, IndexBalanceApproach iba) {
        DynamicIndexCreator indexCreator = new DynamicIndexCreator(iba);
        indexCreator.initialize(inputFile, indexCreator.defaultBinSize());
        return IndexFactory.createIndex(new FeatureIterator(inputFile, codec), indexCreator);
    }

    private static Index createIndex(FeatureIterator iterator, IndexCreator creator) {
        while (iterator.hasNext()) {
            long position = iterator.getPosition();
            creator.addFeature(iterator.next(), position);
        }
        iterator.close();
        return creator.finalizeIndex(iterator.getPosition());
    }

    static class FeatureIterator
    implements CloseableTribbleIterator<Feature> {
        private PositionalBufferedStream stream;
        private Feature nextFeature;
        private final FeatureCodec codec;
        private final File inputFile;
        private long cachedPosition;

        public FeatureIterator(File inputFile, FeatureCodec codec) {
            this.codec = codec;
            this.inputFile = inputFile;
            FeatureCodecHeader header = this.readHeader();
            this.stream = this.initStream(inputFile, header.getHeaderEnd());
            this.readNextFeature();
        }

        private FeatureCodecHeader readHeader() {
            try {
                PositionalBufferedStream pbs = this.initStream(this.inputFile, 0L);
                FeatureCodecHeader header = this.codec.readHeader(pbs);
                pbs.close();
                return header;
            }
            catch (IOException e) {
                throw new TribbleException.InvalidHeader("Error reading header " + e.getMessage());
            }
        }

        private PositionalBufferedStream initStream(File inputFile, long skip) {
            try {
                FileInputStream is = new FileInputStream(inputFile);
                PositionalBufferedStream pbs = new PositionalBufferedStream(is);
                if (skip > 0L) {
                    pbs.skip(skip);
                }
                return pbs;
            }
            catch (FileNotFoundException e) {
                throw new TribbleException.FeatureFileDoesntExist("Unable to open the input file, most likely the file doesn't exist.", inputFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new TribbleException.MalformedFeatureFile("Error initializing stream", inputFile.getAbsolutePath(), e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextFeature != null;
        }

        @Override
        public Feature next() {
            Feature ret = this.nextFeature;
            this.readNextFeature();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("We cannot remove");
        }

        public long getPosition() {
            return this.hasNext() ? this.cachedPosition : this.stream.getPosition();
        }

        @Override
        public Iterator<Feature> iterator() {
            return this;
        }

        @Override
        public void close() {
            this.stream.close();
        }

        private void readNextFeature() {
            this.cachedPosition = this.stream.getPosition();
            try {
                this.nextFeature = null;
                while (!this.stream.isDone() && this.nextFeature == null) {
                    this.nextFeature = this.codec.decodeLoc(this.stream);
                }
            }
            catch (IOException e) {
                throw new TribbleException.MalformedFeatureFile("Unable to read a line from the file", this.inputFile.getAbsolutePath(), e);
            }
        }
    }

    public static enum IndexBalanceApproach {
        FOR_SIZE,
        FOR_SEEK_TIME;

    }

    public static enum IndexType {
        LINEAR(1, LinearIndexCreator.class, LinearIndex.class, LinearIndexCreator.DEFAULT_BIN_WIDTH),
        INTERVAL_TREE(2, IntervalIndexCreator.class, IntervalTreeIndex.class, IntervalIndexCreator.DEFAULT_FEATURE_COUNT),
        TABIX(3, null, null, -1);

        private final int indexValue;
        private final Class<IndexCreator> indexCreatorClass;
        private final int defaultBinSize;
        private final Class<Index> indexType;

        public int getDefaultBinSize() {
            return this.defaultBinSize;
        }

        public IndexCreator getIndexCreator() {
            try {
                return this.indexCreatorClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new TribbleException("Couldn't make index creator in " + (Object)((Object)this), e);
            }
            catch (IllegalAccessException e) {
                throw new TribbleException("Couldn't make index creator in " + (Object)((Object)this), e);
            }
        }

        public boolean canCreate() {
            return this.indexCreatorClass != null;
        }

        private IndexType(int headerValue, Class creator, Class indexClass, int defaultBinSize) {
            this.indexValue = headerValue;
            this.indexCreatorClass = creator;
            this.indexType = indexClass;
            this.defaultBinSize = defaultBinSize;
        }

        public int getHeaderValue() {
            return this.indexValue;
        }

        public Class getIndexType() {
            return this.indexType;
        }

        public static IndexType getIndexType(int headerValue) {
            IndexType[] indexTypeArray = IndexType.values();
            int n = indexTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IndexType type = indexTypeArray[n2];
                if (type.indexValue == headerValue) {
                    return type;
                }
                ++n2;
            }
            throw new TribbleException.UnableToCreateCorrectIndexType("Unknown index type value" + headerValue);
        }
    }
}

