/*
 * Drawable.java
 *
 * Created on 30. toukokuuta 2006, 20:03
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package threed;

import java.awt.Graphics;

/**
 *
 * @author esa
 */
abstract public class Drawable 
        implements Comparable<Drawable> {
    
    // Coordinates in camera space
    public double[][] visualisationCoords;
    // Coordinates on the projection plane
    public double[][] projectedCoords;
    // Coordinates on the screen
    public int[][] deviceCoords;
    // Coordinates in the original data space
    public double[][] dataCoords;
    
    public boolean selected = false;
    public boolean hidden = false;
    
    protected java.awt.Color color;
    public String text;
    protected double[] distanceFromCamera;
    
    /**
     * 
     * @param g 
     * @param width 
     * @param height 
     */
    abstract public void draw(Graphics g, int width, int height);
    /**
     * 
     * @param camera 
     * @param planeDistance 
     * @param viewWindowWidth 
     * @param viewWindowHeight 
     */
    abstract public void setDistanceFromCamera(
            double[] camera, 
            double planeDistance,
            double viewWindowWidth,
            double viewWindowHeight);
    
    /**
     * 
     * @return 
     */
    public double[] getDistanceFromCamera() {
        return distanceFromCamera;
    }
    
    /**
     * 
     * @param other 
     * @return 
     */
    public int compareTo(Drawable other) {
        double thisMax = Double.MIN_VALUE;
        double otherMin = Double.MAX_VALUE;
        double[] d2 = other.getDistanceFromCamera();
        
        for (int i=0; i < distanceFromCamera.length; ++i) {
            if (distanceFromCamera[i] > thisMax)
                thisMax = distanceFromCamera[i];
        }
        for (int i=0; i < d2.length; ++i) {
            if (d2[i] < otherMin)
                otherMin = d2[i];
        }
        
        if (thisMax < otherMin)
            return 1;
        if (thisMax > otherMin)
            return -1;
        
        return 0;
    }

}
