/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.sequenceChooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.emboss.jemboss.gui.form.TextFieldInt;
import org.emboss.jemboss.gui.sequenceChooser.FileChooser;

public class InputSequenceAttributes {
    private TextFieldInt sbeg = new TextFieldInt();
    private TextFieldInt send = new TextFieldInt();
    private JTextField UFO = new JTextField();
    private JComboBox dbs;
    private JComboBox fileFormats;
    private JRadioButton rev;
    private JRadioButton nucleotide;
    private JRadioButton protein;
    private JRadioButton lower;
    private JRadioButton upper;
    private JScrollPane rscroll;
    private String[] ff = new String[]{"unspecified", "text", "fasta", "msf", "gcg", "gcg8", "embl", "swiss", "ncbi", "pearson", "genbank", "nbrf", "pir", "codata", "strider", "clustal", "aln", "phylip", "acedb", "dbid", "hennig86", "jackknifer", "jackknifernon", "nexus", "nexusnon", "paup", "paupnon", "treecon", "mega", "meganon", "ig", "experiment", "staden", "plain", "gff", "raw", "selex"};

    public InputSequenceAttributes(String[] stringArray, final FileChooser fileChooser) {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.rscroll = new JScrollPane(jPanel);
        Box box = new Box(1);
        jPanel.add((Component)box, "Center");
        JLabel jLabel = new JLabel("Sequence Attributes");
        jLabel.setForeground(Color.red);
        jLabel.setFont(new Font("SansSerif", 1, 13));
        Box box2 = new Box(0);
        box.add(box2);
        box2.add(jLabel);
        box2.add(Box.createHorizontalGlue());
        this.sbeg.setPreferredSize(new Dimension(50, 28));
        this.sbeg.setMaximumSize(new Dimension(50, 28));
        this.send.setPreferredSize(new Dimension(50, 28));
        this.send.setMaximumSize(new Dimension(50, 28));
        box.add(Box.createRigidArea(new Dimension(0, 3)));
        box2 = new Box(0);
        box2.add(Box.createRigidArea(new Dimension(3, 0)));
        box.add(box2);
        this.dbs = new JComboBox<String>(stringArray);
        this.dbs.insertItemAt("unspecified", 0);
        this.dbs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                if (!string.equalsIgnoreCase("unspecified")) {
                    fileChooser.setText(string + ":");
                }
            }
        });
        Dimension dimension = this.dbs.getMinimumSize();
        this.dbs.setPreferredSize(dimension);
        this.dbs.setMaximumSize(dimension);
        this.dbs.setSelectedIndex(0);
        box2.add(this.dbs);
        box2.add(Box.createRigidArea(new Dimension(2, 0)));
        jLabel = new JLabel("Databases available");
        jLabel.setForeground(Color.black);
        box2.add(jLabel);
        box2.add(Box.createHorizontalGlue());
        box.add(Box.createRigidArea(new Dimension(0, 3)));
        box2 = new Box(0);
        box2.add(Box.createRigidArea(new Dimension(3, 0)));
        box.add(box2);
        this.fileFormats = new JComboBox<String>(this.ff);
        this.fileFormats.setPreferredSize(dimension);
        this.fileFormats.setMaximumSize(dimension);
        this.fileFormats.setSelectedIndex(0);
        box2.add(this.fileFormats);
        box2.add(Box.createRigidArea(new Dimension(2, 0)));
        jLabel = new JLabel("Sequence format");
        jLabel.setForeground(Color.black);
        box2.add(jLabel);
        box2.add(Box.createHorizontalGlue());
        box.add(Box.createRigidArea(new Dimension(0, 3)));
        box2 = new Box(0);
        box.add(box2);
        box2.add(Box.createRigidArea(new Dimension(3, 0)));
        box2.add(this.sbeg);
        box2.add(Box.createRigidArea(new Dimension(2, 0)));
        jLabel = new JLabel("begin");
        jLabel.setForeground(Color.black);
        box2.add(jLabel);
        box2.add(Box.createHorizontalGlue());
        box.add(Box.createRigidArea(new Dimension(0, 3)));
        box2 = new Box(0);
        box.add(box2);
        box2.add(Box.createRigidArea(new Dimension(3, 0)));
        box2.add(this.send);
        box2.add(Box.createRigidArea(new Dimension(2, 0)));
        jLabel = new JLabel("end");
        jLabel.setForeground(Color.black);
        box2.add(jLabel);
        box2.add(Box.createHorizontalGlue());
        box.add(Box.createRigidArea(new Dimension(0, 3)));
        box2 = new Box(0);
        this.rev = new JRadioButton("reverse complement");
        this.rev.setSelected(false);
        box2.add(Box.createRigidArea(new Dimension(3, 0)));
        box2.add(this.rev);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 3)));
        box2 = new Box(0);
        this.nucleotide = new JRadioButton("nucleotide");
        this.nucleotide.setSelected(false);
        box2.add(Box.createRigidArea(new Dimension(3, 0)));
        box2.add(this.nucleotide);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 3)));
        box2 = new Box(0);
        this.protein = new JRadioButton("protein");
        this.protein.setSelected(false);
        box2.add(Box.createRigidArea(new Dimension(3, 0)));
        box2.add(this.protein);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.nucleotide);
        buttonGroup.add(this.protein);
        box.add(Box.createRigidArea(new Dimension(0, 3)));
        box2 = new Box(0);
        this.lower = new JRadioButton("Make lower case");
        this.lower.setSelected(false);
        box2.add(Box.createRigidArea(new Dimension(3, 0)));
        box2.add(this.lower);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 3)));
        box2 = new Box(0);
        this.upper = new JRadioButton("Make upper case");
        this.lower.setSelected(false);
        box2.add(Box.createRigidArea(new Dimension(3, 0)));
        box2.add(this.upper);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.upper);
        buttonGroup.add(this.lower);
        this.UFO = new JTextField();
        this.UFO.setPreferredSize(new Dimension(100, 30));
        this.UFO.setMaximumSize(new Dimension(100, 30));
        box.add(Box.createRigidArea(new Dimension(0, 3)));
        box2 = new Box(0);
        box.add(box2);
        box2.add(Box.createRigidArea(new Dimension(3, 0)));
        box2.add(this.UFO);
        box2.add(Box.createRigidArea(new Dimension(2, 0)));
        jLabel = new JLabel("UFO features");
        jLabel.setForeground(Color.black);
        box2.add(jLabel);
        box2.add(Box.createHorizontalGlue());
    }

    public JScrollPane getJScrollPane() {
        return this.rscroll;
    }

    public void setBegSeq(int n) {
        this.sbeg.setValue(n);
    }

    public void setEndSeq(int n) {
        this.send.setValue(n);
    }

    public void setBegSeq(String string) {
        this.sbeg.setText(string);
    }

    public void setEndSeq(String string) {
        this.send.setText(string);
    }

    public String getBegSeq() {
        return this.sbeg.getText();
    }

    public String getEndSeq() {
        return this.send.getText();
    }

    public boolean isBeginSeqDefault() {
        return this.sbeg.getText() == null || this.sbeg.getText().equals("");
    }

    public boolean isEndSeqDefault() {
        return this.send.getText() == null || this.sbeg.getText().equals("");
    }

    public boolean isUFODefault() {
        return this.UFO.getText() == null || this.UFO.getText().equals("");
    }

    public String getFormatChoosen() {
        return (String)this.fileFormats.getSelectedItem();
    }

    public String getInputSeqAttr(int n) {
        String string = " ";
        if (!this.isBeginSeqDefault()) {
            string = string.concat(" -sbegin" + n + " " + this.sbeg.getValue());
        }
        if (!this.isEndSeqDefault()) {
            string = string.concat(" -send" + n + " " + this.send.getValue());
        }
        if (!this.getFormatChoosen().equals("unspecified")) {
            string = string.concat(" -sformat" + n + " " + this.getFormatChoosen());
        }
        if (this.rev.isSelected()) {
            string = string.concat(" -srev" + n);
        }
        if (this.nucleotide.isSelected()) {
            string = string.concat(" -snucleotide" + n);
        }
        if (this.protein.isSelected()) {
            string = string.concat(" -sprotein" + n);
        }
        if (this.lower.isSelected()) {
            string = string.concat(" -slower" + n);
        }
        if (this.upper.isSelected()) {
            string = string.concat(" -supper" + n);
        }
        if (!this.isUFODefault()) {
            string = string.concat(" -sufo" + n + " " + this.UFO.getText());
        }
        return string;
    }
}

