/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.editor.ColourMenu;
import org.emboss.jemboss.editor.ColourPanel;
import org.emboss.jemboss.gui.ScrollPanel;

public class ColourJFrame
extends JFrame {
    private JPopupMenu popup;
    private Box YBox = new Box(1);
    private Hashtable colourTable;
    private JScrollPane jspColour;
    private AlignJFrame align;

    public ColourJFrame(AlignJFrame alignJFrame) {
        super("Colour");
        this.align = alignJFrame;
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        ScrollPanel scrollPanel = new ScrollPanel(new BorderLayout());
        scrollPanel.add(this.YBox);
        this.jspColour = new JScrollPane(scrollPanel);
        jPanel.add(this.jspColour);
        scrollPanel.setBackground(Color.white);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenu.add(new JSeparator());
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColourJFrame.this.setVisible(false);
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.setSize(70, 150);
    }

    public void setCurrentColour(Hashtable hashtable) {
        this.colourTable = hashtable;
        this.YBox.removeAll();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Box box = new Box(0);
            JLabel jLabel = new JLabel(string);
            jLabel.setPreferredSize(new Dimension(20, 20));
            jLabel.setMaximumSize(new Dimension(20, 20));
            box.add(jLabel);
            ResidueColourPanel residueColourPanel = new ResidueColourPanel(string, (Color)hashtable.get(string));
            box.add(residueColourPanel);
            this.YBox.add(box);
        }
        this.YBox.add(Box.createVerticalGlue());
        this.jspColour.getViewport().setViewPosition(new Point(0, 0));
    }

    public Hashtable getCurrentColourScheme() {
        return this.colourTable;
    }

    class ResidueColourPanel
    extends ColourPanel {
        private String res;

        public ResidueColourPanel(String string, Color color) {
            super(string + " Colour", color);
            this.res = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ColourMenu colourMenu = (ColourMenu)actionEvent.getSource();
            this.col = colourMenu.getColor();
            this.repaint();
            ColourJFrame.this.colourTable.remove(this.res);
            ColourJFrame.this.colourTable.put(this.res, this.col);
            ColourJFrame.this.align.repaintSequences(ColourJFrame.this.colourTable);
        }
    }
}

