/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.handlers;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.handlers.DataBeanHandlerBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;

public class LocalFileDataBeanHandler
extends DataBeanHandlerBase {
    public LocalFileDataBeanHandler(DataManager dataManager) {
        super(dataManager, DataBean.StorageMethod.LOCAL_USER, DataBean.StorageMethod.LOCAL_TEMP);
    }

    @Override
    public InputStream getInputStream(DataBean dataBean) throws FileNotFoundException {
        this.checkCompatibility(dataBean);
        return new BufferedInputStream(new FileInputStream(this.getFile(dataBean)));
    }

    @Override
    public OutputStream getOutputStream(DataBean dataBean) throws IOException {
        this.checkCompatibility(dataBean);
        return new BufferedOutputStream(new FileOutputStream(this.getFile(dataBean)));
    }

    @Override
    public long getContentLength(DataBean dataBean) {
        this.checkCompatibility(dataBean);
        return this.getFile(dataBean).length();
    }

    @Override
    public void delete(DataBean dataBean) {
        if (dataBean.getStorageMethod().equals((Object)DataBean.StorageMethod.LOCAL_TEMP)) {
            this.checkCompatibility(dataBean);
            File file = this.getFile(dataBean);
            file.delete();
        }
    }

    @Override
    protected void checkCompatibility(DataBean dataBean) throws IllegalArgumentException {
        super.checkCompatibility(dataBean);
        URL url = dataBean.getContentUrl();
        if (url == null) {
            throw new IllegalArgumentException("DataBean url is null.");
        }
        if (!"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Protocol of " + url.toString() + " is not \"file\".");
        }
        if (url.getPath() == null || url.getPath().length() == 0) {
            throw new IllegalArgumentException("Illegal path:" + url.toString());
        }
    }

    public File getFile(DataBean dataBean) {
        File file;
        try {
            file = new File(dataBean.getContentUrl().toURI());
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(dataBean.getContentUrl() + " does not point to a file.");
        }
        return file;
    }
}

