/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.util;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.TsvLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.ChromosomeNormaliser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.util.StringUtils;

public class TsvSorter {
    private int chrCol;
    private int bpCol;
    private ChromosomeNormaliser chromosomeNormaliser = new ChromosomeNormaliser(){

        @Override
        public String normaliseChromosome(String chromosomeName) {
            return chromosomeName.replace("chr", "").replace(".fa", "");
        }
    };
    private TsvLineParser parser;

    public void sort(File in, File out, int chrColumn, int startColumn) throws Exception {
        this.chrCol = chrColumn;
        this.bpCol = startColumn;
        this.externalSort(in, out);
    }

    public void sort(File in, File out, int chrColumn, int startColumn, TsvLineParser parser) throws Exception {
        this.parser = parser;
        this.sort(in, out, chrColumn, startColumn);
    }

    public void sort(File in, File out, ChromosomeNormaliser chromosomeNormaliser, int chrColumn, int startColumn, TsvLineParser parser) throws Exception {
        this.chromosomeNormaliser = chromosomeNormaliser;
        this.sort(in, out, chrColumn, startColumn, parser);
    }

    private void externalSort(File infile, File outfile) throws IOException, GBrowserException {
        BufferedReader initReader = new BufferedReader(new FileReader(infile));
        String header = "";
        if (this.parser != null) {
            String line;
            while ((line = initReader.readLine()) != null) {
                this.parser.setLine(line);
                if (this.parser.isContentLine()) break;
                header = header + line + "\n";
            }
            initReader.close();
            initReader = new BufferedReader(new FileReader(infile));
            for (int i = 0; i < StringUtils.countOccurrencesOf((String)header, (String)"\n"); ++i) {
                initReader.readLine();
            }
        }
        ArrayList<Row> rowBatch = new ArrayList<Row>(500000);
        boolean quit = false;
        int numFiles = 0;
        while (!quit) {
            String line;
            for (int size = 0; size < 100000000; size += line.length()) {
                line = initReader.readLine();
                if (line == null) {
                    quit = true;
                    break;
                }
                rowBatch.add(new Row(line));
            }
            Collections.sort(rowBatch);
            FileWriter fw = new FileWriter(infile + "_chunk" + numFiles);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < rowBatch.size(); ++i) {
                bw.append(((Row)rowBatch.get((int)i)).line + "\n");
            }
            bw.close();
            ++numFiles;
            rowBatch.clear();
        }
        this.mergeFiles(infile.getAbsolutePath(), outfile, numFiles, header);
        initReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeFiles(String inputFilePath, File outputFilePath, int numChunkFiles, String header) throws IOException, GBrowserException {
        int i;
        ArrayList<BufferedReader> mergefbr = new ArrayList<BufferedReader>();
        ArrayList<Row> filerows = new ArrayList<Row>();
        FileWriter fw = new FileWriter(outputFilePath);
        BufferedWriter bw = new BufferedWriter(fw);
        try {
            if (!header.isEmpty()) {
                bw.append(header);
            }
            boolean someFileStillHasRows = false;
            for (int i2 = 0; i2 < numChunkFiles; ++i2) {
                mergefbr.add(new BufferedReader(new FileReader(inputFilePath + "_chunk" + i2)));
                String line = ((BufferedReader)mergefbr.get(i2)).readLine();
                if (line != null) {
                    filerows.add(new Row(line));
                    someFileStillHasRows = true;
                    continue;
                }
                filerows.add(null);
            }
            while (someFileStillHasRows) {
                int i3;
                Row min;
                int minIndex = 0;
                Row row = (Row)filerows.get(0);
                if (row != null) {
                    min = row;
                    minIndex = 0;
                } else {
                    min = null;
                    minIndex = -1;
                }
                for (i3 = 1; i3 < filerows.size(); ++i3) {
                    row = (Row)filerows.get(i3);
                    if (min != null) {
                        if (row == null || row.compareTo(min) >= 0) continue;
                        minIndex = i3;
                        min = (Row)filerows.get(i3);
                        continue;
                    }
                    if (row == null) continue;
                    min = row;
                    minIndex = i3;
                }
                if (minIndex < 0) {
                    someFileStillHasRows = false;
                } else {
                    bw.append(((Row)filerows.get((int)minIndex)).line + "\n");
                    String line = ((BufferedReader)mergefbr.get(minIndex)).readLine();
                    if (line != null) {
                        filerows.set(minIndex, new Row(line));
                    } else {
                        filerows.set(minIndex, null);
                    }
                }
                for (i3 = 0; i3 < filerows.size(); ++i3) {
                    someFileStillHasRows = false;
                    if (filerows.get(i3) == null) continue;
                    if (minIndex < 0) {
                        bw.close();
                        throw new GBrowserException("Error in sorting: mindex lt 0 and found row not null" + filerows.get(i3));
                    }
                    someFileStillHasRows = true;
                    break;
                }
                if (someFileStillHasRows) continue;
                for (i3 = 0; i3 < filerows.size(); ++i3) {
                    String line;
                    if (filerows.get(i3) != null || (line = ((BufferedReader)mergefbr.get(i3)).readLine()) == null) continue;
                    someFileStillHasRows = true;
                    filerows.set(i3, new Row(line));
                }
            }
        }
        finally {
            IOUtils.closeIfPossible(bw);
            IOUtils.closeIfPossible(fw);
        }
        for (i = 0; i < mergefbr.size(); ++i) {
            ((BufferedReader)mergefbr.get(i)).close();
        }
        for (i = 0; i < numChunkFiles; ++i) {
            File f = new File(inputFilePath + "_chunk" + i);
            f.delete();
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            File in = new File(args[0]);
            File out = new File(args[1]);
            int chr = Integer.parseInt(args[2]);
            int start = Integer.parseInt(args[3]);
            new TsvSorter().sort(in, out, chr, start);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("usage: \n  TsvSorter <file-in> <file-out> <chr-column> <start-position-column>\n  Column indexes start from 0\n\nexample:\n   java -cp chipster-2.7.1.jar fi.csc.microarray.client.visualisation.methods.gbrowser.util.TsvSorter Homo_sapiens.GRCh37.70.gtf Homo_sapiens.GRCh37.70-sort.gtf 0 3");
        }
    }

    private class Row
    extends BpCoord {
        public String line;

        public Row(String line) {
            String chrStr;
            super(null, null);
            this.line = line;
            String[] splitted = line.split("\t");
            String string = chrStr = splitted.length > TsvSorter.this.chrCol ? splitted[TsvSorter.this.chrCol] : "";
            if (!chrStr.isEmpty()) {
                splitted[((TsvSorter)TsvSorter.this).chrCol] = chrStr = TsvSorter.this.chromosomeNormaliser.normaliseChromosome(chrStr);
                this.line = Strings.delimit(Arrays.asList(splitted), "\t");
            }
            String bpStr = splitted.length > TsvSorter.this.bpCol ? splitted[TsvSorter.this.bpCol] : "";
            this.chr = new Chromosome(chrStr);
            this.bp = bpStr.isEmpty() ? Long.valueOf(-1L) : Long.valueOf(Long.parseLong(bpStr));
        }
    }
}

