/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.util;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BedLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineReader;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.util.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RegionOperations {
    private static final String EMPTY_EXTRA_FIELDS = "";
    public static PairPolicy ORIGINALS_PAIR_POLICY = new PairPolicy(){

        @Override
        public void process(RegionContent left, RegionContent right, LinkedList<RegionContent> collector) {
            collector.add(left);
            collector.add(right);
        }
    };
    public static PairPolicy MERGE_PAIR_POLICY = new PairPolicy(){

        @Override
        public void process(RegionContent left, RegionContent right, LinkedList<RegionContent> collector) {
            collector.add(new RegionContent(left.region.merge(right.region), RegionOperations.getEmptyExtraFieldMap()));
        }
    };
    public static PairPolicy LEFT_PAIR_POLICY = new PairPolicy(){

        @Override
        public void process(RegionContent left, RegionContent right, LinkedList<RegionContent> collector) {
            collector.add(left);
        }
    };
    public static PairPolicy LEFT_PAIR_POLICY_WITH_AUGMENTATION = new PairPolicy(){

        @Override
        public void process(RegionContent left, RegionContent right, LinkedList<RegionContent> collector) {
            collector.add(RegionOperations.augment(left, right));
        }
    };
    public static PairPolicy RIGHT_PAIR_POLICY = new PairPolicy(){

        @Override
        public void process(RegionContent left, RegionContent right, LinkedList<RegionContent> collector) {
            collector.add(right);
        }
    };
    public static PairPolicy RIGHT_PAIR_POLICY_WITH_AUGMENTATION = new PairPolicy(){

        @Override
        public void process(RegionContent left, RegionContent right, LinkedList<RegionContent> collector) {
            collector.add(RegionOperations.augment(right, left));
        }
    };
    public static PairPolicy INTERSECT_PAIR_POLICY = new PairPolicy(){

        @Override
        public void process(RegionContent left, RegionContent right, LinkedList<RegionContent> collector) {
            collector.add(new RegionContent(left.region.intersect(right.region), RegionOperations.getEmptyExtraFieldMap()));
        }
    };
    public static PairPolicy EXCLUDE_PAIR_POLICY = new PairPolicy(){

        @Override
        public void process(RegionContent left, RegionContent right, LinkedList<RegionContent> collector) {
        }
    };
    public static OrphanPolicy INCLUDE_ORPHAN_POLICY = new OrphanPolicy(){

        @Override
        public void process(RegionContent region, LinkedList<RegionContent> collector) {
            collector.add(region);
        }
    };
    public static OrphanPolicy EXCLUDE_ORPHAN_POLICY = new OrphanPolicy(){

        @Override
        public void process(RegionContent region, LinkedList<RegionContent> collector) {
        }
    };

    public static void main(String[] args) throws FileNotFoundException, IOException, GBrowserException {
        RegionOperations tool = new RegionOperations();
        List<RegionContent> file1 = null;
        List<RegionContent> file2 = null;
        try {
            file1 = tool.loadFile(new File("test1.bed"));
            file2 = tool.loadFile(new File("test2.bed"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        tool.print(tool.intersect(file1, file2, 1L, LEFT_PAIR_POLICY_WITH_AUGMENTATION, false), System.out);
    }

    public LinkedList<RegionContent> intersect(List<RegionContent> leftRegions, List<RegionContent> rightRegions, Long minIntersectionLength, PairPolicy pairPolicy, boolean flatten) {
        return this.operate(leftRegions, rightRegions, new IntersectingPairRule(minIntersectionLength), EXCLUDE_ORPHAN_POLICY, EXCLUDE_ORPHAN_POLICY, pairPolicy, flatten);
    }

    public LinkedList<RegionContent> subtract(List<RegionContent> leftRegions, List<RegionContent> rightRegions, Long minIntersectionLength) {
        return this.operate(leftRegions, rightRegions, new IntersectingPairRule(minIntersectionLength), INCLUDE_ORPHAN_POLICY, EXCLUDE_ORPHAN_POLICY, EXCLUDE_PAIR_POLICY, true);
    }

    public LinkedList<RegionContent> merge(List<RegionContent> leftRegions, List<RegionContent> rightRegions, Long minIntersectionLength, boolean flatten) {
        return this.operate(leftRegions, rightRegions, new IntersectingPairRule(minIntersectionLength), INCLUDE_ORPHAN_POLICY, INCLUDE_ORPHAN_POLICY, MERGE_PAIR_POLICY, flatten);
    }

    public LinkedList<RegionContent> flatten(List<RegionContent> leftRegions) {
        return this.operate(leftRegions, new LinkedList<RegionContent>(), new IntersectingPairRule(0L), INCLUDE_ORPHAN_POLICY, EXCLUDE_ORPHAN_POLICY, MERGE_PAIR_POLICY, true);
    }

    public LinkedList<RegionContent> operate(List<RegionContent> leftRegions, List<RegionContent> rightRegions, PairRule pairRule, OrphanPolicy leftOrphanPolicy, OrphanPolicy rightOrphanPolicy, PairPolicy pairPolicy, boolean mergeContinous) {
        LinkedList<RegionContent> result = new LinkedList<RegionContent>();
        HashSet<RegionContent> leftPaired = new HashSet<RegionContent>();
        HashSet<RegionContent> rightPaired = new HashSet<RegionContent>();
        for (RegionContent leftRegion : leftRegions) {
            for (RegionContent rightRegion : rightRegions) {
                if (!pairRule.isPair(leftRegion.region, rightRegion.region)) continue;
                leftPaired.add(leftRegion);
                rightPaired.add(rightRegion);
                pairPolicy.process(leftRegion, rightRegion, result);
            }
        }
        for (RegionContent leftRegion : leftRegions) {
            if (leftPaired.contains(leftRegion)) continue;
            leftOrphanPolicy.process(leftRegion, result);
        }
        for (RegionContent rightRegion : rightRegions) {
            if (rightPaired.contains(rightRegion)) continue;
            rightOrphanPolicy.process(rightRegion, result);
        }
        if (mergeContinous) {
            return this.mergeContinuous(result);
        }
        return result;
    }

    public List<RegionContent> loadFile(File input) throws FileNotFoundException, IOException, URISyntaxException, GBrowserException {
        String line;
        RandomAccessLineReader lineReader = new RandomAccessLineReader(input.toURI().toURL());
        lineReader.setPosition(0L);
        LinkedList<RegionContent> regions = new LinkedList<RegionContent>();
        while ((line = lineReader.readLine()) != null) {
            RegionContent region = this.parseString(line);
            if (region == null) continue;
            regions.add(region);
        }
        lineReader.close();
        return regions;
    }

    public RegionContent parseString(String string) throws FileNotFoundException, IOException {
        BedLineParser parser = new BedLineParser(false);
        parser.setLine(string);
        Region region = parser.getRegion();
        if (region == null) {
            return null;
        }
        int fieldCount = parser.getColumnCount();
        if (fieldCount < 3) {
            throw new IllegalArgumentException("BED must have at least chromosome, start and end fields");
        }
        DataType[] legacyBedColumns = new DataType[]{DataType.CHROMOSOME, DataType.START, DataType.END, DataType.ID, DataType.VALUE, DataType.STRAND, DataType.THICK_START, DataType.THICK_END, DataType.ITEM_RGB, DataType.BLOCK_COUNT, DataType.BLOCK_SIZES, DataType.BLOCK_STARTS};
        LinkedHashMap<DataType, Object> values = new LinkedHashMap<DataType, Object>();
        for (int i = 3; i < fieldCount; ++i) {
            DataType key = legacyBedColumns[i];
            String value = parser.getString(i);
            values.put(key, value);
        }
        return new RegionContent(region, values);
    }

    private LinkedList<RegionContent> mergeContinuous(LinkedList<RegionContent> regions) {
        this.sort(regions);
        LinkedList<RegionContent> mergedRegions = new LinkedList<RegionContent>();
        int i = 0;
        while (i < regions.size()) {
            int j;
            for (j = i; j < regions.size() - 1 && regions.get((int)i).region.intersects(regions.get((int)(j + 1)).region); ++j) {
            }
            mergedRegions.add(new RegionContent(new Region(regions.get((int)i).region.start, regions.get((int)j).region.end), RegionOperations.getEmptyExtraFieldMap()));
            i = j + 1;
        }
        return mergedRegions;
    }

    public void print(List<RegionContent> regionContents, OutputStream outputStream) {
        PrintWriter out = new PrintWriter(outputStream);
        for (RegionContent regionContent : regionContents) {
            out.println(regionContent.toString());
        }
        out.flush();
    }

    public void printTSV(List<RegionContent> regionContents, OutputStream outputStream) {
        PrintWriter out = new PrintWriter(outputStream);
        out.println("chromosome\tstart\tend\t" + Strings.delimit(regionContents.get((int)0).values.keySet(), "\t").toLowerCase());
        HashSet<String> rowNames = new HashSet<String>();
        for (RegionContent regionContent : regionContents) {
            String rowName = regionContent.values.get((Object)DataType.ID).toString();
            if (rowNames.contains(rowName)) continue;
            out.println(rowName + "\t" + regionContent.toString());
            rowNames.add(rowName);
        }
        out.flush();
    }

    public void sort(List<RegionContent> rows) {
        Collections.sort(rows);
    }

    private static RegionContent augment(RegionContent primary, RegionContent secondary) {
        RegionContent augmented = new RegionContent(primary.region, RegionOperations.getEmptyExtraFieldMap());
        augmented.values.clear();
        for (Map.Entry<DataType, Object> entry : primary.values.entrySet()) {
            Object valueInSecondary;
            Object value = entry.getValue();
            if ((value == null || EMPTY_EXTRA_FIELDS.equals(value.toString().trim())) && (valueInSecondary = secondary.values.get((Object)entry.getKey())) != null && !EMPTY_EXTRA_FIELDS.equals(valueInSecondary.toString().trim())) {
                augmented.values.put(entry.getKey(), valueInSecondary);
                continue;
            }
            augmented.values.put(entry.getKey(), value);
        }
        return augmented;
    }

    public static LinkedHashMap<DataType, Object> getEmptyExtraFieldMap() {
        LinkedHashMap<DataType, Object> values = new LinkedHashMap<DataType, Object>();
        values.put(DataType.VALUE, EMPTY_EXTRA_FIELDS);
        return values;
    }

    public static interface OrphanPolicy {
        public void process(RegionContent var1, LinkedList<RegionContent> var2);
    }

    public static interface PairPolicy {
        public void process(RegionContent var1, RegionContent var2, LinkedList<RegionContent> var3);
    }

    public static class IntersectingPairRule
    implements PairRule {
        private Long minLength;

        public IntersectingPairRule(Long minLength) {
            this.minLength = minLength;
        }

        @Override
        public boolean isPair(Region left, Region right) {
            if (!left.intersects(right)) {
                return false;
            }
            Region intersection = left.intersect(right);
            return intersection.getLength() >= this.minLength;
        }
    }

    public static interface PairRule {
        public boolean isPair(Region var1, Region var2);
    }
}

