/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.GtfToFeatureConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Exon;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Gene;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneSet;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.PositionAndStringKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Transcript;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class TranscriptTrack
extends Track {
    private HashSet<Exon> exons = new HashSet();
    List<Integer> occupiedSpace = new ArrayList<Integer>();

    public TranscriptTrack() {
        this.layoutMode = this.defaultLayoutMode = LayoutTool.LayoutMode.FULL;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        this.occupiedSpace.clear();
        TreeMap<PositionAndStringKey, Transcript> sortedTranscripts = new TreeMap<PositionAndStringKey, Transcript>();
        if (this.exons != null) {
            GeneSet geneSet = new GeneSet();
            geneSet.add(this.exons.iterator(), this.view.getRequestRegion().grow(GtfToFeatureConversion.MAX_INTRON_LENGTH * 2));
            Iterator iter = geneSet.values().iterator();
            while (iter.hasNext()) {
                Gene gene = (Gene)iter.next();
                if (!this.getView().requestIntersects(gene.getRegion())) {
                    iter.remove();
                    continue;
                }
                for (Transcript transcript : gene.getTranscripts()) {
                    PositionAndStringKey key = new PositionAndStringKey(transcript.getRegion().start, transcript.getId());
                    sortedTranscripts.put(key, transcript);
                }
            }
            ArrayList<RectDrawable> geneDrawables = new ArrayList<RectDrawable>();
            for (Transcript transcript : sortedTranscripts.values()) {
                int i;
                if (!this.getView().getBpRegion().intersects(transcript.getRegion())) continue;
                Rectangle rect = new Rectangle();
                int x = rect.x = this.getView().bpToTrack(transcript.getRegion().start).intValue();
                BpCoord endCoord = new BpCoord(transcript.getRegion().end.bp + 1L, transcript.getRegion().end.chr);
                rect.width = this.getView().bpToTrack(endCoord) - rect.x;
                int x2 = this.getView().bpToTrack(endCoord);
                for (i = 0; this.occupiedSpace.size() > i && this.occupiedSpace.get(i) > rect.x; ++i) {
                }
                int end = rect.x + rect.width;
                if (this.occupiedSpace.size() > i) {
                    this.occupiedSpace.set(i, end + 1);
                } else {
                    this.occupiedSpace.add(end + 1);
                }
                rect.y = (i + 1) * 14;
                int y = rect.y + 2;
                rect.height = 2;
                drawables.add(new LineDrawable(x, y, x2, y, Color.darkGray));
                rect.height = 4;
                if (transcript.getRegion().getStrand() == Strand.REVERSE) {
                    drawables.addAll(this.getArrowDrawables(rect.x, rect.y, -rect.height, rect.height));
                } else {
                    drawables.addAll(this.getArrowDrawables(rect.x + rect.width, rect.y, rect.height, rect.height));
                }
                if (this.isNameVisible(rect)) {
                    String name = null;
                    name = transcript.getName() != null ? transcript.getName() : (transcript.getId() != null ? transcript.getId() : "n/a");
                    this.drawTextAboveRectangle(name, drawables, rect, 1);
                }
                for (Exon exon : transcript.getExons()) {
                    Color c;
                    Exon.Feature feature = exon.getFeature();
                    switch (feature) {
                        case CDS: {
                            c = PartColor.CDS.c;
                            break;
                        }
                        case EXON: {
                            c = PartColor.UTR.c;
                            break;
                        }
                        case START_CODON: {
                            c = PartColor.CDS.c;
                            break;
                        }
                        case STOP_CODON: {
                            c = PartColor.CDS.c;
                            break;
                        }
                        case TRANSCRIPT: {
                            c = null;
                            break;
                        }
                        default: {
                            System.err.println("Gene description not recognised: " + (Object)((Object)feature));
                            c = Color.gray;
                        }
                    }
                    rect.x = this.getView().bpToTrack(exon.getRegion().start);
                    BpCoord exonEnd = new BpCoord(exon.getRegion().end.bp + 1L, exon.getRegion().end.chr);
                    rect.width = this.getView().bpToTrack(exonEnd) - rect.x;
                    rect.height = 4;
                    if (c == null) continue;
                    geneDrawables.add(new RectDrawable(rect, c, null));
                }
            }
            Collections.sort(geneDrawables, new Comparator<Drawable>(){

                @Override
                public int compare(Drawable one, Drawable other) {
                    if (one.color.equals(PartColor.CDS.c) && other.color.equals(PartColor.UTR.c)) {
                        return 1;
                    }
                    if (one.color.equals(PartColor.UTR.c) && other.color.equals(PartColor.CDS.c)) {
                        return -1;
                    }
                    return 0;
                }
            });
            drawables.addAll(geneDrawables);
        }
        return drawables;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        for (RegionContent content : dataResult.getContents()) {
            Object value;
            if (content.region.getStrand() != this.getStrand() || !((value = content.values.get((Object)DataType.VALUE)) instanceof Exon)) continue;
            Exon exon = (Exon)value;
            this.exons.add(exon);
        }
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.VALUE);
    }

    @Override
    public int getMinHeight() {
        return 100;
    }

    public static enum PartColor {
        CDS(GBrowserConstants.COLOR_BLUE),
        UTR(GBrowserConstants.COLOR_ORANGE);

        public Color c;

        private PartColor(Color c) {
            this.c = c;
        }
    }
}

