/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutComponent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Track
implements DataResultListener,
LayoutComponent {
    private static final int NAME_VISIBLE_VIEW_RATIO = 20;
    protected GBrowserView view;
    protected List<DataThread> dataThreads = new LinkedList<DataThread>();
    protected Strand strand = Strand.FORWARD;
    protected int layoutHeight;
    protected boolean visible = true;
    protected LayoutTool.LayoutMode layoutMode = LayoutTool.LayoutMode.FIXED;
    protected LayoutTool.LayoutMode defaultLayoutMode = LayoutTool.LayoutMode.FIXED;
    private Map<DataThread, Set<DataType>> dataTypeMap = new HashMap<DataThread, Set<DataType>>();
    private long maxViewLength = Long.MAX_VALUE;
    private long minViewLength = 0L;
    private Point2D[] arrowPoints = new Point2D[]{new Point2D.Double(0.0, 0.25), new Point2D.Double(0.5, 0.25), new Point2D.Double(0.5, 0.0), new Point2D.Double(1.0, 0.5), new Point2D.Double(0.5, 1.0), new Point2D.Double(0.5, 0.75), new Point2D.Double(0.0, 0.75), new Point2D.Double(0.0, 0.25)};
    private String name = "Track";
    private int fullHeight;
    private int FULL_HEIGHT_MARGIN = 10;

    public void setView(GBrowserView view) {
        this.view = view;
    }

    public int addDataThread(DataThread dataThread) {
        this.dataThreads.add(dataThread);
        return this.dataThreads.size() - 1;
    }

    public void initializeListener() {
        if (this.dataThreads != null) {
            for (DataThread handler : this.dataThreads) {
                this.view.getQueueManager().addDataResultListener(handler, this);
            }
        }
    }

    public abstract Collection<Drawable> getDrawables();

    protected GBrowserView getView() {
        return this.view;
    }

    public boolean hasData() {
        return this.dataThreads != null;
    }

    public void defineDataTypes() {
    }

    public void addDataType(DataType type) {
        this.addDataType(this.dataThreads.get(0), type);
    }

    public void addDataType(DataThread dataThread, DataType type) {
        Set<DataType> set = this.dataTypeMap.get(dataThread);
        if (set == null) {
            set = new HashSet<DataType>();
            this.dataTypeMap.put(dataThread, set);
        }
        set.add(type);
    }

    public Collection<Drawable> getEmptyDrawCollection() {
        return new LinkedList<Drawable>();
    }

    @Override
    public int getHeight() {
        return Math.max(this.layoutHeight, this.getMinHeight());
    }

    @Override
    public void setHeight(int height) {
        this.layoutHeight = height;
    }

    @Override
    public boolean isVisible() {
        return this.visible && this.getView().getBpRegion().getLength() >= this.minViewLength && this.getView().getBpRegion().getLength() < this.maxViewLength;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setStrand(Strand s) {
        this.strand = s;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public boolean isReversed() {
        return this.strand == Strand.REVERSE;
    }

    public boolean canExpandDrawables() {
        return false;
    }

    protected Collection<? extends Drawable> getArrowDrawables(int x, int y, int width, int height) {
        Collection<Drawable> parts = this.getEmptyDrawCollection();
        for (int i = 1; i < this.arrowPoints.length; ++i) {
            Point2D p1 = this.arrowPoints[i - 1];
            Point2D p2 = this.arrowPoints[i];
            Point2D.Double p1Scaled = new Point2D.Double((double)x + p1.getX() * (double)width, (double)y + p1.getY() * (double)height);
            Point2D.Double p2Scaled = new Point2D.Double((double)x + p2.getX() * (double)width, (double)y + p2.getY() * (double)height);
            parts.add(new LineDrawable((int)((Point2D)p1Scaled).getX(), (int)((Point2D)p1Scaled).getY(), (int)((Point2D)p2Scaled).getX(), (int)((Point2D)p2Scaled).getY(), Color.black));
        }
        return parts;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNameVisible(Rectangle rect) {
        return rect.width > this.getView().getWidth() / 20;
    }

    protected void drawTextAboveRectangle(String text, Collection<Drawable> drawables, Rectangle rect, int offset) {
        drawables.add(new TextDrawable(rect.x < 0 ? 0 : rect.x, rect.y + offset, text, Color.DARK_GRAY));
    }

    @Override
    public int getMinHeight() {
        return 0;
    }

    public void setFullHeight(Collection<Drawable> drawables) {
        int maxY = 0;
        for (Drawable drawable : drawables) {
            if (drawable.getMaxY() <= maxY || this.view.getWidth() <= drawable.x) continue;
            maxY = drawable.getMaxY();
        }
        if (this.getLayoutMode() == LayoutTool.LayoutMode.FULL) {
            maxY += this.FULL_HEIGHT_MARGIN;
        }
        this.fullHeight = maxY;
    }

    @Override
    public int getFullHeight() {
        if (this.getLayoutMode() == LayoutTool.LayoutMode.FIXED || this.getLayoutMode() == LayoutTool.LayoutMode.FILL) {
            return this.getHeight();
        }
        return Math.max(this.fullHeight, this.getHeight());
    }

    @Override
    public void setLayoutMode(LayoutTool.LayoutMode mode) {
        this.layoutMode = mode;
    }

    public void setDefaultLayoutMode(LayoutTool.LayoutMode mode) {
        this.defaultLayoutMode = mode;
    }

    @Override
    public void setDefaultLayoutMode() {
        this.layoutMode = this.defaultLayoutMode;
    }

    @Override
    public LayoutTool.LayoutMode getLayoutMode() {
        return this.layoutMode;
    }

    public void clearDataTypes() {
        this.dataTypeMap.clear();
    }

    public Map<DataThread, Set<DataType>> getDataTypeMap() {
        return this.dataTypeMap;
    }

    public void setViewLimits(long minViewLength, long maxViewLength) {
        this.minViewLength = minViewLength;
        this.maxViewLength = maxViewLength;
    }
}

