/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.CoverageStorage;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class CoverageAverageTrack
extends Track {
    private boolean strandSpecificCoverageType;
    private CoverageStorage coverageStorage = new CoverageStorage();

    private Collection<Drawable> getAverageDrawables(Strand strand, Color color) {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        int bottomlineY = 0;
        int previousValueY = 0;
        int previousEndX = -1;
        Color lineColor = new Color(color.getRGB(), false);
        TreeMap<Region, Float> totals = this.coverageStorage.getTotalAverageCoverage();
        for (Map.Entry<Region, Float> entry : totals.entrySet()) {
            Region region = entry.getKey();
            if (this.view == null) continue;
            float startX = this.getView().bpToTrackFloat(region.start).floatValue();
            float endX = this.getView().bpToTrackFloat(region.end).floatValue();
            int width = (int)endX - (int)startX;
            int profileY = 0;
            Float coverage = this.coverageStorage.getAverage(region, strand);
            if (coverage == null) continue;
            profileY = (int)coverage.floatValue();
            int valueY = bottomlineY + profileY;
            drawables.add(new RectDrawable((int)startX, bottomlineY, width, valueY, color, null));
            if (previousEndX < (int)startX) {
                drawables.add(new LineDrawable(previousEndX, bottomlineY, previousEndX, previousValueY, lineColor));
                previousValueY = 0;
            }
            drawables.add(new LineDrawable((int)startX, previousValueY, (int)startX, valueY, lineColor));
            drawables.add(new LineDrawable((int)startX, valueY, (int)startX + width, valueY, lineColor));
            previousValueY = valueY;
            previousEndX = (int)startX + width;
        }
        drawables.add(new LineDrawable(previousEndX, bottomlineY, previousEndX, previousValueY, lineColor));
        return drawables;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.strandSpecificCoverageType) {
            drawables.addAll(this.getAverageDrawables(Strand.FORWARD, GBrowserConstants.FORWARD_COLOR));
            drawables.addAll(this.getAverageDrawables(Strand.REVERSE, GBrowserConstants.REVERSE_COLOR));
        } else {
            drawables.addAll(this.getAverageDrawables(Strand.BOTH, GBrowserConstants.getCoverageColor()));
        }
        return drawables;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        this.coverageStorage.addAverages(dataResult, this.view.getRequestRegion());
    }

    @Override
    public int getHeight() {
        return 100;
    }

    @Override
    public void defineDataTypes() {
        this.addDataType(DataType.COVERAGE_AVERAGE);
    }

    @Override
    public boolean canExpandDrawables() {
        return true;
    }

    public void setStrandSpecificCoverageType(boolean b) {
        this.strandSpecificCoverageType = b;
    }
}

