/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.Index;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BinarySearchIndex
extends Index {
    private RandomAccessLineDataSource file;
    private LineParser parser;
    private TreeMap<BpCoord, Long> index = new TreeMap();
    private static final int INDEX_INTERVAL = 131072;

    public BinarySearchIndex(DataSource file, LineParser parser) throws IOException, GBrowserException, UnsortedDataException {
        this.file = (RandomAccessLineDataSource)file;
        this.parser = parser;
        this.checkSorting();
        this.readEnds();
    }

    public void checkSorting() throws IOException, GBrowserException, UnsortedDataException {
        List<String> lines;
        if (this.getFile().length() < 102400L) {
            lines = this.getFileLines();
        } else {
            long length = this.getFile().length();
            int blockLineCount = 10;
            int blockCount = 10;
            long blockInterval = length / 10L;
            lines = new LinkedList<String>();
            for (int i = 0; i < 10; ++i) {
                this.getFile().setLineReaderPosition(blockInterval * (long)i);
                this.getFile().getNextLine();
                for (int j = 0; j < 10; ++j) {
                    String line = this.getFile().getNextLine();
                    lines.add(line);
                }
            }
        }
        this.checkSorting(lines);
    }

    private void checkSorting(List<String> lines) throws UnsortedDataException {
        Region previousRegion = null;
        for (String line : lines) {
            this.getParser().setLine(line);
            Region region = this.getParser().getRegion();
            if (previousRegion != null && previousRegion.start.compareTo(region.start) > 0) {
                throw new UnsortedDataException("File " + this.getFile() + " isn't sorted correctly. " + "Please sort the file first.");
            }
            previousRegion = region;
        }
    }

    private void readEnds() throws IOException, GBrowserException {
        long firstLinePosition = 0L;
        Region region = null;
        do {
            this.getFile().setLineReaderPosition(firstLinePosition);
            String firstLine = this.getFile().getNextLine();
            this.getParser().setLine(firstLine);
            region = this.getParser().getRegion();
            if (region != null) {
                this.index.put(region.start, firstLinePosition);
                continue;
            }
            firstLinePosition += (long)(firstLine.length() + 1);
        } while (region == null);
        String lastLine = this.getFile().getLastLine();
        this.getParser().setLine(lastLine);
        region = this.getParser().getRegion();
        this.index.put(region.start, this.getFile().length() - (long)lastLine.length() - 1L);
    }

    public List<String> getFileLines() throws IOException, GBrowserException {
        this.getFile().setLineReaderPosition(0L);
        LinkedList<String> lines = new LinkedList<String>();
        String line = null;
        while ((line = this.getFile().getNextLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    @Override
    public TreeMap<IndexKey, String> getFileLines(Region request) throws IOException, GBrowserException {
        if (request.start.compareTo(request.end) > 0) {
            // empty if block
        }
        BpCoord requestFloor = new BpCoord(request.start.bp - 1L, request.start.chr);
        long floorFilePosition = this.binarySearch(requestFloor);
        this.getFile().setLineReaderPosition(floorFilePosition);
        TreeMap<IndexKey, String> lines = new TreeMap<IndexKey, String>();
        String line = null;
        long lineBytePosition = floorFilePosition;
        while ((line = this.getFile().getNextLine()) != null) {
            if ("".equals(line)) continue;
            this.getParser().setLine(line);
            Region region = this.getParser().getRegion();
            if (request.contains(region.start)) {
                lines.put(new IndexKey(region.start, lineBytePosition), line);
            }
            if (request.end.compareTo(region.start) < 0) break;
            lineBytePosition += (long)(line.length() + 1);
        }
        return lines;
    }

    private long binarySearch(BpCoord position) throws IOException, GBrowserException {
        Map.Entry<BpCoord, Long> floorEntry = this.index.floorEntry(position);
        Map.Entry<BpCoord, Long> ceilingEntry = this.index.ceilingEntry(position);
        if (floorEntry == null) {
            floorEntry = ceilingEntry;
        }
        if (ceilingEntry == null) {
            ceilingEntry = floorEntry;
        }
        long floorFilePosition = floorEntry.getValue();
        long ceilingFilePosition = ceilingEntry.getValue();
        if (ceilingFilePosition - floorFilePosition > 131072L) {
            this.splitIndexRegion(floorFilePosition, ceilingFilePosition);
            return this.binarySearch(position);
        }
        return floorEntry.getValue();
    }

    private void splitIndexRegion(long floorFilePosition, long ceilingFilePosition) throws IOException, GBrowserException {
        long centerFilePosition = (floorFilePosition + ceilingFilePosition) / 2L;
        this.getFile().setLineReaderPosition(centerFilePosition);
        long partialLineLength = this.getFile().getNextLine().length() + 1;
        String line = this.getFile().getNextLine();
        this.getParser().setLine(line);
        Region region = this.getParser().getRegion();
        this.index.put(region.start, centerFilePosition + partialLineLength + (long)line.length());
    }

    public RandomAccessLineDataSource getFile() {
        return this.file;
    }

    public LineParser getParser() {
        return this.parser;
    }
}

