/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackContext;
import java.awt.Color;

public class LineDrawable
extends Drawable {
    public int x2;
    public int y2;

    public LineDrawable(int x, int y, int x2, int y2, Color color) {
        super(x, y, color);
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public void upsideDown() {
        super.upsideDown();
        this.y2 = -this.y2;
    }

    public String toString() {
        return "LineDrawable (" + this.x + ", " + this.y + ") - (" + this.x2 + ", " + this.y2 + ")";
    }

    @Override
    public int getMaxY() {
        return Math.min(this.y, this.y2);
    }

    @Override
    public void expand(TrackContext context) {
        int maxY = context.trackHeight - 1;
        this.y = Math.min(maxY, (int)((float)this.y * context.expansionRatio.floatValue()));
        this.y2 = Math.min(maxY, (int)((float)this.y2 * context.expansionRatio.floatValue()));
    }
}

