/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.emboss;

import fi.csc.microarray.analyser.emboss.ACDDescription;
import fi.csc.microarray.description.SADLDescription;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.regexp.RE;
import org.emboss.jemboss.parser.AcdFunResolve;
import org.emboss.jemboss.parser.ParseAcd;

public class ACDParameter {
    ACDDescription acd = null;
    static final Integer PARAM_GROUP_SIMPLE = 0;
    static final Integer PARAM_GROUP_INPUT = 1;
    static final Integer PARAM_GROUP_LIST = 2;
    static final Integer PARAM_GROUP_OUTPUT = 3;
    static final Integer PARAM_GROUP_GRAPHICS = 4;
    public static final String UNDEFINED = "<undefined>";
    private static final int MAX_RECURSION_DEPTH = 5;
    private String type;
    private String name;
    private String section;
    private String subsection;
    private LinkedHashMap<String, String> list;
    private HashMap<String, String> attributes = new HashMap();
    private final HashMap<String, ACDValidator> validators = new HashMap();

    public ACDParameter(String type, String name, String section, String subsection) {
        this.setName(name);
        this.setType(type);
        this.setSection(section);
        this.setSubsection(subsection);
        this.validators.put("float", new FloatValidator());
        this.validators.put("integer", new IntegerValidator());
        this.validators.put("array", new ArrayValidator());
        this.validators.put("boolean", new BooleanValidator());
        this.validators.put("list", new ListValidator());
        this.validators.put("selection", new ListValidator());
    }

    public ACDParameter(ACDDescription acd, String type, String name, String section, String subsection) {
        this(type, name, section, subsection);
        this.acd = acd;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            return this.attributes.get(name);
        }
        return null;
    }

    public void updateAttributes(LinkedHashMap<String, String> varMap) {
        for (String key : this.attributes.keySet()) {
            this.attributes.put(key, ACDParameter.resolveExp(this.attributes.get(key), varMap));
        }
    }

    public Boolean hasAttribute(String name) {
        if (this.attributes.containsKey(name) && !this.getAttribute(name).equals("")) {
            return true;
        }
        return false;
    }

    public Boolean hasAttribute(String name, Boolean isEvaluated) {
        isEvaluated = isEvaluated == false || this.attributeIsEvaluated(name) != false;
        if (this.attributes.containsKey(name) && !this.getAttribute(name).equals("") && isEvaluated.booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean attributeIsTrue(String name) {
        String attrValue = this.getAttribute(name);
        if (attrValue != null) {
            return attrValue.toLowerCase().equals("y") || attrValue.toLowerCase().equals("true");
        }
        return false;
    }

    public String[] getDefaults() {
        if (this.hasAttribute("default").booleanValue()) {
            return this.getAttribute("default").split(",");
        }
        return new String[0];
    }

    public void setList(ParseAcd parser, Integer index) {
        this.list = new LinkedHashMap();
        if (this.getType().equals("list")) {
            String[] titles = parser.getList(index.intValue());
            for (int i = 0; i < titles.length; ++i) {
                this.list.put(parser.getListLabel(index.intValue(), i), titles[i]);
            }
        } else {
            String[] titles = parser.getSelect(index.intValue());
            Integer i = 0;
            while (i < parser.getSelect(index.intValue()).length) {
                this.list.put(i.toString(), titles[i]);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
    }

    public void setList(String[] titles, String[] values) {
        this.list = new LinkedHashMap();
        if (this.getType().equals("list")) {
            for (int i = 0; i < titles.length; ++i) {
                this.list.put(values[i], titles[i]);
            }
        } else {
            Integer i = 0;
            while (i < titles.length) {
                this.list.put(i.toString(), titles[i]);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
    }

    public HashMap<String, String> getList() {
        return this.list;
    }

    public String getOutputFilename(Boolean withExtension) {
        String extension = "";
        if (withExtension.booleanValue() && ACDParameter.detectParameterGroup(this.getType()) == PARAM_GROUP_OUTPUT) {
            extension = ".txt";
        }
        String suffix = "";
        if (this.acd != null) {
            suffix = this.acd.getName();
        }
        return this.getName() + "." + suffix + extension;
    }

    public SADLDescription.Name getGraphicsName() {
        if (ACDParameter.detectParameterGroup(this.getType()) == PARAM_GROUP_GRAPHICS) {
            return SADLDescription.Name.createNameSet(this.getName(), ".png");
        }
        return null;
    }

    public void setSection(String name) {
        this.section = name;
    }

    public String getSection() {
        return this.section;
    }

    public void setSubsection(String name) {
        this.subsection = name;
    }

    public String getSubsection() {
        return this.subsection;
    }

    public Boolean isRequired() {
        Boolean attrStandard = this.attributeIsTrue("standard");
        Boolean attrParameter = this.attributeIsTrue("parameter");
        if (attrStandard.booleanValue() || attrParameter.booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean isAdditional() {
        return this.attributeIsTrue("additional");
    }

    public Boolean isAdvanced() {
        return this.getAttribute("standard") == null && this.getAttribute("parameter") == null && this.getAttribute("additional") == null;
    }

    public Boolean attributeIsEvaluated(String attrName) {
        String attrValue = this.getAttribute(attrName);
        return attrValue != null && !attrValue.contains("$") && !attrValue.contains("@");
    }

    public static String resolveExp(String exp, LinkedHashMap<String, String> map) {
        return ACDParameter.resolveExp(exp, map, 0);
    }

    private static String resolveExp(String exp, LinkedHashMap<String, String> map, int recursionDepth) {
        if (recursionDepth > 5) {
            throw new RuntimeException("ACD expression resolving failed, maximum recursion depth reached");
        }
        RE reVar = new RE("\\$\\(([\\w.]+)\\)");
        RE reFunc = new RE("\\@\\(([\\w.+-/:?\"]+)\\)");
        reVar.match(exp);
        String match = reVar.getParen(1);
        String resolvedExp = exp;
        if (match != null) {
            String substitute = "$(" + match + ")";
            if (map.containsKey(match)) {
                substitute = map.get(match);
            }
            if (substitute.toLowerCase().equals("y")) {
                substitute = "true";
            } else if (substitute.toLowerCase().equals("n")) {
                substitute = "false";
            }
            Integer start = reVar.getParenStart(1) - 2;
            Integer end = reVar.getParenEnd(1) + 1;
            resolvedExp = exp.substring(0, start) + substitute + exp.substring(end, exp.length());
        }
        reFunc.match(resolvedExp);
        match = reVar.getParen(1);
        if (match != null) {
            AcdFunResolve resolver = new AcdFunResolve(resolvedExp);
            resolvedExp = resolver.getResult();
        }
        if (!exp.equals(resolvedExp)) {
            resolvedExp = resolvedExp.equals("true") ? "Y" : resolvedExp;
            resolvedExp = resolvedExp.equals("false") ? "N" : resolvedExp;
            return ACDParameter.resolveExp(resolvedExp, map, recursionDepth++);
        }
        return resolvedExp;
    }

    public static Integer detectParameterGroup(String fieldType) {
        String[] typesSimple = new String[]{"array", "boolean", "float", "integer", "range", "string", "toggle"};
        String[] typesInput = new String[]{"codon", "cpdb", "datafile", "directoty", "dirlist", "discretestates", "distances", "features", "filelist", "frequencies", "infile", "matrix", "matrixf", "pattern", "properties", "regexp", "scop", "sequence", "seqall", "seqset", "seqsetall", "seqsetall", "tree"};
        String[] typesList = new String[]{"list", "selection"};
        String[] typesOutput = new String[]{"align", "featout", "outcodon", "outcpdb", "outdata", "outdir", "outdiscrete", "outdistance", "outfile", "outfileall", "outfreq", "outmatrix", "outmatrixf", "outproperties", "outscop", "outtree", "report", "seqout", "seqoutall", "seqoutset"};
        String[] typesGraphics = new String[]{"graph", "xygraph"};
        if (Arrays.asList(typesSimple).contains(fieldType)) {
            return PARAM_GROUP_SIMPLE;
        }
        if (Arrays.asList(typesInput).contains(fieldType)) {
            return PARAM_GROUP_INPUT;
        }
        if (Arrays.asList(typesList).contains(fieldType)) {
            return PARAM_GROUP_LIST;
        }
        if (Arrays.asList(typesOutput).contains(fieldType)) {
            return PARAM_GROUP_OUTPUT;
        }
        if (Arrays.asList(typesGraphics).contains(fieldType)) {
            return PARAM_GROUP_GRAPHICS;
        }
        return -1;
    }

    public String normalize(String value) {
        String type = this.getType();
        if (type.equals("boolean")) {
            if ((value = value.toLowerCase()).equals("yes") || value.equals("true") || value.equals("1") || value.equals("y")) {
                return "Y";
            }
            if (value.equals("no") || value.equals("true") || value.equals("0") || value.equals("n")) {
                return "N";
            }
            if (value.equals(UNDEFINED)) {
                return "";
            }
        } else if (type.equals("selection") || type.equals("list")) {
            String attrDelim;
            String defaultDelim = ",";
            String[] choices = value.split(defaultDelim);
            String string = attrDelim = this.hasAttribute("delimiter") != false ? this.getAttribute("delimiter") : ";";
            if (choices.length > 1 && attrDelim != defaultDelim) {
                String normalValue = "";
                for (String choice : choices) {
                    normalValue = normalValue.concat(attrDelim).concat(choice);
                }
                return normalValue.substring(1);
            }
        }
        return value;
    }

    public boolean validate(String value) {
        ACDValidator validator = this.validators.containsKey(this.getType()) ? this.validators.get(this.getType()) : new VoidValidator();
        return ((ACDValidator)validator).accepts(this.normalize(value));
    }

    private abstract class ACDValidator {
        private ACDValidator() {
        }

        public abstract boolean accepts(String var1);
    }

    class ListValidator
    extends ACDValidator {
        ListValidator() {
        }

        @Override
        public boolean accepts(String value) {
            Boolean accepts = true;
            HashMap<String, String> acceptedList = ACDParameter.this.getList();
            String attrDelim = ACDParameter.this.hasAttribute("delimiter") != false ? ACDParameter.this.getAttribute("delimiter") : ";";
            String[] choices = value.split(attrDelim);
            if (ACDParameter.this.hasAttribute("minimum").booleanValue()) {
                Integer minVal = Integer.parseInt(ACDParameter.this.getAttribute("minimum"));
                accepts = accepts != false && choices.length >= minVal;
            }
            if (ACDParameter.this.hasAttribute("maximum").booleanValue()) {
                Integer maxVal = Integer.parseInt(ACDParameter.this.getAttribute("maximum"));
                accepts = accepts != false && choices.length <= maxVal;
            }
            for (String choice : choices) {
                accepts = accepts != false && acceptedList.containsKey(choice);
            }
            return accepts;
        }
    }

    class FloatValidator
    extends ACDValidator {
        FloatValidator() {
        }

        @Override
        public boolean accepts(String value) {
            Boolean accepts = true;
            try {
                Float floatVal = Float.valueOf(Float.parseFloat(value));
                if (ACDParameter.this.hasAttribute("minimum", true).booleanValue()) {
                    Float minVal = Float.valueOf(Float.parseFloat(ACDParameter.this.getAttribute("minimum")));
                    accepts = accepts != false && floatVal.floatValue() >= minVal.floatValue();
                }
                if (ACDParameter.this.hasAttribute("maximum", true).booleanValue()) {
                    Float maxVal = Float.valueOf(Float.parseFloat(ACDParameter.this.getAttribute("maximum")));
                    accepts = accepts != false && floatVal.floatValue() <= maxVal.floatValue();
                }
                return accepts;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
    }

    class IntegerValidator
    extends ACDValidator {
        IntegerValidator() {
        }

        @Override
        public boolean accepts(String value) {
            Boolean accepts = true;
            try {
                Integer intVal = Integer.parseInt(value);
                if (ACDParameter.this.hasAttribute("minimum", true).booleanValue()) {
                    Integer minVal = Integer.parseInt(ACDParameter.this.getAttribute("minimum"));
                    accepts = accepts != false && intVal >= minVal;
                }
                if (ACDParameter.this.hasAttribute("maximum", true).booleanValue()) {
                    Integer maxVal = Integer.parseInt(ACDParameter.this.getAttribute("maximum"));
                    accepts = accepts != false && intVal <= maxVal;
                }
                return accepts;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
    }

    class ArrayValidator
    extends ACDValidator {
        ArrayValidator() {
        }

        @Override
        public boolean accepts(String value) {
            Pattern re = Pattern.compile("^(\\d+(\\.\\d+)?[ ,])*\\d+(\\.\\d+)?$");
            Matcher m = re.matcher(value);
            return m.find();
        }
    }

    class BooleanValidator
    extends ACDValidator {
        BooleanValidator() {
        }

        @Override
        public boolean accepts(String value) {
            return value.equals("Y") || value.equals("N") || value.equals("");
        }
    }

    class VoidValidator
    extends ACDValidator {
        VoidValidator() {
        }

        @Override
        public boolean accepts(String value) {
            return true;
        }
    }
}

