/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.ToolRepository;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.JMSFileBrokerClient;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.JobLogMessage;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.ModuleDescriptionMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import fi.csc.microarray.messaging.message.SourceMessage;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.MemUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.JMSException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class AnalyserServer
extends MonitoredNodeBase
implements MessagingListener,
ResultCallback,
ShutdownCallback {
    public static final String DESCRIPTION_OUTPUT_NAME = "description";
    public static final String SOURCECODE_OUTPUT_NAME = "sourcecode";
    private static Logger logger;
    private static Logger loggerJobs;
    private static Logger loggerStatus;
    private int scheduleTimeout;
    private int offerDelay;
    private int timeoutCheckInterval;
    private boolean sweepWorkDir;
    private int maxJobs;
    private String id = UUID.randomUUID().toString();
    private File workDir;
    private ToolRepository toolRepository;
    private MessagingEndpoint endpoint;
    private MessagingTopic managerTopic;
    private FileBrokerClient fileBroker;
    private ExecutorService executorService;
    private Object jobsLock = new Object();
    private LinkedHashMap<String, AnalysisJob> receivedJobs = new LinkedHashMap();
    private LinkedHashMap<String, AnalysisJob> scheduledJobs = new LinkedHashMap();
    private LinkedHashMap<String, AnalysisJob> runningJobs = new LinkedHashMap();
    private Timer timeoutTimer;
    private String localFilebrokerPath;

    public AnalyserServer(String configURL) throws Exception {
        DirectoryLayout.initialiseServerLayout(Arrays.asList("comp"), configURL);
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        this.scheduleTimeout = configuration.getInt("comp", "schedule-timeout");
        this.offerDelay = configuration.getInt("comp", "offer-delay");
        this.timeoutCheckInterval = configuration.getInt("comp", "timeout-check-interval");
        this.sweepWorkDir = configuration.getBoolean("comp", "sweep-work-dir");
        this.maxJobs = configuration.getInt("comp", "max-jobs");
        String fbPath = configuration.getString("comp", "local-filebroker-user-data-path");
        this.localFilebrokerPath = "".equals(fbPath.trim()) ? null : fbPath;
        logger = Logger.getLogger(AnalyserServer.class);
        loggerJobs = Logger.getLogger((String)"jobs");
        loggerStatus = Logger.getLogger((String)"status");
        logger.info((Object)"starting compute service...");
        this.workDir = DirectoryLayout.getInstance().getJobsDataDirBase(this.id);
        this.executorService = Executors.newCachedThreadPool();
        this.toolRepository = new ToolRepository(this.workDir);
        this.timeoutTimer = new Timer(true);
        this.timeoutTimer.schedule((TimerTask)new TimeoutTimerTask(), this.timeoutCheckInterval, (long)this.timeoutCheckInterval);
        this.endpoint = new MessagingEndpoint(this);
        MessagingTopic analyseTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_REQUEST_TOPIC, MessagingTopic.AccessMode.READ);
        analyseTopic.setListener(this);
        this.managerTopic = this.endpoint.createTopic(Topics.Name.JOB_LOG_TOPIC, MessagingTopic.AccessMode.WRITE);
        this.fileBroker = new JMSFileBrokerClient(this.endpoint.createTopic(Topics.Name.AUTHORISED_FILEBROKER_TOPIC, MessagingTopic.AccessMode.WRITE), this.localFilebrokerPath);
        KeepAliveShutdownHandler.init(this);
        logger.info((Object)("analyser is up and running [" + ApplicationConstants.VERSION + "]"));
        logger.info((Object)("[mem: " + MemUtil.getMemInfo() + "]"));
    }

    @Override
    public String getName() {
        return "analyser";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChipsterMessage(ChipsterMessage chipsterMessage) {
        if (chipsterMessage.getUsername() == null || chipsterMessage.getUsername().equals("")) {
            logger.warn((Object)"not accepting message with null or empty username");
            try {
                ResultMessage resultMessage = new ResultMessage("", JobState.ERROR, "", "Username was null or empty.", "", chipsterMessage.getReplyTo());
                this.sendReplyMessage(chipsterMessage, resultMessage);
            }
            catch (Exception e) {
                logger.warn((Object)"could not send error message for null or empty username");
            }
            return;
        }
        if (chipsterMessage instanceof JobMessage) {
            JobMessage jobMessage = (JobMessage)chipsterMessage;
            this.receiveJob(jobMessage);
        } else if (chipsterMessage instanceof CommandMessage) {
            CommandMessage commandMessage = (CommandMessage)chipsterMessage;
            if ("choose".equals(commandMessage.getCommand())) {
                String acceptedId = commandMessage.getNamedParameter("as-id");
                String jobId = commandMessage.getNamedParameter("job-id");
                logger.debug((Object)("ACCEPT_OFFER for analyser: " + acceptedId + " job: " + jobId));
                if (this.id.equals(acceptedId)) {
                    Object object = this.jobsLock;
                    synchronized (object) {
                        AnalysisJob job = this.scheduledJobs.get(commandMessage.getNamedParameter("job-id"));
                        if (job != null) {
                            this.scheduledJobs.remove(jobId);
                            this.runningJobs.put(job.getId(), job);
                            this.executorService.execute(job);
                            logger.info((Object)("Executing job " + job.analysis.getDisplayName() + "(" + job.analysis.getID() + ")" + ", " + job.getId() + ", " + job.getInputMessage().getUsername()));
                        } else {
                            logger.warn((Object)"Got ACCEPT_OFFER for job which is not scheduled.");
                        }
                    }
                } else {
                    logger.debug((Object)("Removing scheduled job " + jobId));
                    Object job = this.jobsLock;
                    synchronized (job) {
                        AnalysisJob jobToBeForgotten = (AnalysisJob)this.receivedJobs.remove(jobId);
                        if (jobToBeForgotten != null) {
                            this.receivedJobs.remove(jobToBeForgotten);
                        } else {
                            this.scheduledJobs.remove(jobId);
                            this.activeJobRemoved();
                        }
                    }
                }
            } else {
                if ("describe".equals(commandMessage.getCommand())) {
                    logger.info((Object)"sending all descriptions");
                    try {
                        List<ModuleDescriptionMessage> list = this.createDescriptionsMessages(commandMessage);
                        for (ModuleDescriptionMessage msg : list) {
                            logger.info((Object)("sending descriptions for module " + msg.getModuleName()));
                            this.sendReplyMessage(commandMessage, msg);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"sending descriptions message failed", (Throwable)e);
                    }
                    return;
                }
                if ("get-source".equals(commandMessage.getCommand())) {
                    logger.info((Object)"sending source code");
                    SourceMessage sourceMessage = this.createSourceCodeMessage(commandMessage);
                    if (sourceMessage != null) {
                        this.sendReplyMessage(commandMessage, sourceMessage);
                    }
                    return;
                }
                if ("cancel".equals(commandMessage.getCommand())) {
                    AnalysisJob job;
                    String jobId = commandMessage.getParameters().get(0);
                    Object object = this.jobsLock;
                    synchronized (object) {
                        job = this.receivedJobs.containsKey(jobId) ? (AnalysisJob)this.receivedJobs.remove(jobId) : (this.scheduledJobs.containsKey(jobId) ? (AnalysisJob)this.scheduledJobs.remove(jobId) : this.runningJobs.get(jobId));
                    }
                    if (job != null) {
                        job.cancel();
                    }
                }
            }
            this.updateStatus();
        } else {
            logger.error((Object)("unidentified message: " + chipsterMessage.getMessageID()));
        }
    }

    @Override
    public File getWorkDir() {
        return this.workDir;
    }

    @Override
    public boolean shouldSweepWorkDir() {
        return this.sweepWorkDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRunningJob(AnalysisJob job) {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e1) {
            logger.warn((Object)"Could not get local hostname.");
            hostname = "";
        }
        char delimiter = ';';
        try {
            loggerJobs.info((Object)(job.getId() + delimiter + job.getInputMessage().getAnalysisId().replaceAll("\"", "") + delimiter + (Object)((Object)job.getState()) + delimiter + job.getInputMessage().getUsername() + delimiter + job.getExecutionStartTime().toString() + delimiter + job.getExecutionEndTime().toString() + delimiter + hostname));
        }
        catch (Exception e) {
            logger.warn((Object)"got exception when logging a job to be removed", (Throwable)e);
        }
        logger.debug((Object)("Analyser server removing job " + job.getId() + "(" + (Object)((Object)job.getState()) + ")"));
        Object object = this.jobsLock;
        synchronized (object) {
            this.runningJobs.remove(job.getId());
        }
        this.activeJobRemoved();
        this.sendJobLogMessage(job);
    }

    public void sendJobLogMessage(AnalysisJob job) {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e1) {
            logger.warn((Object)"Could not get local hostname.");
            hostname = "";
        }
        JobLogMessage jobLogMessage = new JobLogMessage(job.getInputMessage().getAnalysisId().replaceAll("\"", ""), job.getState(), job.getId(), job.getExecutionStartTime(), job.getExecutionEndTime(), job.getResultMessage().getErrorMessage(), job.getResultMessage().getOutputText(), job.getInputMessage().getUsername(), hostname);
        try {
            this.managerTopic.sendMessage(jobLogMessage);
        }
        catch (JMSException e) {
            logger.error((Object)"Could not send job log message.", (Throwable)e);
        }
    }

    @Override
    public void sendResultMessage(ChipsterMessage original, ResultMessage reply) {
        try {
            this.endpoint.replyToMessage(original, (ChipsterMessage)reply);
        }
        catch (JMSException e) {
            logger.error((Object)("Could not send ResultMessage " + reply.getMessageID()));
        }
        logger.info((Object)("result message sent (" + reply.getMessageID() + " " + (Object)((Object)reply.getState()) + ")"));
    }

    @Override
    public FileBrokerClient getFileBrokerClient() {
        return this.fileBroker;
    }

    private void sendReplyMessage(final ChipsterMessage original, final ChipsterMessage reply) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AnalyserServer.this.endpoint.replyToMessage(original, reply);
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeJobRemoved() {
        Object object = this.jobsLock;
        synchronized (object) {
            if (!this.receivedJobs.isEmpty() && this.runningJobs.size() + this.scheduledJobs.size() < this.maxJobs) {
                AnalysisJob job = this.receivedJobs.values().iterator().next();
                this.receivedJobs.remove(job.getId());
                this.scheduleJob(job);
            }
            this.updateStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveJob(JobMessage jobMessage) {
        AnalysisJob job;
        logger.info((Object)("received job request from: " + jobMessage.getUsername()));
        logger.info((Object)("checking if matches guest account: " + DirectoryLayout.getInstance().getConfiguration().getString("security", "guest-username")));
        if (jobMessage.getUsername().equals(DirectoryLayout.getInstance().getConfiguration().getString("security", "guest-username"))) {
            ResultMessage resultMessage = new ResultMessage("", JobState.FAILED_USER_ERROR, "", "Running tools is disabled for guest users.", "", jobMessage.getReplyTo());
            this.sendReplyMessage(jobMessage, resultMessage);
            return;
        }
        ToolDescription description = this.toolRepository.getDescription(jobMessage.getAnalysisId());
        if (description == null) {
            return;
        }
        if (!this.toolRepository.supports(description.getID())) {
            logger.debug((Object)("analysis " + jobMessage.getAnalysisId() + " ( " + description.getToolFile() + " ) not supported, ignoring request."));
            return;
        }
        try {
            job = description.createAnalysisJob(jobMessage, this);
        }
        catch (AnalysisException e) {
            logger.warn((Object)("could not create analysis job for " + jobMessage.getAnalysisId()));
            ResultMessage resultMessage = new ResultMessage("", JobState.ERROR, "", "Could not initialise operation.", "", jobMessage.getReplyTo());
            this.sendReplyMessage(jobMessage, resultMessage);
            return;
        }
        Object object = this.jobsLock;
        synchronized (object) {
            job.setReceiveTime(new Date());
            if (this.runningJobs.size() + this.scheduledJobs.size() < this.maxJobs) {
                this.scheduleJob(job);
            } else {
                this.receivedJobs.put(job.getId(), job);
                try {
                    this.sendAckMessage(job);
                }
                catch (Exception e) {
                    this.receivedJobs.remove(job.getId());
                    logger.error((Object)("Could not send ACK for job " + job.getId()));
                }
            }
        }
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob(final AnalysisJob job) {
        Object object = this.jobsLock;
        synchronized (object) {
            job.setScheduleTime(new Date());
            this.scheduledJobs.put(job.getId(), job);
        }
        try {
            int delay = this.offerDelay * (this.runningJobs.size() + this.scheduledJobs.size() - 1);
            if (delay > 0) {
                Timer timer = new Timer("offer-delay-timer", true);
                timer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            AnalyserServer.this.sendOfferMessage(job);
                        }
                        catch (JMSException e) {
                            Object object = AnalyserServer.this.jobsLock;
                            synchronized (object) {
                                AnalyserServer.this.scheduledJobs.remove(job.getId());
                            }
                            logger.error((Object)("Could not send OFFER for job " + job.getId()));
                        }
                        AnalyserServer.this.updateStatus();
                    }
                }, delay);
            } else {
                this.sendOfferMessage(job);
            }
        }
        catch (Exception e) {
            Object object2 = this.jobsLock;
            synchronized (object2) {
                this.scheduledJobs.remove(job.getId());
            }
            logger.error((Object)("Could not send OFFER for job " + job.getId()));
        }
        this.updateStatus();
    }

    private void sendAckMessage(AnalysisJob job) throws JMSException {
        CommandMessage offerMessage = new CommandMessage("acknowledge");
        offerMessage.addNamedParameter("as-id", this.id);
        offerMessage.addNamedParameter("job-id", job.getId());
        this.sendReplyMessage(job.getInputMessage(), offerMessage);
    }

    private void sendOfferMessage(AnalysisJob job) throws JMSException {
        CommandMessage offerMessage = new CommandMessage("offer");
        offerMessage.addNamedParameter("as-id", this.id);
        offerMessage.addNamedParameter("job-id", job.getId());
        this.sendReplyMessage(job.getInputMessage(), offerMessage);
    }

    private List<ModuleDescriptionMessage> createDescriptionsMessages(CommandMessage requestMessage) throws IOException, SAXException, ParserConfigurationException {
        List<ModuleDescriptionMessage> list = this.toolRepository.getModuleDescriptions();
        for (ModuleDescriptionMessage descriptionMsg : list) {
            descriptionMsg.setReplyTo(requestMessage.getReplyTo());
        }
        return list;
    }

    private SourceMessage createSourceCodeMessage(CommandMessage requestMessage) {
        String toolID = new String(requestMessage.getParameters().get(0));
        logger.info((Object)("sending source code for " + toolID));
        String sourceCode = this.toolRepository.getDescription(toolID).getSourceCode();
        if (sourceCode != null) {
            return new SourceMessage(sourceCode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus() {
        Object object = this.jobsLock;
        synchronized (object) {
            loggerStatus.info((Object)("received jobs: " + this.receivedJobs.size() + ", scheduled jobs: " + this.scheduledJobs.size() + ", running jobs: " + this.runningJobs.size()));
        }
    }

    @Override
    public void shutdown() {
        logger.info((Object)"shutdown requested");
        try {
            this.endpoint.close();
        }
        catch (JMSException e) {
            logger.error((Object)"closing messaging endpoint failed", (Throwable)e);
        }
        logger.info((Object)"shutting down");
    }

    private class TimeoutTimerTask
    extends TimerTask {
        private TimeoutTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AnalyserServer.this.jobsLock;
            synchronized (object) {
                ArrayList<AnalysisJob> jobsToBeRemoved = new ArrayList<AnalysisJob>();
                jobsToBeRemoved.clear();
                for (AnalysisJob job : AnalyserServer.this.scheduledJobs.values()) {
                    if (System.currentTimeMillis() - (long)(AnalyserServer.this.scheduleTimeout * 1000) <= job.getScheduleTime().getTime()) break;
                    jobsToBeRemoved.add(job);
                }
                for (AnalysisJob job : jobsToBeRemoved) {
                    AnalyserServer.this.scheduledJobs.remove(job.getId());
                    logger.debug((Object)("Removing old scheduled job: " + job.getId()));
                    AnalyserServer.this.activeJobRemoved();
                    logger.debug((Object)("Jobs received: " + AnalyserServer.this.receivedJobs.size() + ", scheduled: " + AnalyserServer.this.scheduledJobs.size() + ", running: " + AnalyserServer.this.runningJobs.size()));
                }
            }
        }
    }
}

