/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.web.adminweb;

import com.vaadin.annotations.Theme;
import com.vaadin.server.Sizeable;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import fi.csc.chipster.web.adminweb.NavigationMenu;
import fi.csc.chipster.web.adminweb.ui.JobLogView;
import fi.csc.chipster.web.adminweb.ui.JobsView;
import fi.csc.chipster.web.adminweb.ui.ServicesView;
import fi.csc.chipster.web.adminweb.ui.StatView;
import fi.csc.chipster.web.adminweb.ui.StorageView;

@Theme(value="admin")
public class ChipsterAdminUI
extends UI {
    private HorizontalLayout horizontalSplit;
    private NavigationMenu navigationLayout;
    private ServicesView serviceView;
    private StorageView storageView;
    private JobsView jobsView;
    private JobLogView jobLogView;
    private StatView statView;
    private VerticalLayout emptyView;
    private HorizontalLayout toolbarLayout;

    private VerticalLayout getServicesView() {
        if (this.serviceView == null) {
            this.serviceView = new ServicesView(this);
        }
        this.serviceView.update();
        return this.serviceView;
    }

    private Component getStorageView() {
        if (this.storageView == null) {
            this.storageView = new StorageView(this);
        }
        this.storageView.update();
        return this.storageView;
    }

    private JobLogView getJobLogView() {
        if (this.jobLogView == null) {
            this.jobLogView = new JobLogView(this);
        }
        return this.jobLogView;
    }

    private JobsView getJobsView() {
        if (this.jobsView == null) {
            this.jobsView = new JobsView(this);
        }
        return this.jobsView;
    }

    private StatView getStatView() {
        if (this.statView == null) {
            this.statView = new StatView(this);
        }
        return this.statView;
    }

    private void buildMainLayout() {
        this.getPage().setTitle("Chipster admin");
        this.horizontalSplit = new HorizontalLayout();
        this.horizontalSplit.setSizeFull();
        this.setContent((Component)this.horizontalSplit);
        this.horizontalSplit.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        this.showEmtpyView();
    }

    private Component getNavigation() {
        if (this.navigationLayout == null) {
            this.navigationLayout = new NavigationMenu(this);
            this.navigationLayout.showDefaultView();
        }
        return this.navigationLayout;
    }

    private void setMainComponent(Component c) {
        this.horizontalSplit.removeAllComponents();
        this.horizontalSplit.addComponent(this.getNavigation(), 0);
        this.horizontalSplit.addComponent(c, 1);
        this.horizontalSplit.setExpandRatio(c, 1.0f);
    }

    protected void showServicesView() {
        this.setMainComponent((Component)this.getServicesView());
    }

    public void showJobLogView() {
        this.setMainComponent((Component)this.getJobLogView());
    }

    public void showJobsView() {
        this.setMainComponent((Component)this.getJobsView());
    }

    public void showStorageView() {
        this.setMainComponent(this.getStorageView());
    }

    public void showStatView() {
        this.setMainComponent((Component)this.getStatView());
    }

    public void showEmtpyView() {
        if (this.emptyView == null) {
            this.emptyView = new VerticalLayout();
            this.emptyView.addComponent((Component)this.getToolbar());
            this.emptyView.setSizeFull();
            this.emptyView.setStyleName("empty-view");
        }
        this.setMainComponent((Component)this.emptyView);
    }

    public HorizontalLayout getToolbar() {
        if (this.toolbarLayout == null) {
            this.toolbarLayout = new HorizontalLayout();
            Label spaceEater = new Label(" ");
            this.toolbarLayout.addComponent((Component)spaceEater);
            this.toolbarLayout.setExpandRatio((Component)spaceEater, 1.0f);
            this.toolbarLayout.addComponent(this.getTitle());
            this.toolbarLayout.setWidth("100%");
            this.toolbarLayout.setHeight(40.0f, Sizeable.Unit.PIXELS);
            this.toolbarLayout.setStyleName("toolbar");
        }
        return this.toolbarLayout;
    }

    public Component getTitle() {
        Label label = new Label("Chipster admin");
        label.addStyleName("title");
        label.setWidth(250.0f, Sizeable.Unit.PIXELS);
        return label;
    }

    protected void init(VaadinRequest request) {
        this.buildMainLayout();
    }
}

