/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Date;
import org.apache.kahadb.util.IOExceptionSupport;
import org.apache.kahadb.util.IOHelper;

public class LockFile {
    private static final boolean DISABLE_FILE_LOCK = "true".equals(System.getProperty("java.nio.channels.FileLock.broken", "false"));
    private final File file;
    private FileLock lock;
    private RandomAccessFile readFile;
    private int lockCounter;
    private final boolean deleteOnUnlock;

    public LockFile(File file, boolean deleteOnUnlock) {
        this.file = file;
        this.deleteOnUnlock = deleteOnUnlock;
    }

    public synchronized void lock() throws IOException {
        if (DISABLE_FILE_LOCK) {
            return;
        }
        if (this.lockCounter > 0) {
            return;
        }
        IOHelper.mkdirs(this.file.getParentFile());
        if (System.getProperty(this.getVmLockKey()) != null) {
            throw new IOException("File '" + this.file + "' could not be locked as lock is already held for this jvm.");
        }
        if (this.lock == null) {
            this.readFile = new RandomAccessFile(this.file, "rw");
            IOException reason = null;
            try {
                this.lock = this.readFile.getChannel().tryLock();
            }
            catch (OverlappingFileLockException e) {
                reason = IOExceptionSupport.create("File '" + this.file + "' could not be locked.", e);
            }
            catch (IOException ioe) {
                reason = ioe;
            }
            if (this.lock != null) {
                ++this.lockCounter;
                System.setProperty(this.getVmLockKey(), new Date().toString());
            } else {
                this.closeReadFile();
                if (reason != null) {
                    throw reason;
                }
                throw new IOException("File '" + this.file + "' could not be locked.");
            }
        }
    }

    public void unlock() {
        if (DISABLE_FILE_LOCK) {
            return;
        }
        --this.lockCounter;
        if (this.lockCounter != 0) {
            return;
        }
        if (this.lock != null) {
            try {
                this.lock.release();
                System.getProperties().remove(this.getVmLockKey());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.lock = null;
        }
        this.closeReadFile();
        if (this.deleteOnUnlock) {
            this.file.delete();
        }
    }

    private String getVmLockKey() throws IOException {
        return this.getClass().getName() + ".lock." + this.file.getCanonicalPath();
    }

    private void closeReadFile() {
        if (this.readFile != null) {
            try {
                this.readFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.readFile = null;
        }
    }
}

