/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import java.util.Map;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.util.LRUCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryIdempotentRepository
implements IdempotentRepository<String> {
    private Map<String, Object> cache;

    public MemoryIdempotentRepository() {
        this.cache = new LRUCache<String, Object>(1000);
    }

    public MemoryIdempotentRepository(Map<String, Object> set) {
        this.cache = set;
    }

    public static IdempotentRepository<String> memoryIdempotentRepository() {
        return new MemoryIdempotentRepository();
    }

    public static IdempotentRepository<String> memoryIdempotentRepository(int cacheSize) {
        return MemoryIdempotentRepository.memoryIdempotentRepository(new LRUCache<String, Object>(cacheSize));
    }

    public static IdempotentRepository<String> memoryIdempotentRepository(Map<String, Object> cache) {
        return new MemoryIdempotentRepository(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String messageId) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(messageId)) {
                return false;
            }
            this.cache.put(messageId, messageId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String key) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            return this.cache.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String key) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            return this.cache.remove(key) != null;
        }
    }

    @Override
    public boolean confirm(String key) {
        return true;
    }

    public Map<String, Object> getCache() {
        return this.cache;
    }

    public void setCache(Map<String, Object> cache) {
        this.cache = cache;
    }
}

