/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.management.mbean.ManagedConsumer;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed Scheduled Polling Consumer")
public class ManagedScheduledPollConsumer
extends ManagedConsumer {
    private ScheduledPollConsumer consumer;

    public ManagedScheduledPollConsumer(CamelContext context, ScheduledPollConsumer consumer) {
        super(context, consumer);
        this.consumer = consumer;
    }

    public ScheduledPollConsumer getConsumer() {
        return this.consumer;
    }

    @ManagedAttribute(description="Scheduled Delay")
    public long getDelay() {
        return this.getConsumer().getDelay();
    }

    @ManagedAttribute(description="Scheduled Delay")
    public void setDelay(long delay) {
        this.getConsumer().setDelay(delay);
    }

    @ManagedAttribute(description="Scheduled Initial Delay")
    public long getInitialDelay() {
        return this.getConsumer().getInitialDelay();
    }

    @ManagedAttribute(description="Scheduled Initial Delay")
    public void setInitialDelay(long initialDelay) {
        this.getConsumer().setInitialDelay(initialDelay);
    }

    @ManagedAttribute(description="Scheduled Fixed Delay")
    public boolean isUseFixedDelay() {
        return this.getConsumer().isUseFixedDelay();
    }

    @ManagedAttribute(description="Scheduled Fixed Delay")
    public void setUseFixedDelay(boolean useFixedDelay) {
        this.getConsumer().setUseFixedDelay(useFixedDelay);
    }

    @ManagedAttribute(description="Scheduled TimeUnit")
    public String getTimeUnit() {
        return this.getConsumer().getTimeUnit().name();
    }

    @ManagedAttribute(description="Scheduled TimeUnit")
    public void setTimeUnit(String timeUnit) {
        this.getConsumer().setTimeUnit(TimeUnit.valueOf(timeUnit));
    }
}

