/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.LineDataSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.reference.ChipsterFastaSequenceIndex;
import net.sf.picard.reference.FastaSequenceIndex;
import net.sf.picard.reference.FastaSequenceIndexEntry;
import net.sf.picard.reference.PicardIndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequence;

public class ChipsterIndexedFastaSequenceFile
extends PicardIndexedFastaSequenceFile {
    private final ChunkDataSource channel;
    private final FastaSequenceIndex index;
    protected static final int BUFFER_SIZE = 1024;

    public ChipsterIndexedFastaSequenceFile(ChunkDataSource file, FastaSequenceIndex index) {
        this.index = index;
        this.channel = file;
    }

    public ChipsterIndexedFastaSequenceFile(ChunkDataSource data, LineDataSource index) throws FileNotFoundException {
        this(data, (FastaSequenceIndex)new ChipsterFastaSequenceIndex(index));
    }

    public List<String> getContigs() {
        LinkedList<String> contigs = new LinkedList<String>();
        for (FastaSequenceIndexEntry entry : this.index) {
            contigs.add(entry.getContig());
        }
        return contigs;
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String contig, long start, long stop) {
        if (start > stop + 1L) {
            throw new PicardException(String.format("Malformed query; start point %d lies after end point %d", start, stop));
        }
        FastaSequenceIndexEntry indexEntry = this.index.getIndexEntry(contig);
        if (stop > indexEntry.getSize()) {
            throw new PicardException("Query asks for data past end of contig");
        }
        int length = (int)(stop - start + 1L);
        byte[] target = new byte[length];
        ByteBuffer targetBuffer = ByteBuffer.wrap(target);
        int basesPerLine = indexEntry.getBasesPerLine();
        int bytesPerLine = indexEntry.getBytesPerLine();
        int terminatorLength = bytesPerLine - basesPerLine;
        long startOffset = (start - 1L) / (long)basesPerLine * (long)bytesPerLine + (start - 1L) % (long)basesPerLine;
        ByteBuffer channelBuffer = ByteBuffer.allocate(1024);
        while (targetBuffer.position() < length) {
            startOffset += (long)Math.max((int)(startOffset % (long)bytesPerLine - (long)basesPerLine + 1L), 0);
            try {
                startOffset += (long)this.channel.read(indexEntry.getLocation() + startOffset, channelBuffer.array());
            }
            catch (IOException ex) {
                throw new PicardException("Unable to load " + contig + "(" + start + ", " + stop + ") from " + this.channel.toString(), (Throwable)ex);
            }
            channelBuffer.flip();
            int positionInContig = (int)start - 1 + targetBuffer.position();
            int nextBaseSpan = Math.min(basesPerLine - positionInContig % basesPerLine, length - targetBuffer.position());
            int bytesToTransfer = Math.min(nextBaseSpan, channelBuffer.capacity());
            channelBuffer.limit(channelBuffer.position() + bytesToTransfer);
            while (channelBuffer.hasRemaining()) {
                targetBuffer.put(channelBuffer);
                bytesToTransfer = Math.min(basesPerLine, length - targetBuffer.position());
                channelBuffer.limit(Math.min(channelBuffer.position() + bytesToTransfer + terminatorLength, channelBuffer.capacity()));
                channelBuffer.position(Math.min(channelBuffer.position() + terminatorLength, channelBuffer.capacity()));
            }
            channelBuffer.flip();
        }
        return new ReferenceSequence(contig, indexEntry.getSequenceIndex(), target);
    }
}

