/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BpCoordFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.IndexedFastaHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.SequenceBuffer;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.IndexedFastaDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ParsedFileResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.sf.picard.PicardException;
import net.sf.picard.reference.ReferenceSequence;

public class IndexedFastaFileFetcherThread
extends Thread {
    private static final Long BUFFER_EXTRA = 1000L;
    private BlockingQueue<BpCoordFileRequest> fileRequestQueue;
    private ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue;
    private IndexedFastaDataSource dataSource;
    private IndexedFastaHandlerThread areaRequestThread;
    private boolean poison = false;
    private SequenceBuffer buffer;

    public IndexedFastaFileFetcherThread(BlockingQueue<BpCoordFileRequest> fileRequestQueue, ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue, IndexedFastaHandlerThread areaRequestThread, IndexedFastaDataSource dataSource) {
        this.fileRequestQueue = fileRequestQueue;
        this.fileResultQueue = fileResultQueue;
        this.areaRequestThread = areaRequestThread;
        this.dataSource = dataSource;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        this.setName(this.getClass().getName());
        while (!this.poison) {
            try {
                for (BpCoordFileRequest fileRequest : this.fileRequestQueue) {
                    if (!fileRequest.getStatus().poison) continue;
                    this.poison = true;
                    return;
                }
                this.processFileRequest(this.fileRequestQueue.take());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private void processFileRequest(BpCoordFileRequest fileRequest) throws IOException, URISyntaxException {
        if (fileRequest.getStatus().poison) {
            this.poison = true;
            return;
        }
        this.fetchSequence(fileRequest);
    }

    public void fetchSequence(BpCoordFileRequest fileRequest) throws FileNotFoundException, URISyntaxException {
        Region requestRegion = new Region(fileRequest.areaRequest);
        if (requestRegion.start.bp < 1L) {
            requestRegion.start.bp = 1L;
        }
        LinkedList<RegionContent> responseList = new LinkedList<RegionContent>();
        try {
            String chr = this.dataSource.getChromosomeNameUnnormaliser().unnormalise(requestRegion.start.chr);
            if (this.buffer == null || !this.buffer.contains(requestRegion.start.bp, requestRegion.end.bp, requestRegion.start.chr)) {
                long bufferStart = Math.max(requestRegion.start.bp - BUFFER_EXTRA, 0L);
                long bufferEnd = requestRegion.end.bp + BUFFER_EXTRA;
                ReferenceSequence seq = this.dataSource.getPicard().getSubsequenceAt(chr, bufferStart, bufferEnd);
                this.buffer = new SequenceBuffer(new String(seq.getBases()), bufferStart, requestRegion.start.chr);
            }
            String seqString = this.buffer.get(requestRegion.start.bp, requestRegion.end.bp, requestRegion.start.chr);
            Region recordRegion = new Region(requestRegion.start.bp, requestRegion.end.bp, requestRegion.start.chr);
            LinkedHashMap<ColumnType, Object> values = new LinkedHashMap<ColumnType, Object>();
            values.put(ColumnType.SEQUENCE, seqString);
            RegionContent regCont = new RegionContent(recordRegion, values);
            responseList.add(regCont);
        }
        catch (PicardException e) {
            e.printStackTrace();
        }
        ParsedFileResult result = new ParsedFileResult(responseList, fileRequest, fileRequest.areaRequest, fileRequest.getStatus());
        this.fileResultQueue.add(result);
        this.areaRequestThread.notifyAreaRequestHandler();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " - " + this.dataSource;
    }
}

