/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BpCoordFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.GtfTabixHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.TabixFileFetcherThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Exon;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Gene;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneSet;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ParsedFileResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.broad.tribble.readers.TabixReader;

public class GtfTabixFileFetcherThread
extends TabixFileFetcherThread {
    private GtfTabixHandlerThread areaRequestThread;
    private static final String[] ID_FIELDS = new String[]{"gene_id", "transcript_id", "exon_number", "gene_name", "transcript_name"};

    public GtfTabixFileFetcherThread(BlockingQueue<BpCoordFileRequest> fileRequestQueue, ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue, GtfTabixHandlerThread areaRequestThread, TabixDataSource dataSource) {
        this.fileRequestQueue = fileRequestQueue;
        this.fileResultQueue = fileResultQueue;
        this.areaRequestThread = areaRequestThread;
        this.dataSource = dataSource;
        this.setDaemon(true);
    }

    @Override
    protected void processFileRequest(BpCoordFileRequest fileRequest) throws IOException {
        if (fileRequest.getStatus().poison) {
            this.poison = true;
            return;
        }
        List<RegionContent> resultList = null;
        if (fileRequest.areaRequest instanceof GeneRequest) {
            resultList = this.processGeneSearch((GeneRequest)fileRequest.areaRequest, fileRequest);
        } else {
            Region region = new Region(fileRequest.getFrom(), fileRequest.getTo());
            resultList = new LinkedList<RegionContent>();
            GeneSet genes = this.fetchExons(region);
            for (Gene gene : genes.values()) {
                LinkedHashMap<ColumnType, Object> values = new LinkedHashMap<ColumnType, Object>();
                values.put(ColumnType.VALUE, gene);
                resultList.add(new RegionContent(gene.getRegion(), values));
            }
        }
        ParsedFileResult result = new ParsedFileResult(resultList, fileRequest, fileRequest.areaRequest, fileRequest.getStatus());
        this.fileResultQueue.add(result);
        this.areaRequestThread.notifyAreaRequestHandler();
    }

    private List<RegionContent> processGeneSearch(GeneRequest areaRequest, BpCoordFileRequest fileRequest) throws IOException {
        String searchString = areaRequest.getSearchString().toLowerCase();
        Chromosome chr = areaRequest.start.chr;
        Region region = new Region(1L, Long.MAX_VALUE, chr);
        GeneSet genes = this.fetchExons(region);
        LinkedList<RegionContent> resultList = new LinkedList<RegionContent>();
        for (Gene gene : genes.values()) {
            if (gene.getName() == null || !gene.getName().toLowerCase().equals(searchString)) continue;
            LinkedHashMap<ColumnType, Object> values = new LinkedHashMap<ColumnType, Object>();
            values.put(ColumnType.VALUE, gene);
            resultList.add(new RegionContent(gene.getRegion(), values));
        }
        return resultList;
    }

    public GeneSet fetchExons(Region request) throws IOException {
        TabixReader.Iterator iter = this.getTabixIterator(request);
        GeneSet genes = new GeneSet();
        if (iter != null) {
            String line;
            while ((line = iter.next()) != null) {
                this.parseGtfLine(line, genes);
            }
        }
        return genes;
    }

    private void parseGtfLine(String line, GeneSet genes) {
        String[] cols = line.split("\t");
        String chr = cols[0];
        String biotype = cols[1];
        String feature = cols[2];
        String exonStart = cols[3];
        String exonEnd = cols[4];
        String strand = cols[6];
        String[] ids = GtfTabixFileFetcherThread.parseIds(cols[8]);
        String geneId = ids[0];
        String transcId = ids[1];
        String exonIndex = ids[2];
        String geneName = ids[3];
        String transcName = ids[4];
        if ("exon".equals(feature) || "CDS".equals(feature)) {
            Region region = new Region((Long)Long.parseLong(exonStart), Long.parseLong(exonEnd), new Chromosome(chr), GtfTabixFileFetcherThread.getStrand(strand));
            Exon exon = new Exon(region, feature, Integer.parseInt(exonIndex));
            genes.addExon(exon, geneId, transcId, geneName, transcName, biotype);
        } else if (feature.startsWith("GenBank")) {
            Region region = new Region((Long)Long.parseLong(exonStart), Long.parseLong(exonEnd), new Chromosome(chr), GtfTabixFileFetcherThread.getStrand(strand));
            if (geneId == null || transcId == null) {
                return;
            }
            if ("GenBank gene".equals(feature)) {
                feature = "exon";
            } else if ("GenBank CDS".equals(feature)) {
                feature = "CDS";
            } else {
                geneId = feature + geneId;
                transcId = feature + transcId;
                if (geneName != null) {
                    geneName = feature + " " + geneName;
                }
                if (transcName != null) {
                    transcName = feature + " " + transcName;
                }
                feature = "exon";
            }
            exonIndex = "1";
            Exon exon = new Exon(region, feature, Integer.parseInt(exonIndex));
            genes.addExon(exon, geneId, transcId, geneName, transcName, biotype);
        }
    }

    private static Strand getStrand(String strand) {
        if ("+".equals(strand)) {
            return Strand.FORWARD;
        }
        if ("-".equals(strand)) {
            return Strand.REVERSE;
        }
        if (".".equals(strand)) {
            return Strand.NONE;
        }
        return Strand.UNRECOGNIZED;
    }

    public static String[] parseIds(String ids) {
        String[] split = ids.split(";");
        String[] result = new String[ID_FIELDS.length];
        String key = null;
        String value = null;
        int indexOfQuotationMark = 0;
        for (int i = 0; i < split.length; ++i) {
            indexOfQuotationMark = split[i].indexOf("\"");
            key = split[i].substring(1, indexOfQuotationMark - 1);
            value = split[i].substring(indexOfQuotationMark + 1, split[i].lastIndexOf("\""));
            for (int fieldNumber = 0; fieldNumber < ID_FIELDS.length; ++fieldNumber) {
                if (!ID_FIELDS[fieldNumber].equals(key)) continue;
                result[fieldNumber] = value;
            }
        }
        return result;
    }

    public class Transcript {
        Region region;
        List<Exon> exons;
    }
}

