/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.sf.picard.PicardException;
import net.sf.picard.filter.FilteringIterator;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;
import net.sf.picard.util.Log;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.Cigar;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMTag;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.CloseableIterator;

class MultiHitAlignedReadIterator
implements CloseableIterator<HitsForInsert> {
    private static final Log log = Log.getInstance(MultiHitAlignedReadIterator.class);
    private final PeekableIterator<SAMRecord> peekIterator;
    private final HitIndexComparator comparator = new HitIndexComparator();
    private final SAMRecordQueryNameComparator queryNameComparator = new SAMRecordQueryNameComparator();
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private final Random random = new Random(1L);

    MultiHitAlignedReadIterator(CloseableIterator<SAMRecord> querynameOrderIterator, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
        this.peekIterator = new PeekableIterator(new FilteringIterator((Iterator<SAMRecord>)querynameOrderIterator, new SamRecordFilter(){

            @Override
            public boolean filterOut(SAMRecord record) {
                return record.getReadUnmappedFlag() || SAMUtils.cigarMapsNoBasesToRef((Cigar)record.getCigar());
            }

            @Override
            public boolean filterOut(SAMRecord first, SAMRecord second) {
                return !(!first.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef((Cigar)first.getCigar()) || !second.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef((Cigar)second.getCigar()));
            }
        }));
    }

    public void close() {
        this.peekIterator.close();
    }

    public boolean hasNext() {
        return this.peekIterator.hasNext();
    }

    public HitsForInsert next() {
        String readName = this.peekIterator.peek().getReadName();
        HitsForInsert hits = new HitsForInsert();
        Boolean isPaired = null;
        while (this.peekIterator.hasNext() && this.peekIterator.peek().getReadName().equals(readName)) {
            SAMRecord rec = this.peekIterator.next();
            if (this.peekIterator.hasNext() && this.queryNameComparator.fileOrderCompare(rec, this.peekIterator.peek()) > 0) {
                throw new IllegalStateException("Underlying iterator is not queryname sorted: " + rec + " > " + this.peekIterator.peek());
            }
            if (SAMUtils.cigarMapsNoBasesToRef((Cigar)rec.getCigar())) {
                SAMUtils.makeReadUnmapped((SAMRecord)rec);
            }
            if (isPaired == null) {
                isPaired = rec.getReadPairedFlag();
            } else if (isPaired.booleanValue() != rec.getReadPairedFlag()) {
                throw new PicardException("Got a mix of paired and unpaired alignments for read " + readName);
            }
            if (!rec.getReadPairedFlag() || rec.getFirstOfPairFlag()) {
                hits.firstOfPairOrFragment.add(rec);
                continue;
            }
            if (rec.getSecondOfPairFlag()) {
                hits.secondOfPair.add(rec);
                continue;
            }
            throw new PicardException("Read is marked as pair but neither first or second: " + readName);
        }
        if (!hits.firstOfPairOrFragment.isEmpty() && !hits.secondOfPair.isEmpty()) {
            if (hits.firstOfPairOrFragment.size() != hits.secondOfPair.size()) {
                throw new PicardException("Unequal number of first and second of pair hits for read: " + readName);
            }
            if (hits.firstOfPairOrFragment.size() > 1) {
                Collections.sort(hits.firstOfPairOrFragment, this.comparator);
                Collections.sort(hits.secondOfPair, this.comparator);
                for (int i = 0; i < hits.firstOfPairOrFragment.size(); ++i) {
                    if (((SAMRecord)hits.firstOfPairOrFragment.get(i)).getIntegerAttribute(SAMTag.HI.name()) == null) {
                        throw new PicardException("Missing HI tag on multi-hit alignment for read: " + readName);
                    }
                    if (((SAMRecord)hits.firstOfPairOrFragment.get(i)).getIntegerAttribute(SAMTag.HI.name()).equals(((SAMRecord)hits.secondOfPair.get(i)).getIntegerAttribute(SAMTag.HI.name()))) continue;
                    throw new PicardException("Hit index mismatch for multi-hit alignment for read: " + readName);
                }
            }
        }
        NumPrimaryAlignmentState firstEndAlignmentState = hits.tallyPrimaryAlignments(hits.firstOfPairOrFragment);
        NumPrimaryAlignmentState secondEndAlignmentState = hits.tallyPrimaryAlignments(hits.secondOfPair);
        if (firstEndAlignmentState == NumPrimaryAlignmentState.NONE && secondEndAlignmentState == NumPrimaryAlignmentState.NONE || firstEndAlignmentState == NumPrimaryAlignmentState.MORE_THAN_ONE || secondEndAlignmentState == NumPrimaryAlignmentState.MORE_THAN_ONE) {
            this.primaryAlignmentSelectionStrategy.pickPrimaryAlignment(hits);
        } else {
            int firstEndPrimaryAlignmentIndex = hits.findPrimaryAlignment(hits.firstOfPairOrFragment);
            int secondEndPrimaryAlignmentIndex = hits.findPrimaryAlignment(hits.secondOfPair);
            if (firstEndPrimaryAlignmentIndex != -1 && secondEndPrimaryAlignmentIndex != -1 && firstEndPrimaryAlignmentIndex != secondEndPrimaryAlignmentIndex) {
                throw new PicardException("Mismatched primary alignments for paired read " + hits.getReadName());
            }
        }
        return hits;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class HitIndexComparator
    implements Comparator<SAMRecord> {
        private HitIndexComparator() {
        }

        @Override
        public int compare(SAMRecord rec1, SAMRecord rec2) {
            Integer hi1 = rec1.getIntegerAttribute(SAMTag.HI.name());
            Integer hi2 = rec2.getIntegerAttribute(SAMTag.HI.name());
            if (hi1 == null || hi2 == null) {
                throw new PicardException("HI tag missing for multi-hit paired alignments for read: " + rec1.getReadName());
            }
            return hi1.compareTo(hi2);
        }
    }

    private static enum NumPrimaryAlignmentState {
        NONE,
        ONE,
        MORE_THAN_ONE;

    }

    public class HitsForInsert {
        private final List<SAMRecord> firstOfPairOrFragment = new ArrayList<SAMRecord>();
        private final List<SAMRecord> secondOfPair = new ArrayList<SAMRecord>();

        public String getReadName() {
            return this.getRepresentativeRead().getReadName();
        }

        public boolean isPaired() {
            return this.getRepresentativeRead().getReadPairedFlag();
        }

        public SAMRecord getRepresentativeRead() {
            for (SAMRecord rec : this.firstOfPairOrFragment) {
                if (rec == null) continue;
                return rec;
            }
            for (SAMRecord rec : this.secondOfPair) {
                if (rec == null) continue;
                return rec;
            }
            throw new IllegalStateException("Should not be called if numHits == 0");
        }

        public int numHits() {
            return Math.max(this.firstOfPairOrFragment.size(), this.secondOfPair.size());
        }

        public SAMRecord getFirstOfPair(int i) {
            if (this.firstOfPairOrFragment.isEmpty()) {
                return null;
            }
            return this.firstOfPairOrFragment.get(i);
        }

        public SAMRecord getFragment(int i) {
            SAMRecord samRecord = this.firstOfPairOrFragment.get(i);
            if (samRecord.getReadPairedFlag()) {
                throw new UnsupportedOperationException("getFragment called for paired read");
            }
            return samRecord;
        }

        public SAMRecord getSecondOfPair(int i) {
            if (this.secondOfPair.isEmpty()) {
                return null;
            }
            return this.secondOfPair.get(i);
        }

        public void setPrimaryAlignment(int primaryAlignmentIndex) {
            if (primaryAlignmentIndex < 0 || primaryAlignmentIndex >= this.numHits()) {
                throw new IllegalArgumentException("primaryAlignmentIndex(" + primaryAlignmentIndex + ") out of range for numHits(" + this.numHits() + ")");
            }
            for (int i = 0; i < this.numHits(); ++i) {
                boolean notPrimary;
                boolean bl = notPrimary = i != primaryAlignmentIndex;
                if (this.getFirstOfPair(i) != null) {
                    this.getFirstOfPair(i).setNotPrimaryAlignmentFlag(notPrimary);
                }
                if (this.getSecondOfPair(i) == null) continue;
                this.getSecondOfPair(i).setNotPrimaryAlignmentFlag(notPrimary);
            }
        }

        public void filterReads(SamRecordFilter filter, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
            int i;
            this.filterReads(filter, this.firstOfPairOrFragment);
            this.filterReads(filter, this.secondOfPair);
            if (!this.firstOfPairOrFragment.isEmpty() && !this.secondOfPair.isEmpty()) {
                if (this.firstOfPairOrFragment.size() != this.secondOfPair.size()) {
                    throw new IllegalStateException("Both ends of pair have hits, but not the same number of hits for each end");
                }
                for (i = this.firstOfPairOrFragment.size() - 1; i >= 0; --i) {
                    if (this.firstOfPairOrFragment.get(i) == null) {
                        if (this.secondOfPair.get(i) == null) {
                            this.firstOfPairOrFragment.remove(i);
                            this.secondOfPair.remove(i);
                            continue;
                        }
                        this.secondOfPair.get(i).setAttribute(SAMTag.HI.name(), null);
                        continue;
                    }
                    if (this.secondOfPair.get(i) != null) continue;
                    this.firstOfPairOrFragment.get(i).setAttribute(SAMTag.HI.name(), null);
                }
                if (this.areAllElementsNull(this.firstOfPairOrFragment)) {
                    this.firstOfPairOrFragment.clear();
                }
                if (this.areAllElementsNull(this.secondOfPair)) {
                    this.secondOfPair.clear();
                }
            } else {
                this.squeezeList(this.firstOfPairOrFragment);
                this.squeezeList(this.secondOfPair);
            }
            if (this.numHits() == 0) {
                return;
            }
            if (this.numHits() == 1) {
                if (this.getFirstOfPair(0) != null) {
                    this.getFirstOfPair(0).setAttribute(SAMTag.HI.name(), null);
                }
                if (this.getSecondOfPair(0) != null) {
                    this.getSecondOfPair(0).setAttribute(SAMTag.HI.name(), null);
                }
            } else {
                for (i = 0; i < this.numHits(); ++i) {
                    if (this.getFirstOfPair(i) != null) {
                        this.getFirstOfPair(i).setAttribute(SAMTag.HI.name(), (Object)i);
                    }
                    if (this.getSecondOfPair(i) == null) continue;
                    this.getSecondOfPair(i).setAttribute(SAMTag.HI.name(), (Object)i);
                }
            }
            int firstEndPrimaryAlignmentIndex = this.findPrimaryAlignment(this.firstOfPairOrFragment);
            int secondEndPrimaryAlignmentIndex = this.findPrimaryAlignment(this.secondOfPair);
            if (firstEndPrimaryAlignmentIndex != -1 ? (secondEndPrimaryAlignmentIndex == -1 ? this.getSecondOfPair(firstEndPrimaryAlignmentIndex) != null : firstEndPrimaryAlignmentIndex != secondEndPrimaryAlignmentIndex) : secondEndPrimaryAlignmentIndex != -1 && this.getFirstOfPair(secondEndPrimaryAlignmentIndex) != null) {
                throw new IllegalStateException("Mismatched primary alignments for read " + this.getReadName());
            }
            if (firstEndPrimaryAlignmentIndex == -1 && secondEndPrimaryAlignmentIndex == -1) {
                primaryAlignmentSelectionStrategy.pickPrimaryAlignment(this);
            }
        }

        private void filterReads(SamRecordFilter filter, List<SAMRecord> records) {
            for (int i = 0; i < records.size(); ++i) {
                if (!filter.filterOut(records.get(i))) continue;
                records.set(i, null);
            }
        }

        private void squeezeList(List<SAMRecord> records) {
            for (int i = records.size() - 1; i >= 0; --i) {
                if (records.get(i) != null) continue;
                records.remove(i);
            }
        }

        private boolean areAllElementsNull(List<SAMRecord> records) {
            for (SAMRecord rec : records) {
                if (rec == null) continue;
                return false;
            }
            return true;
        }

        private NumPrimaryAlignmentState tallyPrimaryAlignments(List<SAMRecord> records) {
            boolean seenPrimary = false;
            for (int i = 0; i < records.size(); ++i) {
                if (records.get(i) == null || records.get(i).getNotPrimaryAlignmentFlag()) continue;
                if (seenPrimary) {
                    return NumPrimaryAlignmentState.MORE_THAN_ONE;
                }
                seenPrimary = true;
            }
            if (seenPrimary) {
                return NumPrimaryAlignmentState.ONE;
            }
            return NumPrimaryAlignmentState.NONE;
        }

        private int findPrimaryAlignment(List<SAMRecord> records) {
            int indexOfPrimaryAlignment = -1;
            for (int i = 0; i < records.size(); ++i) {
                if (records.get(i) == null || records.get(i).getNotPrimaryAlignmentFlag()) continue;
                if (indexOfPrimaryAlignment != -1) {
                    throw new IllegalStateException("Multiple primary alignments found for read " + this.getReadName());
                }
                indexOfPrimaryAlignment = i;
            }
            return indexOfPrimaryAlignment;
        }
    }
}

