/*
 * Projection.java
 *
 * Created on 28. toukokuuta 2006, 19:59
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package threed;

import java.util.*;
import java.awt.Color;

/**
 *
 * @author esa
 */
public class Projection {
    
    /** Creates a new instance of Projection */
    public Projection() {
    }
    
    private double xAxisRotation = 0;//Math.PI;
    private double yAxisRotation = 0;//Math.PI*0.25;
    private double zAxisRotation = 0;
    private double distanceOfProjectionPlaneFromCamera = 5;
    private double viewWindowWidth = 5;
    private double viewWindowHeight = 5;
    private double[] camera = {0,0,-6};
    private double[] newOrigin = {0,0,0};
    private DataPoint dataOrigin = new DataPoint(0, 0, 0, Color.GREEN, 0.0);
    
    private PriorityQueue<Drawable> resultPoints = null;
     
    
    public Drawable[] points = {
        new DataPoint(1, 1, 1, Color.RED, 0.03, "<html>There are 10 kinds of people in the world,<br>those who understand binary<br>and those who don't.</html>"),
     new DataPoint(Math.random()*2, Math.random()*2, Math.random()*2, Color.GREEN, 0.03, "GREEN"),
     new DataPoint(Math.random()*2,Math.random()*2, Math.random()*2, Color.YELLOW, 0.03, "YELLOW"),
     new DataPoint(Math.random()*2,Math.random()*2,Math.random()*2, Color.WHITE, 0.03, "WHITE"),
    new DataPoint(Math.random()*2, Math.random()*2, Math.random()*2, Color.PINK, 0.03, "PINK"),
    new DataPoint(Math.random()*2, Math.random()*2,Math.random()*2, Color.ORANGE, 0.03, "ORANGE"),
    new DataPoint(Math.random()*2,Math.random()*2, Math.random()*2, Color.MAGENTA, 0.03, "MAGENTA"),
    new DataPoint(Math.random()*2,Math.random()*2,Math.random()*2, Color.CYAN, 0.03, "CYAN"),
           
     new DataPoint(Math.random()*2, Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
     new DataPoint(Math.random()*2,Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
    new DataPoint(Math.random()*2, Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
    new DataPoint(Math.random()*2,Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
     new DataPoint(Math.random()*2, Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
     new DataPoint(Math.random()*2, Math.random()*2,Math.random()*2, Color.BLUE, 0.03),
     new DataPoint(Math.random()*2,Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
     new DataPoint(Math.random()*2,Math.random()*2,Math.random()*2, Color.BLUE, 0.03),
     new DataPoint(Math.random()*2, Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
     new DataPoint(Math.random()*2, Math.random()*2,Math.random()*2, Color.BLUE, 0.03),
    new DataPoint(Math.random()*2, Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
    new DataPoint(Math.random()*2, Math.random()*2,Math.random()*2, Color.BLUE, 0.03),
             
     new DataPoint(Math.random()*2, Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
    new DataPoint(Math.random()*2, Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
     new DataPoint(Math.random()*2, Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
     new DataPoint(Math.random()*2,Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
     new DataPoint(Math.random()*2, Math.random()*2, Math.random()*2, Color.BLUE, 0.03),
     new DataPoint(Math.random()*2, Math.random()*2,Math.random()*2, Color.BLUE, 0.03),
            
     new Line(0, 0 , 0, 2, 0, 0, Color.RED, "X"),
     new Line(0, 0 , 0, 0, 2, 0, Color.GREEN, "Y"),
     new Line(0, 0 , 0, 0, 0, 2, Color.BLUE, "Z"),
             
     new Line(0, 0.5 , 0, 2, 0.5, 0, Color.WHITE, null),
     new Line(0, 1.0 , 0, 2, 1.0, 0, Color.WHITE, null),
     new Line(0, 1.5 , 0, 2, 1.5, 0, Color.WHITE, null),
     new Line(0, 2.0 , 0, 2, 2.0, 0, Color.WHITE, null),
             
     new Line(0.5, 0 , 0, 0.5, 2, 0, Color.WHITE, null),
     new Line(1.0, 0 , 0, 1.0, 2, 0, Color.WHITE, null),
     new Line(1.5, 0 , 0, 1.5, 2, 0, Color.WHITE, null),
     new Line(2.0, 0 , 0, 2.0, 2, 0, Color.WHITE, null),
     
     new Line(0, 0, 0.5 , 0, 2, 0.5, Color.WHITE, null),
     new Line(0, 0, 1.0 , 0, 2, 1.0, Color.WHITE, null),
     new Line(0, 0, 1.5 , 0, 2, 1.5, Color.WHITE, null),
     new Line(0, 0, 2.0 , 0, 2, 2.0, Color.WHITE, null),
             
     new Line(0, 0.5, 0 , 0, 0.5, 2, Color.WHITE, null),
     new Line(0, 1.0, 0 , 0, 1.0, 2, Color.WHITE, null),
     new Line(0, 1.5, 0 , 0, 1.5, 2, Color.WHITE, null),
     new Line(0, 2.0, 0 , 0, 2.0, 2, Color.WHITE, null),
     
     new Line(0.5, 0, 0, 0.5 , 0, 2, Color.WHITE, null),
     new Line(1.0, 0, 0, 1.0 , 0, 2, Color.WHITE, null),
     new Line(1.5, 0, 0, 1.5 , 0, 2, Color.WHITE, null),
     new Line(2.0, 0,0, 2.0 , 0, 2,  Color.WHITE, null),
             
     new Line(2, 0, 0.5, 0 , 0, 0.5, Color.WHITE, null),
     new Line(2, 0, 1.0, 0 , 0, 1.0, Color.WHITE, null),
     new Line(2, 0, 1.5, 0 , 0, 1.5, Color.WHITE, null),
     new Line(2, 0, 2.0, 0 , 0, 2.0, Color.WHITE, null)
    };
    
    /**
     * 
     * @return 
     */
    public double getXAxisRotation() {
        return xAxisRotation;
    }

    /**
     * 
     * @param xAxisRotation 
     */
    public void setXAxisRotation(double xAxisRotation) {
        this.xAxisRotation = xAxisRotation;
    }

    /**
     * 
     * @return 
     */
    public double getYAxisRotation() {
        return yAxisRotation;
    }

    /**
     * 
     * @param yAxisRotation 
     */
    public void setYAxisRotation(double yAxisRotation) {
        this.yAxisRotation = yAxisRotation;
    }

    /**
     * 
     * @return 
     */
    public double getZAxisRotation() {
        return zAxisRotation;
    }

    /**
     * 
     * @param zAxisRotation 
     */
    public void setZAxisRotation(double zAxisRotation) {
        this.zAxisRotation = zAxisRotation;
    }

    /**
     * 
     * @return 
     */
    public double getDistanceOfProjectionPlaneFromOrigin() {
        return distanceOfProjectionPlaneFromCamera;
    }

    /**
     * 
     * @param distanceOfProjectionPlaneFromOrigin 
     */
    public void setDistanceOfProjectionPlaneFromOrigin(
            double distanceOfProjectionPlaneFromOrigin
            ) {
        this.distanceOfProjectionPlaneFromCamera = 
                distanceOfProjectionPlaneFromOrigin;
    }

    /**
     * 
     * @return 
     */
    public double getViewWindowWidth() {
        return viewWindowWidth;
    }

    /**
     * 
     * @param viewWindowWidth 
     */
    public void setViewWindowWidth(double viewWindowWidth) {
        this.viewWindowWidth = viewWindowWidth;
    }

    /**
     * 
     * @return 
     */
    public double getViewWindowHeight() {
        return viewWindowHeight;
    }

    /**
     * 
     * @param viewWindowHeight 
     */
    public void setViewWindowHeight(double viewWindowHeight) {
        this.viewWindowHeight = viewWindowHeight;
    }

    /**
     * 
     * @return 
     */
    public double[] getPointOfView() {
        return camera;
    }

    /**
     * 
     * @param pointOfView 
     */
    public void setPointOfView(double[] pointOfView) {
        this.camera = pointOfView;
    }
    
    /**
     * 
     * @return 
     */
    public double[] getNewOrigin() {
        return newOrigin;
    }

    /**
     * 
     * @param newOrigin 
     */
    public void setNewOrigin(double[] newOrigin) {
        this.newOrigin[0] = newOrigin[0];
        this.newOrigin[1] = newOrigin[1];
        this.newOrigin[2] = newOrigin[2];
    }
    
    /**
     * 
     * @return 
     */
    public PriorityQueue<Drawable> getResultPoints() {
        return resultPoints;
    }

    /**
     * 
     * @return 
     */
    public DataPoint getDataOrigin() {
        return dataOrigin;
    }

    private Matrix xAxisRotationMatrix(double degree) {
        double cosDegree = Math.cos(degree);
        double sinDegree = Math.sin(degree);
        Matrix m = new Matrix(4,4,0);
        
        m.set(1,1,cosDegree);
        m.set(2,2,cosDegree);
        m.set(1,2,-sinDegree);
        m.set(2,1,sinDegree);
        m.set(0,0,1);
        m.set(3,3,1);
        
        return m;
    }
    
    private Matrix yAxisRotationMatrix(double degree) {
        double cosDegree = Math.cos(degree);
        double sinDegree = Math.sin(degree);
        Matrix m = new Matrix(4,4,0);
        
        m.set(0,0,cosDegree);
        m.set(2,2,cosDegree);
        m.set(2,0,-sinDegree);
        m.set(0,2,sinDegree);
        m.set(1,1,1);
        m.set(3,3,1);
        
        return m;
    }
    
    private Matrix zAxisRotationMatrix(double degree) {
        double cosDegree = Math.cos(degree);
        double sinDegree = Math.sin(degree);
        Matrix m = new Matrix(4,4,0);
        
        m.set(0,0,cosDegree);
        m.set(1,1,cosDegree);
        m.set(0,1,-sinDegree);
        m.set(1,0,sinDegree);
        m.set(2,2,1);
        m.set(3,3,1);
        
        return m;
    }
    
    private Matrix translatePointToOriginMatrix(double[] point) {
        Matrix m = new Matrix(4,4,0);
        
        m.set(0,0,1);
        m.set(1,1,1);
        m.set(2,2,1);
        m.set(3,3,1);
        m.set(0,3,-point[0]);
        m.set(1,3,-point[1]);
        m.set(2,3,-point[2]);
        
        return m;
    }
    
    private Matrix perspectiveProjectionMatrix(double planeDistance) {
        Matrix m = new Matrix(4,4,0);
        
        m.set(0,0,1);
        m.set(1,1,1);
        m.set(2,2,1);
        m.set(3,2,1/planeDistance);
        
        return m;
    }
    
    private void homogeneousPointToProjectionPlanePoint(Matrix m, double[] p) {
        double w = m.get(3,0);
        p[0] = m.get(0,0)/w;
        p[1] = m.get(1,0)/w;
        //point3D[2] = m.get(2,0)/w;
    }
    
    /**
     * 
     * @return 
     */
    public PriorityQueue<Drawable> doProjection() {
        Matrix projM = perspectiveProjectionMatrix(distanceOfProjectionPlaneFromCamera);
              /*  camera[2] < 0 ? 
                    distanceOfProjectionPlaneFromCamera :
                    -distanceOfProjectionPlaneFromCamera);*/
        projM = projM.times(translatePointToOriginMatrix(camera));
        Matrix rotM = zAxisRotationMatrix(zAxisRotation);
        rotM = rotM.times(yAxisRotationMatrix(yAxisRotation));
        rotM = rotM.times(xAxisRotationMatrix(xAxisRotation));
        rotM = rotM.times(translatePointToOriginMatrix(newOrigin));
        
        resultPoints = new PriorityQueue<Drawable>(points.length);
        
        for (int i=0; i < points.length; i++) {
            boolean visible = rotateAndProject(points[i], rotM, projM, camera,
                    distanceOfProjectionPlaneFromCamera,
                    viewWindowWidth, viewWindowHeight);
            
            if (visible == true) {
                resultPoints.add(points[i]);
            }
        }
        
        rotateAndProject(dataOrigin, rotM, projM, camera,
                distanceOfProjectionPlaneFromCamera,
                viewWindowWidth, viewWindowHeight);
        
        xAxisRotation = yAxisRotation = zAxisRotation = 0;
        newOrigin[0] = newOrigin[1] = newOrigin[2] = 0;
        return resultPoints;
    }
    
    private boolean rotateAndProject(Drawable d, Matrix rot, Matrix proj,
            double[] cam, double planeDist, double viewW, double viewH) {
        Matrix point = new Matrix(4,1,1);
        boolean visible = false;
        
        for (int i=0; i < d.visualisationCoords.length; ++i) {
            point.set(0,0,d.visualisationCoords[i][0]);
            point.set(1,0,d.visualisationCoords[i][1]);
            point.set(2,0,d.visualisationCoords[i][2]);
            point = rot.times(point);
            d.visualisationCoords[i][0] = point.get(0,0);
            d.visualisationCoords[i][1] = point.get(1,0);
            d.visualisationCoords[i][2] = point.get(2,0);
            point = proj.times(point);
            homogeneousPointToProjectionPlanePoint(point, d.projectedCoords[i]);
            
            d.projectedCoords[i][0] /= viewW;
            d.projectedCoords[i][1] /= viewH;
            
             if (d.visualisationCoords[i][2] > camera[2] /*+ planeDist ???*/)
                 visible = true;
            
            point.set(3, 0, 1);
        }
        
        d.setDistanceFromCamera(cam, planeDist,viewW, viewH);
        return visible;
    }

}
