/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.broker.region.cursors.OrderedPendingList;
import org.apache.activemq.broker.region.cursors.PendingList;
import org.apache.activemq.broker.region.cursors.PrioritizedPendingList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMPendingMessageCursor
extends AbstractPendingMessageCursor {
    private final PendingList list;
    private Iterator<MessageReference> iter;

    public VMPendingMessageCursor(boolean prioritizedMessages) {
        super(prioritizedMessages);
        this.useCache = false;
        this.list = this.prioritizedMessages ? new PrioritizedPendingList() : new OrderedPendingList();
    }

    @Override
    public synchronized List<MessageReference> remove(ConnectionContext context, Destination destination) throws Exception {
        ArrayList<MessageReference> rc = new ArrayList<MessageReference>();
        Iterator<MessageReference> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            MessageReference r = iterator.next();
            if (r.getRegionDestination() != destination) continue;
            r.decrementReferenceCount();
            rc.add(r);
            iterator.remove();
        }
        return rc;
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.list.isEmpty()) {
            return true;
        }
        Iterator<MessageReference> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            MessageReference node = iterator.next();
            if (node == QueueMessageReference.NULL_MESSAGE) continue;
            if (!node.isDropped()) {
                return false;
            }
            iterator.remove();
        }
        return true;
    }

    @Override
    public synchronized void reset() {
        this.iter = this.list.iterator();
        this.last = null;
    }

    @Override
    public synchronized void addMessageLast(MessageReference node) {
        node.incrementReferenceCount();
        this.list.addMessageLast(node);
    }

    @Override
    public synchronized void addMessageFirst(MessageReference node) {
        node.incrementReferenceCount();
        this.list.addMessageFirst(node);
    }

    @Override
    public synchronized boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public synchronized MessageReference next() {
        this.last = this.iter.next();
        if (this.last != null) {
            this.last.incrementReferenceCount();
        }
        return this.last;
    }

    @Override
    public synchronized void remove() {
        if (this.last != null) {
            this.last.decrementReferenceCount();
        }
        this.iter.remove();
    }

    @Override
    public synchronized int size() {
        return this.list.size();
    }

    @Override
    public synchronized void clear() {
        Iterator<MessageReference> i = this.list.iterator();
        while (i.hasNext()) {
            MessageReference ref = i.next();
            ref.decrementReferenceCount();
        }
        this.list.clear();
    }

    @Override
    public synchronized void remove(MessageReference node) {
        this.list.remove(node);
        node.decrementReferenceCount();
    }

    @Override
    public LinkedList<MessageReference> pageInList(int maxItems) {
        LinkedList<MessageReference> result = new LinkedList<MessageReference>();
        Iterator<MessageReference> i = this.list.iterator();
        while (i.hasNext()) {
            MessageReference ref = i.next();
            ref.incrementReferenceCount();
            result.add(ref);
            if (result.size() < maxItems) continue;
            break;
        }
        return result;
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public void destroy() throws Exception {
        super.destroy();
        this.clear();
    }
}

