/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.util.Strings;
import java.util.LinkedHashMap;
import java.util.Map;

public class CommandLineParser {
    public static final String NON_VALUE = "";
    private Map<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
    private boolean userAskedHelp = false;

    public void addParameter(String name, boolean mandatory, boolean hasValue, String defaultValue, String description) {
        Parameter p = new Parameter();
        p.name = name;
        p.value = null;
        p.needsValue = hasValue;
        p.mandatory = mandatory;
        p.defaultValue = defaultValue;
        p.description = description;
        this.parameters.put(p.name, p);
    }

    public void parse(String[] args) throws CommandLineException {
        for (int i = 0; i < args.length; ++i) {
            if ("help".equals(args[i]) || "-help".equals(args[i]) || "--help".equals(args[i]) || "-h".equals(args[i])) {
                this.userAskedHelp = true;
                return;
            }
            Parameter parameter = this.parameters.get(args[i]);
            if (parameter == null) {
                throw new CommandLineException("unknown parameter: " + args[i]);
            }
            if (parameter.needsValue) {
                try {
                    parameter.value = args[i + 1];
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new CommandLineException("parameter " + parameter.name + " is missing a value");
                }
            }
            parameter.value = NON_VALUE;
        }
        for (Parameter p : this.parameters.values()) {
            if (!p.mandatory || p.value != null) continue;
            throw new CommandLineException("parameter " + p.name + " is mandatory, but missing");
        }
        Parameter help = new Parameter();
        help.name = "-help";
        help.description = "get help on command line syntax (this text)";
        this.parameters.put(help.name, help);
    }

    public boolean hasValue(String name) throws CommandLineException {
        return this.getValue(name) != null;
    }

    public String getValue(String name) throws CommandLineException {
        Parameter p = this.parameters.get(name);
        if (p == null) {
            throw new CommandLineException("no such parameter: " + name);
        }
        if (p.value == null && p.defaultValue != null) {
            return p.defaultValue;
        }
        return p.value;
    }

    public boolean userAskedHelp() {
        return this.userAskedHelp;
    }

    public String getDescription() {
        String desc = NON_VALUE;
        for (Parameter p : this.parameters.values()) {
            String line = NON_VALUE;
            String header = p.needsValue ? p.name + " <value>" : p.name;
            int padding = 8 - header.length();
            String pad = Strings.repeat(" ", padding > 0 ? padding : 0);
            line = line + header + pad;
            line = line + (p.mandatory ? "mandatory" : NON_VALUE);
            line = line + (p.defaultValue != null ? ", default:" + p.defaultValue : NON_VALUE);
            int tabs = (int)Math.ceil((float)(32 - line.length()) / 8.0f);
            line = line + (p.description != null ? Strings.repeat("\t", tabs) + p.description : NON_VALUE);
            line = line + "\n";
            desc = desc + line;
        }
        return desc;
    }

    private static class Parameter {
        String name;
        String value = null;
        String defaultValue = null;
        String description = null;
        boolean mandatory = false;
        boolean needsValue = false;

        private Parameter() {
        }
    }

    public static class CommandLineException
    extends Exception {
        public CommandLineException(String message) {
            super(message);
        }
    }
}

