/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import org.emboss.jemboss.gui.SequenceData;
import org.emboss.jemboss.gui.SequenceListTableModel;
import org.emboss.jemboss.gui.filetree.FileNode;
import org.emboss.jemboss.gui.filetree.RemoteFileNode;

class DragJTable
extends JTable
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private SequenceListTableModel seqModel;

    public DragJTable(SequenceListTableModel sequenceListTableModel) {
        this.seqModel = sequenceListTableModel;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.setDropTarget(new DropTarget(this, this));
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        int n = this.columnAtPoint(point);
        if (n == this.convertColumnIndexToView(0)) {
            int n2 = this.getSelectedRow();
            dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, this.seqModel.getSequenceData(n2), this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public String getFileName(int n) {
        return (String)this.seqModel.getValueAt(n, 0);
    }

    public Boolean isListFile(int n) {
        return (Boolean)this.seqModel.getValueAt(n, 3);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE) || dropTargetDragEvent.isDataFlavorSupported(FileNode.FILENODE) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor) || dropTargetDragEvent.isDataFlavorSupported(SequenceData.SEQUENCEDATA)) {
            dropTargetDragEvent.acceptDrag(3);
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(FileNode.FILENODE)) {
            try {
                FileNode fileNode = (FileNode)transferable.getTransferData(FileNode.FILENODE);
                this.insertData(this.seqModel, dropTargetDropEvent.getLocation(), fileNode.getFile().getCanonicalPath(), "", "", new Boolean(false), new Boolean(false), new Boolean(false));
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {}
        } else if (transferable.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE)) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.insertData(this.seqModel, dropTargetDropEvent.getLocation(), string, "", "", new Boolean(false), new Boolean(false), new Boolean(true));
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            }
            catch (Exception exception) {
                dropTargetDropEvent.rejectDrop();
            }
        } else if (transferable.isDataFlavorSupported(SequenceData.SEQUENCEDATA)) {
            try {
                SequenceData sequenceData = (SequenceData)transferable.getTransferData(SequenceData.SEQUENCEDATA);
                String string = sequenceData.s_name;
                this.insertData(this.seqModel, dropTargetDropEvent.getLocation(), sequenceData.s_name, sequenceData.s_beg, sequenceData.s_end, sequenceData.s_listFile, sequenceData.s_default, sequenceData.s_remote);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void insertData(SequenceListTableModel sequenceListTableModel, Point point, String string, String string2, String string3, Boolean bl, Boolean bl2, Boolean bl3) {
        int n = this.rowAtPoint(point);
        SequenceListTableModel.modelVector.insertElementAt(new SequenceData(string, string2, string3, bl, bl2, bl3), n);
        this.tableChanged(new TableModelEvent(sequenceListTableModel, n + 1, n + 1, -1, 1));
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        int n = this.rowAtPoint(point);
        this.setRowSelectionInterval(n, n);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }
}

