/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.MemoryComboBox;

public class Browser
extends JFrame
implements HyperlinkListener,
ActionListener {
    private JTextField statusField;
    private MemoryComboBox urlField;
    private JEditorPane htmlPane;
    private String initialURL;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private String[] topics = new String[]{"Home", "About", "User Guide", "File Manager", "Results Manager", "Sequence List", "Alignment Editor"};
    private String[] embossTopics = new String[]{"Home", "Apps"};
    private JSplitPane sp;
    private JMenuItem backMenu;
    private JButton backBt;
    private JMenuItem fwdMenu;
    private JButton fwdBt;

    public Browser(String string, String string2, JembossParams jembossParams) throws IOException {
        this(string, string2, false, "", jembossParams);
    }

    public Browser(String string, String string2, boolean bl, String string3, JembossParams jembossParams) throws IOException {
        super(string2);
        this.initialURL = string;
        if (jembossParams.isBrowserProxy()) {
            System.setProperty("http.proxyHost", jembossParams.getBrowserProxyHost());
            System.setProperty("http.proxyPort", Integer.toString(jembossParams.getBrowserProxyPort()));
            System.setProperty("proxyHost", jembossParams.getBrowserProxyHost());
            System.setProperty("proxyPort", Integer.toString(jembossParams.getBrowserProxyPort()));
        }
        if (bl) {
            this.htmlPane = new JEditorPane();
            if (string3.indexOf("<html>") > -1 || string3.indexOf("<HTML>") > -1) {
                this.htmlPane.setContentType("text/html");
            }
            this.htmlPane.setText(string3);
            this.htmlPane.addHyperlinkListener(this);
            this.setBrowserSize();
            Vector<String> vector = new Vector<String>();
            vector.add(string2 + ".html");
            this.setUpJMenuBar(vector);
            this.addToScrollPane();
            this.setVisible(true);
        } else {
            URL uRL = new URL(string);
            this.setURL(uRL, string);
        }
    }

    public Browser(URL uRL, String string) throws IOException {
        super(string);
        this.initialURL = string;
        this.setURL(uRL, string);
    }

    public void setURL(URL uRL, String string) {
        try {
            this.htmlPane = new JEditorPane(uRL);
            this.htmlPane.addHyperlinkListener(this);
            Vector<URL> vector = new Vector<URL>();
            vector.add(uRL);
            this.setBrowserSize();
            this.setUpJMenuBar(vector);
            this.setTitle(string);
            this.addToScrollPane();
            this.setVisible(true);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Cannot Load URL\n" + string, "Error", 0);
        }
    }

    private void setUpJMenuBar(Vector vector) {
        JMenuBar jMenuBar = new JMenuBar();
        JToolBar jToolBar = new JToolBar();
        JToolBar jToolBar2 = new JToolBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        this.backMenu = new JMenuItem("Back");
        this.backMenu.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.backMenu.setActionCommand("BACK");
        this.backMenu.addActionListener(this);
        jMenu.add(this.backMenu);
        this.backMenu.setEnabled(false);
        this.fwdMenu = new JMenuItem("Forward");
        this.fwdMenu.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.fwdMenu.setActionCommand("FWD");
        this.fwdMenu.addActionListener(this);
        jMenu.add(this.fwdMenu);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Browser.this.setVisible(false);
            }
        });
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("View");
        jMenu2.setMnemonic(86);
        jMenuBar.add(jMenu2);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Display help topics");
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Browser.this.sp.getDividerLocation() > 5) {
                    Browser.this.sp.setDividerLocation(0);
                } else {
                    Browser.this.sp.setDividerLocation(100);
                }
            }
        });
        jMenu2.add(jCheckBoxMenuItem);
        ClassLoader classLoader = this.getClass().getClassLoader();
        ImageIcon imageIcon = new ImageIcon(classLoader.getResource("images/Jemboss_logo_small.gif"));
        JIconButton jIconButton = new JIconButton(imageIcon);
        jIconButton.addActionListener(this);
        jIconButton.setActionCommand("JEMBOSS");
        JLabel jLabel = new JLabel("URL:");
        this.urlField = new MemoryComboBox(vector);
        this.urlField.addActionListener(this);
        int n = (int)this.urlField.getPreferredSize().getHeight();
        this.backBt = new JButton(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(new Color(0, 128, 0));
                float[][] fArrayArray = new float[][]{{4.0f, 12.0f}, {14.0f, 22.0f}, {14.0f, 16.0f}, {18.0f, 16.0f}, {18.0f, 12.0f}};
                graphics2D.fill(Browser.makeShape(fArrayArray));
                graphics2D.setColor(Color.green);
                float[][] fArrayArray2 = new float[][]{{4.0f, 12.0f}, {14.0f, 2.0f}, {14.0f, 8.0f}, {18.0f, 8.0f}, {18.0f, 12.0f}};
                graphics2D.fill(Browser.makeShape(fArrayArray2));
                if (!this.isEnabled()) {
                    graphics2D.setColor(Color.gray);
                    float[][] fArrayArray3 = new float[][]{{5.0f, 12.0f}, {14.0f, 21.0f}, {14.0f, 15.0f}, {18.0f, 15.0f}, {18.0f, 12.0f}};
                    graphics2D.fill(Browser.makeShape(fArrayArray3));
                    graphics2D.setColor(Color.lightGray);
                    float[][] fArrayArray4 = new float[][]{{5.0f, 12.0f}, {14.0f, 3.0f}, {14.0f, 9.0f}, {18.0f, 9.0f}, {18.0f, 12.0f}};
                    graphics2D.fill(Browser.makeShape(fArrayArray4));
                }
                this.setSize(22, 24);
            }
        };
        Dimension dimension = new Dimension(22, 24);
        this.backBt.setPreferredSize(dimension);
        this.backBt.setMaximumSize(dimension);
        this.backBt.setPreferredSize(new Dimension(15, 15));
        this.backBt.setActionCommand("BACK");
        this.backBt.addActionListener(this);
        this.backBt.setEnabled(false);
        this.fwdBt = new JButton(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(new Color(0, 128, 0));
                float[][] fArrayArray = new float[][]{{4.0f, 12.0f}, {4.0f, 16.0f}, {8.0f, 16.0f}, {8.0f, 22.0f}, {18.0f, 12.0f}};
                graphics2D.fill(Browser.makeShape(fArrayArray));
                graphics2D.setColor(Color.green);
                float[][] fArrayArray2 = new float[][]{{4.0f, 12.0f}, {4.0f, 8.0f}, {8.0f, 8.0f}, {8.0f, 2.0f}, {18.0f, 12.0f}};
                graphics2D.fill(Browser.makeShape(fArrayArray2));
                if (!this.isEnabled()) {
                    graphics2D.setColor(Color.gray);
                    float[][] fArrayArray3 = new float[][]{{4.0f, 12.0f}, {4.0f, 15.0f}, {8.0f, 15.0f}, {8.0f, 21.0f}, {17.0f, 12.0f}};
                    graphics2D.fill(Browser.makeShape(fArrayArray3));
                    graphics2D.setColor(Color.lightGray);
                    float[][] fArrayArray4 = new float[][]{{4.0f, 12.0f}, {4.0f, 7.0f}, {8.0f, 7.0f}, {8.0f, 3.0f}, {17.0f, 12.0f}};
                    graphics2D.fill(Browser.makeShape(fArrayArray4));
                }
                this.setSize(22, 24);
            }
        };
        this.fwdBt.setPreferredSize(dimension);
        this.fwdBt.setMaximumSize(dimension);
        this.fwdBt.setActionCommand("FWD");
        this.fwdBt.addActionListener(this);
        this.fwdBt.setEnabled(false);
        jToolBar2.add(this.backBt);
        jToolBar2.add(this.fwdBt);
        jToolBar2.add(jIconButton);
        jToolBar.add(jLabel);
        jToolBar.add(this.urlField);
        this.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jToolBar2, "North");
        jPanel.add((Component)jToolBar, "South");
        this.getContentPane().add((Component)jPanel, "North");
        int n2 = (int)jToolBar.getPreferredSize().getWidth();
        Dimension dimension2 = new Dimension(n2, n);
        this.urlField.setMaximumSize(dimension2);
        int n3 = (int)jToolBar2.getPreferredSize().getWidth();
        int n4 = imageIcon.getIconHeight();
        dimension2 = new Dimension(n3, n4);
        jToolBar2.setPreferredSize(dimension2);
    }

    private void setBrowserSize() {
        Dimension dimension = this.getToolkit().getScreenSize();
        int n = (int)((double)dimension.width * 0.6);
        int n2 = (int)((double)dimension.height * 0.85);
        this.setBounds((int)((double)n * 0.59), (int)((double)n2 * 0.02), n, n2);
    }

    private void addToScrollPane() {
        this.htmlPane.setEditable(false);
        this.htmlPane.setCaretPosition(0);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                BasicStroke basicStroke = new BasicStroke(2.0f);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(basicStroke);
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(4, 5, 9, 10);
                graphics2D.drawLine(9, 5, 4, 10);
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(4, 4, 9, 9);
                graphics2D.drawLine(9, 3, 3, 9);
                this.setSize(15, 15);
            }
        };
        jButton.addActionListener(this);
        jButton.setActionCommand("CLOSE");
        jButton.setPreferredSize(new Dimension(15, 15));
        box.add(jButton);
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.getWebScape());
        jPanel.add((Component)box, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().setBackground(Color.white);
        this.sp = new JSplitPane(1, jPanel, this.htmlPane);
        this.sp.setDividerSize(8);
        this.sp.setDividerLocation(100);
        this.sp.setOneTouchExpandable(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.htmlPane);
        this.sp.add(jScrollPane2);
        this.htmlPane.setPreferredSize(this.getPreferredSize());
        this.getContentPane().add((Component)this.sp, "Center");
        Border border = BorderFactory.createLoweredBevelBorder();
        Border border2 = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        this.statusField = new JTextField();
        this.statusField.setBorder(compoundBorder);
        this.statusField.setEditable(false);
        this.getContentPane().add((Component)this.statusField, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        URL uRL = null;
        this.setCursor(this.cbusy);
        if (actionEvent.getSource() == this.urlField) {
            Object object = this.urlField.getSelectedItem();
            if (object instanceof String) {
                try {
                    uRL = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                uRL = (URL)object;
            }
        } else if (actionEvent.getActionCommand().equals("JEMBOSS")) {
            try {
                uRL = new URL("http://emboss.sourceforge.net/Jemboss/");
            }
            catch (MalformedURLException malformedURLException) {}
        } else if (actionEvent.getActionCommand().equals("BACK")) {
            int n = this.urlField.getIndexOf(this.urlField.getSelectedItem()) - 1;
            if (n > -1 && n < this.urlField.getItemCount()) {
                uRL = this.urlField.getURLAt(n);
            }
        } else if (actionEvent.getActionCommand().equals("FWD")) {
            int n = this.urlField.getIndexOf(this.urlField.getSelectedItem()) + 1;
            if (n > -1 && n < this.urlField.getItemCount()) {
                uRL = this.urlField.getURLAt(n);
            }
        } else if (actionEvent.getActionCommand().equals("CLOSE")) {
            this.setCursor(this.cdone);
            this.sp.setDividerLocation(0);
            return;
        }
        try {
            this.htmlPane.setPage(uRL);
            if (!this.urlField.isItem(uRL)) {
                this.urlField.addURL(uRL);
            } else {
                this.urlField.setSelectedItem(uRL);
            }
            this.backMenu.setEnabled(this.urlField.isBackPage());
            this.backBt.setEnabled(this.urlField.isBackPage());
            this.fwdMenu.setEnabled(this.urlField.isForwardPage());
            this.fwdBt.setEnabled(this.urlField.isForwardPage());
        }
        catch (IOException iOException) {
            this.setCursor(this.cdone);
            this.warnUser("Can't follow link to " + uRL);
        }
        this.setCursor(this.cdone);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setCursor(this.cbusy);
            try {
                URL uRL = hyperlinkEvent.getURL();
                this.htmlPane.setPage(uRL);
                if (!this.urlField.isItem(uRL)) {
                    this.urlField.addURL(uRL);
                } else {
                    this.urlField.setSelectedItem(uRL);
                    this.urlField.setLastIndex(uRL);
                }
            }
            catch (IOException iOException) {
                this.setCursor(this.cdone);
                this.warnUser("Can't follow link to " + hyperlinkEvent.getDescription());
            }
            this.setCursor(this.cdone);
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.statusField.setText(hyperlinkEvent.getDescription());
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.statusField.setText("");
        }
    }

    private void warnUser(String string) {
        JOptionPane.showMessageDialog(this, string, "Warning", 0);
    }

    public static GeneralPath makeShape(float[][] fArray) {
        GeneralPath generalPath = new GeneralPath(1);
        generalPath.moveTo(fArray[0][0], fArray[0][1]);
        for (int i = 1; i < fArray.length; ++i) {
            generalPath.lineTo(fArray[i][0], fArray[i][1]);
        }
        return generalPath;
    }

    public JTree getWebScape() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Jemboss WebScape");
        this.createNodes(defaultMutableTreeNode);
        final JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.setShowsRootHandles(true);
        jTree.expandRow(1);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                Object object = defaultMutableTreeNode.getUserObject();
                if (defaultMutableTreeNode.isLeaf()) {
                    String string = null;
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    String string2 = (String)defaultMutableTreeNode2.getUserObject();
                    String string3 = (String)object;
                    URL uRL = null;
                    if (string3.equals("File Manager")) {
                        uRL = classLoader.getResource("resources/filemgr.html");
                    } else if (string3.equals("About")) {
                        uRL = classLoader.getResource("resources/readme.html");
                    } else if (string3.equals("Alignment Editor")) {
                        uRL = classLoader.getResource("resources/readmeAlign.html");
                    } else if (string3.equals("Sequence List")) {
                        uRL = classLoader.getResource("resources/seqList.html");
                    } else if (string3.equals("Results Manager")) {
                        uRL = classLoader.getResource("resources/results.html");
                    } else if (string3.equals("User Guide")) {
                        string = "http://emboss.sourceforge.net/Jemboss/guide.html";
                    } else if (string3.equals("Home") && string2.equals("Jemboss")) {
                        string = "http://emboss.sourceforge.net/Jemboss/";
                    } else if (string3.equals("Home") && string2.equals("EMBOSS")) {
                        string = "http://emboss.sourceforge.net/";
                    } else if (string3.equals("Apps") && string2.equals("EMBOSS")) {
                        string = "http://emboss.sourceforge.net/apps";
                    }
                    if (string != null) {
                        try {
                            uRL = new URL(string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            Browser.this.warnUser("Can't follow link to " + string);
                        }
                    }
                    if (uRL != null) {
                        try {
                            Browser.this.htmlPane.setPage(uRL);
                            if (!Browser.this.urlField.isItem(uRL)) {
                                Browser.this.urlField.addURL(uRL);
                            } else {
                                Browser.this.urlField.setSelectedItem(uRL);
                                Browser.this.urlField.setLastIndex(uRL);
                            }
                        }
                        catch (IOException iOException) {
                            Browser.this.setCursor(Browser.this.cdone);
                            Browser.this.warnUser("Can't follow link to " + uRL);
                        }
                        Browser.this.backMenu.setEnabled(Browser.this.urlField.isBackPage());
                        Browser.this.backBt.setEnabled(Browser.this.urlField.isBackPage());
                        Browser.this.fwdMenu.setEnabled(Browser.this.urlField.isForwardPage());
                        Browser.this.fwdBt.setEnabled(Browser.this.urlField.isForwardPage());
                    }
                }
            }
        });
        jTree.setRootVisible(false);
        return jTree;
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Jemboss");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (n = 0; n < this.topics.length; ++n) {
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(this.topics[n]);
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        }
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("EMBOSS");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (n = 0; n < this.embossTopics.length; ++n) {
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(this.embossTopics[n]);
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        }
    }

    public static void main(String[] stringArray) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            URL uRL = classLoader.getResource("resources/seqList.html");
            new Browser(uRL, "resources/seqList.html");
        }
        catch (Exception exception) {
            System.out.println("Didn't find resources/seqList.html");
        }
    }

    public class JIconButton
    extends JButton {
        public JIconButton(ImageIcon imageIcon) {
            super(imageIcon);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }
    }
}

