/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.graphics;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.emboss.jemboss.editor.SequenceProperties;
import org.emboss.jemboss.graphics.PrintPlot;
import org.emboss.jemboss.gui.ScrollPanel;
import org.emboss.jemboss.gui.filetree.FileEditorDisplay;
import org.emboss.jemboss.gui.form.TextFieldFloat;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class Graph2DPlot
extends ScrollPanel {
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private Object[][] emboss_data;
    private float xmin = 0.0f;
    private float xmax = 0.0f;
    private float ymin = 0.0f;
    private float ymax = 0.0f;
    private float xmin_screen = 0.0f;
    private float xmax_screen = 0.0f;
    private float ymin_screen = 0.0f;
    private float ymax_screen = 0.0f;
    private StringBuffer graph_data;
    private Color graph_colour = Color.black;
    private TextFieldFloat graph_line;
    private TextFieldFloat xstart;
    private TextFieldFloat xend;
    private TextFieldFloat ystart;
    private TextFieldFloat yend;
    private int xborder = 100;
    private int yborder = 100;
    private int WID = 700;
    private int HGT = 700;
    private int width = this.WID;
    private int height = this.HGT;
    private JComboBox x_formatList = null;
    private JComboBox y_formatList = null;
    private TextFieldInt xticks = null;
    private TextFieldInt yticks = null;
    private JTextField maintitle_field = null;
    private JTextField xtitle_field = null;
    private JTextField ytitle_field = null;
    private static int LINE = 1;
    private static int TEXT = 2;
    private static int RECTANGLE = 3;
    private static int FILLED_RECTANGLE = 4;
    private static int TEXTLINE = 5;
    private static int AXIS = 6;
    private boolean draw_axes = true;
    private boolean rectangle = false;
    private boolean screen_min_max = false;
    private Image offscreen = null;
    private String maintitle = "";
    private String xtitle = "";
    private String ytitle = "";
    private String fileName = null;
    private Color[] plplot_colour = new Color[]{Color.black, Color.red, Color.yellow, Color.green, SequenceProperties.AQUAMARINE, Color.pink, SequenceProperties.WHEAT, Color.gray, SequenceProperties.BROWN, Color.blue, SequenceProperties.BLUEVIOLET, Color.cyan, SequenceProperties.TURQUOISE, SequenceProperties.MAGENTA, SequenceProperties.SALMON, Color.white};

    public Graph2DPlot() {
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.setToolTipText("");
    }

    public void setData(Object[][] objectArray) {
        this.emboss_data = objectArray;
        this.calcMinMax();
    }

    public void setFileData(String string, String string2) {
        this.fileName = string2;
        try {
            StringReader stringReader = new StringReader(string);
            this.emboss_data = this.readGraph(stringReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string2.indexOf("plotorf") > -1) {
            this.WID = 1000;
            this.HGT = 400;
            this.width = this.WID;
            this.height = this.HGT;
        }
        this.calcMinMax();
    }

    public void setFileData(File file) {
        this.fileName = file.getName();
        try {
            FileReader fileReader = new FileReader(file);
            this.emboss_data = this.readGraph(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.fileName.indexOf("plotorf") > -1) {
            this.WID = 1000;
            this.HGT = 400;
            this.width = this.WID;
            this.height = this.HGT;
        }
        this.calcMinMax();
    }

    public JMenuBar getMenuBar(boolean bl, final JFrame jFrame) {
        JMenuItem jMenuItem;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem2 = new JMenuItem("Display data...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = new JFrame("EMBOSS data file");
                FileEditorDisplay fileEditorDisplay = new FileEditorDisplay("graph_data.dat", (Object)Graph2DPlot.this.graph_data.toString());
                JScrollPane jScrollPane = new JScrollPane(fileEditorDisplay);
                fileEditorDisplay.setCaretPosition(0);
                jFrame.getContentPane().add(jScrollPane);
                jFrame.pack();
                jFrame.setSize(640, 580);
                jFrame.setVisible(true);
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Print...");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintPlot printPlot = new PrintPlot(Graph2DPlot.this);
                printPlot.print();
            }
        });
        jMenu.add(jMenuItem3);
        jMenu.add(new JSeparator());
        if (bl) {
            jMenuItem = new JMenuItem("Exit");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
            jMenu.add(jMenuItem);
        } else {
            jMenuItem = new JMenuItem("Close");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            });
            jMenu.add(jMenuItem);
        }
        jMenuBar.add(jMenu);
        jMenuItem = new JMenu("Options");
        JMenuItem jMenuItem4 = new JMenuItem("Axes, Labels...");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[]{"default", "##0.0", "##0.00", "#0.##E0", "##0.##E0", "###0.##E0"};
                Box box = Box.createVerticalBox();
                Box box2 = Box.createVerticalBox();
                Dimension dimension = new Dimension(130, 20);
                Box box3 = Box.createHorizontalBox();
                Graph2DPlot.this.x_formatList = new JComboBox<String>(stringArray);
                Graph2DPlot.this.x_formatList.setPreferredSize(dimension);
                Graph2DPlot.this.x_formatList.setEditable(true);
                box3.add(Graph2DPlot.this.x_formatList);
                box3.add(new JLabel(" X-axis Number Format  "));
                box.add(box3);
                box.add(Box.createVerticalStrut(5));
                box3 = Box.createHorizontalBox();
                Graph2DPlot.this.y_formatList = new JComboBox<String>(stringArray);
                Graph2DPlot.this.y_formatList.setPreferredSize(dimension);
                Graph2DPlot.this.y_formatList.setEditable(true);
                box3.add(Graph2DPlot.this.y_formatList);
                box3.add(new JLabel(" Y-axis Number Format"));
                box2.add(box3);
                box2.add(Box.createVerticalStrut(5));
                box3 = Box.createHorizontalBox();
                if (Graph2DPlot.this.xticks == null) {
                    Graph2DPlot.this.xticks = new TextFieldInt();
                    Graph2DPlot.this.xticks.setValue(10);
                }
                Graph2DPlot.this.xticks.setPreferredSize(dimension);
                Graph2DPlot.this.xticks.setMaximumSize(dimension);
                box3.add(Graph2DPlot.this.xticks);
                box3.add(new JLabel(" Number of X ticks  "));
                box3.add(Box.createHorizontalGlue());
                box.add(box3);
                box.add(Box.createVerticalStrut(5));
                box3 = Box.createHorizontalBox();
                if (Graph2DPlot.this.yticks == null) {
                    Graph2DPlot.this.yticks = new TextFieldInt();
                    Graph2DPlot.this.yticks.setValue(10);
                }
                Graph2DPlot.this.yticks.setPreferredSize(dimension);
                Graph2DPlot.this.yticks.setMaximumSize(dimension);
                box3.add(Graph2DPlot.this.yticks);
                box3.add(new JLabel(" Number of Y ticks"));
                box3.add(Box.createHorizontalGlue());
                box2.add(box3);
                box2.add(Box.createVerticalStrut(5));
                box3 = Box.createHorizontalBox();
                if (Graph2DPlot.this.xstart == null) {
                    Graph2DPlot.this.xstart = new TextFieldFloat();
                    Graph2DPlot.this.xstart.setValue(Graph2DPlot.this.xmin);
                }
                Graph2DPlot.this.xstart.setPreferredSize(dimension);
                Graph2DPlot.this.xstart.setMaximumSize(dimension);
                box3.add(Graph2DPlot.this.xstart);
                box3.add(new JLabel(" Start X Tick  "));
                box3.add(Box.createHorizontalGlue());
                box.add(box3);
                box.add(Box.createVerticalStrut(5));
                box3 = Box.createHorizontalBox();
                if (Graph2DPlot.this.ystart == null) {
                    Graph2DPlot.this.ystart = new TextFieldFloat();
                    Graph2DPlot.this.ystart.setValue(Graph2DPlot.this.ymin);
                }
                Graph2DPlot.this.ystart.setPreferredSize(dimension);
                Graph2DPlot.this.ystart.setMaximumSize(dimension);
                box3.add(Graph2DPlot.this.ystart);
                box3.add(new JLabel(" Start Y Tick"));
                box3.add(Box.createHorizontalGlue());
                box2.add(box3);
                box2.add(Box.createVerticalStrut(5));
                box3 = Box.createHorizontalBox();
                if (Graph2DPlot.this.xend == null) {
                    Graph2DPlot.this.xend = new TextFieldFloat();
                    Graph2DPlot.this.xend.setValue(Graph2DPlot.this.xmax);
                }
                Graph2DPlot.this.xend.setPreferredSize(dimension);
                Graph2DPlot.this.xend.setMaximumSize(dimension);
                box3.add(Graph2DPlot.this.xend);
                box3.add(new JLabel(" End X Tick  "));
                box3.add(Box.createHorizontalGlue());
                box.add(box3);
                box.add(Box.createVerticalStrut(5));
                box.add(new JSeparator());
                box.add(Box.createVerticalStrut(5));
                box3 = Box.createHorizontalBox();
                if (Graph2DPlot.this.yend == null) {
                    Graph2DPlot.this.yend = new TextFieldFloat();
                    Graph2DPlot.this.yend.setValue(Graph2DPlot.this.ymax);
                }
                Graph2DPlot.this.yend.setPreferredSize(dimension);
                Graph2DPlot.this.yend.setMaximumSize(dimension);
                box3.add(Graph2DPlot.this.yend);
                box3.add(new JLabel(" End Y Tick"));
                box3.add(Box.createHorizontalGlue());
                box2.add(box3);
                box2.add(Box.createVerticalStrut(5));
                box2.add(new JSeparator());
                box2.add(Box.createVerticalStrut(5));
                box3 = Box.createHorizontalBox();
                if (Graph2DPlot.this.xtitle_field == null) {
                    Graph2DPlot.this.xtitle_field = new JTextField(Graph2DPlot.this.xtitle);
                }
                Graph2DPlot.this.xtitle_field.setPreferredSize(dimension);
                Graph2DPlot.this.xtitle_field.setMaximumSize(dimension);
                box3.add(Graph2DPlot.this.xtitle_field);
                box3.add(new JLabel(" X Axis Label  "));
                box3.add(Box.createHorizontalGlue());
                box.add(box3);
                box.add(Box.createVerticalStrut(5));
                box.add(new JSeparator());
                box.add(Box.createVerticalStrut(5));
                box3 = Box.createHorizontalBox();
                if (Graph2DPlot.this.ytitle_field == null) {
                    Graph2DPlot.this.ytitle_field = new JTextField(Graph2DPlot.this.ytitle);
                }
                Graph2DPlot.this.ytitle_field.setPreferredSize(dimension);
                Graph2DPlot.this.ytitle_field.setMaximumSize(dimension);
                box3.add(Graph2DPlot.this.ytitle_field);
                box3.add(new JLabel(" Y Axis Label"));
                box3.add(Box.createHorizontalGlue());
                box2.add(box3);
                box2.add(Box.createVerticalStrut(5));
                box2.add(new JSeparator());
                box2.add(Box.createVerticalStrut(5));
                box3 = Box.createHorizontalBox();
                TextFieldInt textFieldInt = new TextFieldInt();
                textFieldInt.setValue(Graph2DPlot.this.WID);
                textFieldInt.setPreferredSize(dimension);
                textFieldInt.setMaximumSize(dimension);
                box3.add(textFieldInt);
                box3.add(new JLabel(" Graph Width "));
                box3.add(Box.createHorizontalGlue());
                box.add(box3);
                box.add(Box.createVerticalStrut(5));
                box3 = Box.createHorizontalBox();
                TextFieldInt textFieldInt2 = new TextFieldInt();
                textFieldInt2.setValue(Graph2DPlot.this.HGT);
                textFieldInt2.setPreferredSize(dimension);
                textFieldInt2.setMaximumSize(dimension);
                box3.add(textFieldInt2);
                box3.add(new JLabel(" Graph Height "));
                box3.add(Box.createHorizontalGlue());
                box2.add(box3);
                box2.add(Box.createVerticalStrut(5));
                Box box4 = Box.createVerticalBox();
                box3 = Box.createHorizontalBox();
                final JButton jButton = new JButton();
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Color color = JColorChooser.showDialog(null, "Graph Colour", Graph2DPlot.this.graph_colour);
                        if (color != null) {
                            Graph2DPlot.this.graph_colour = color;
                            jButton.setBackground(Graph2DPlot.this.graph_colour);
                        }
                    }
                });
                Dimension dimension2 = new Dimension(22, 24);
                jButton.setBackground(Graph2DPlot.this.graph_colour);
                jButton.setPreferredSize(dimension2);
                jButton.setMaximumSize(dimension2);
                box3.add(jButton);
                box3.add(new JLabel(" Graph Colour "));
                box3.add(Box.createHorizontalGlue());
                box4.add(box3);
                box4.add(Box.createVerticalStrut(5));
                box3 = Box.createHorizontalBox();
                if (Graph2DPlot.this.graph_line == null) {
                    Graph2DPlot.this.graph_line = new TextFieldFloat();
                    Graph2DPlot.this.graph_line.setValue(1.0);
                }
                Graph2DPlot.this.graph_line.setPreferredSize(dimension);
                Graph2DPlot.this.graph_line.setMaximumSize(dimension);
                box3.add(Graph2DPlot.this.graph_line);
                box3.add(new JLabel(" Graph Line Width "));
                box3.add(Box.createHorizontalGlue());
                box4.add(box3);
                Box box5 = Box.createVerticalBox();
                box3 = Box.createHorizontalBox();
                if (Graph2DPlot.this.maintitle_field == null) {
                    Graph2DPlot.this.maintitle_field = new JTextField(Graph2DPlot.this.maintitle);
                }
                dimension = new Dimension(260, 20);
                Graph2DPlot.this.maintitle_field.setPreferredSize(dimension);
                Graph2DPlot.this.maintitle_field.setMaximumSize(dimension);
                box3.add(Graph2DPlot.this.maintitle_field);
                box3.add(new JLabel(" Main Title"));
                box3.add(Box.createHorizontalGlue());
                box5.add(box3);
                box5.add(Box.createVerticalStrut(5));
                box5.add(new JSeparator());
                box5.add(Box.createVerticalStrut(5));
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)box5, "North");
                jPanel.add((Component)box, "Center");
                jPanel.add((Component)box2, "East");
                jPanel.add((Component)box4, "South");
                Object[] objectArray = new Object[]{"OK", "APPLY", "CANCEL"};
                int n = 1;
                while (n == 1) {
                    n = JOptionPane.showOptionDialog(null, jPanel, "Graph Options", 1, 3, null, objectArray, objectArray[0]);
                    if (n >= 2) continue;
                    if (Graph2DPlot.this.WID != textFieldInt.getValue() || Graph2DPlot.this.HGT != textFieldInt2.getValue()) {
                        Graph2DPlot.this.WID = textFieldInt.getValue();
                        Graph2DPlot.this.HGT = textFieldInt2.getValue();
                        Graph2DPlot.this.width = Graph2DPlot.this.WID;
                        Graph2DPlot.this.height = Graph2DPlot.this.HGT;
                        Graph2DPlot.this.setPreferredSize(new Dimension(Graph2DPlot.this.WID, Graph2DPlot.this.HGT));
                        Graph2DPlot.this.setSize(new Dimension(Graph2DPlot.this.WID, Graph2DPlot.this.HGT));
                        Graph2DPlot.this.removeAll();
                        Graph2DPlot.this.revalidate();
                    }
                    Graph2DPlot.this.offscreen = null;
                    Graph2DPlot.this.repaint();
                }
            }
        });
        ((JMenu)jMenuItem).add(jMenuItem4);
        jMenuBar.add((JMenu)jMenuItem);
        String[] stringArray = new String[]{"10", "12", "14", "16", "18"};
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem(Integer.toString(this.getFont().getSize()));
        jMenuBar.add(jComboBox);
        jComboBox.setEditable(true);
        Dimension dimension = new Dimension(50, 20);
        jComboBox.setPreferredSize(dimension);
        jComboBox.setMaximumSize(dimension);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Graph2DPlot.this.setCursor(Graph2DPlot.this.cbusy);
                String string = (String)jComboBox.getSelectedItem();
                Font font = Graph2DPlot.this.getFont();
                font = font.deriveFont(Float.parseFloat(string));
                Graph2DPlot.this.setFont(font);
                Graph2DPlot.this.offscreen = null;
                Graph2DPlot.this.repaint();
                Graph2DPlot.this.setCursor(Graph2DPlot.this.cdone);
            }
        });
        String[] stringArray2 = new String[]{"70", "80", "90", "100", "150", "200"};
        final JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray2);
        jComboBox2.setSelectedItem("100");
        jMenuBar.add(jComboBox2);
        jComboBox2.setEditable(true);
        jComboBox2.setPreferredSize(dimension);
        jComboBox2.setMaximumSize(dimension);
        jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Graph2DPlot.this.setCursor(Graph2DPlot.this.cbusy);
                float f = Float.parseFloat((String)jComboBox2.getSelectedItem()) / 100.0f;
                Graph2DPlot.this.width = (int)((float)Graph2DPlot.this.WID * f);
                Graph2DPlot.this.height = (int)((float)Graph2DPlot.this.HGT * f);
                Graph2DPlot.this.setPreferredSize(new Dimension(Graph2DPlot.this.width, Graph2DPlot.this.height));
                Graph2DPlot.this.setSize(new Dimension(Graph2DPlot.this.width, Graph2DPlot.this.height));
                Graph2DPlot.this.removeAll();
                Graph2DPlot.this.revalidate();
                Graph2DPlot.this.offscreen = null;
                Graph2DPlot.this.repaint();
                Graph2DPlot.this.setCursor(Graph2DPlot.this.cdone);
            }
        });
        jMenuBar.add(new JLabel("%"));
        return jMenuBar;
    }

    private void calcMinMax() {
        int n;
        int n2 = this.emboss_data[0].length;
        if (this.xmin == 0.0f && this.xmax == 0.0f && this.ymin == 0.0f && this.ymax == 0.0f) {
            this.xmin = 1000000.0f;
            this.xmax = -1000000.0f;
            this.ymin = this.xmin;
            this.ymax = this.xmax;
        }
        int n3 = this.emboss_data.length;
        for (n = 0; n < n2; ++n) {
            float f;
            float f2;
            if (n3 == 2) {
                f2 = ((Float)this.emboss_data[0][n]).floatValue();
                f = ((Float)this.emboss_data[1][n]).floatValue();
            } else {
                if ((Integer)this.emboss_data[0][n] == TEXT || (Integer)this.emboss_data[0][n] == TEXTLINE || this.isTick(((Float)this.emboss_data[1][n]).floatValue(), ((Float)this.emboss_data[2][n]).floatValue(), ((Float)this.emboss_data[3][n]).floatValue(), ((Float)this.emboss_data[4][n]).floatValue(), ((Float)this.emboss_data[5][n]).floatValue(), false)) continue;
                f2 = ((Float)this.emboss_data[1][n]).floatValue();
                f = ((Float)this.emboss_data[2][n]).floatValue();
                if (this.xmin > f2) {
                    this.xmin = f2;
                }
                if (this.xmax < f2) {
                    this.xmax = f2;
                }
                if (this.ymin > f) {
                    this.ymin = f;
                }
                if (this.ymax < f) {
                    this.ymax = f;
                }
                f2 = ((Float)this.emboss_data[3][n]).floatValue();
                f = ((Float)this.emboss_data[4][n]).floatValue();
            }
            if (this.xmin > f2) {
                this.xmin = f2;
            }
            if (this.xmax < f2) {
                this.xmax = f2;
            }
            if (this.ymin > f) {
                this.ymin = f;
            }
            if (!(this.ymax < f)) continue;
            this.ymax = f;
        }
        if (this.screen_min_max) {
            if (this.xmin > this.xmax) {
                this.xmin = this.xmin_screen;
                this.xmax = this.xmax_screen;
            }
            if (this.ymin > this.ymax) {
                this.ymin = this.ymin_screen;
                this.ymax = this.ymax_screen;
            }
            if (n3 > 2) {
                this.draw_axes = false;
                for (n = 0; n < n2; ++n) {
                    if ((Integer)this.emboss_data[0][n] != LINE && (Integer)this.emboss_data[0][n] != RECTANGLE) continue;
                    float f = ((Float)this.emboss_data[1][n]).floatValue();
                    float f3 = ((Float)this.emboss_data[2][n]).floatValue();
                    float f4 = ((Float)this.emboss_data[3][n]).floatValue();
                    float f5 = ((Float)this.emboss_data[4][n]).floatValue();
                    if ((double)Math.abs(f4 - f) > (double)(this.xmax - this.xmin) * 0.8 && ((double)Math.abs(f5 - f3) < 0.1 || (Integer)this.emboss_data[0][n] == RECTANGLE)) {
                        if (f4 > f) {
                            this.xmax = f4;
                            this.xmin = f;
                        } else {
                            this.xmax = f;
                            this.xmin = f4;
                        }
                        this.draw_axes = true;
                        if ((Integer)this.emboss_data[0][n] == RECTANGLE) {
                            this.rectangle = true;
                        }
                        this.emboss_data[0][n] = new Integer(AXIS);
                        continue;
                    }
                    if (!((double)Math.abs(f5 - f3) > (double)(this.ymax - this.ymin) * 0.8) || !((double)Math.abs(f4 - f) < 0.1)) continue;
                    if (f5 > f3) {
                        this.ymax = f5;
                        this.ymin = f3;
                    } else {
                        this.ymax = f3;
                        this.ymin = f5;
                    }
                    this.draw_axes = true;
                    if ((Integer)this.emboss_data[0][n] == RECTANGLE) {
                        this.rectangle = true;
                    }
                    this.emboss_data[0][n] = new Integer(AXIS);
                }
            }
            if (!this.draw_axes && this.ymin > this.ymin_screen) {
                this.ymin = this.ymin_screen;
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight();
        int n2 = 10;
        int n3 = this.getYLabelWidth(fontMetrics);
        this.xborder = n3 + n + n2 + 5;
        this.yborder = n + n + n2 + 5;
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.getWidth(), this.getHeight());
            Graphics graphics2 = this.offscreen.getGraphics();
            graphics2.setFont(this.getFont());
            graphics2.setColor(Color.white);
            graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.emboss_data.length == 2) {
                this.drawPoints(graphics2);
            } else {
                this.drawGraphics(graphics2, fontMetrics);
            }
            graphics2.setColor(Color.black);
            if (this.draw_axes) {
                this.drawAxes(graphics2, n2);
            }
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public void printComponent(Graphics graphics) {
        super.paintComponent(graphics);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight();
        int n2 = 10;
        int n3 = this.getYLabelWidth(fontMetrics);
        this.xborder = n3 + n + n2 + 5;
        this.yborder = n + n + n2 + 5;
        graphics.setFont(this.getFont());
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.emboss_data.length == 2) {
            this.drawPoints(graphics);
        } else {
            this.drawGraphics(graphics, fontMetrics);
        }
        graphics.setColor(Color.black);
        if (this.draw_axes) {
            this.drawAxes(graphics, n2);
        }
    }

    private void drawAxes(Graphics graphics, int n) {
        int n2;
        float f;
        int n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n4 = fontMetrics.getHeight();
        int n5 = n4 / 2;
        if (this.maintitle_field != null) {
            this.maintitle = this.maintitle_field.getText();
        }
        int n6 = fontMetrics.stringWidth(this.maintitle);
        graphics2D.drawString(this.maintitle, (this.getWidth() - n6) / 2, n4);
        graphics2D.drawLine(this.xborder, this.getHeight() - this.yborder, this.getWidth() - this.xborder, this.getHeight() - this.yborder);
        if (this.xtitle_field != null) {
            this.xtitle = this.xtitle_field.getText();
        }
        int n7 = fontMetrics.stringWidth(this.xtitle);
        graphics2D.drawString(this.xtitle, (this.getWidth() - n7) / 2, this.getHeight() - 3);
        graphics2D.drawLine(this.xborder, this.yborder, this.xborder, this.getHeight() - this.yborder);
        if (this.rectangle) {
            graphics2D.drawLine(this.xborder, this.yborder, this.getWidth() - this.xborder, this.yborder);
            graphics2D.drawLine(this.getWidth() - this.xborder, this.yborder, this.getWidth() - this.xborder, this.getHeight() - this.yborder);
        }
        int n8 = 10;
        if (this.xticks != null) {
            n8 = this.xticks.getValue();
        }
        graphics2D.translate(this.xborder, this.getHeight() - this.yborder);
        if (this.xstart == null) {
            this.xstart = new TextFieldFloat();
            this.xstart.setValue(this.xmin);
        }
        if (this.xend == null) {
            this.xend = new TextFieldFloat();
            this.xend.setValue(this.xmax);
        }
        float f2 = (float)(this.getWidth() - 2 * this.xborder) / (float)(this.xend.getValue() - this.xstart.getValue());
        float f3 = (float)((this.xend.getValue() - this.xstart.getValue()) / (double)n8);
        float f4 = f3 / 2.0f;
        DecimalFormat decimalFormat = null;
        decimalFormat = this.x_formatList == null || ((String)this.x_formatList.getSelectedItem()).equals("default") ? this.getFormat(this.xmax) : new DecimalFormat((String)this.x_formatList.getSelectedItem());
        for (n3 = 0; n3 <= n8; ++n3) {
            f = (float)((double)((float)n3 * f3) + this.xstart.getValue());
            int n9 = (int)((float)n3 * f3 * f2);
            graphics2D.drawLine(n9, 0, n9, n);
            if (n3 > 0) {
                int n10 = (int)((float)n9 - f4 * f2);
                graphics2D.drawLine(n10, 0, n10, n / 2);
            }
            graphics2D.drawString(decimalFormat.format(f), n9 - n5, n4 + n);
        }
        n3 = 10;
        if (this.yticks != null) {
            n3 = this.yticks.getValue();
        }
        if (this.ystart == null) {
            this.ystart = new TextFieldFloat();
            this.ystart.setValue(this.ymin);
        }
        if (this.yend == null) {
            this.yend = new TextFieldFloat();
            this.yend.setValue(this.ymax);
        }
        f = (float)((double)(this.getHeight() - 2 * this.yborder) / (this.yend.getValue() - this.ystart.getValue()));
        float f5 = (float)(this.yend.getValue() - this.ystart.getValue()) / (float)n3;
        float f6 = f5 / 2.0f;
        String string = null;
        decimalFormat = this.y_formatList == null || ((String)this.y_formatList.getSelectedItem()).equals("default") ? this.getFormat(this.ymax) : new DecimalFormat((String)this.y_formatList.getSelectedItem());
        int n11 = 0;
        float f7 = (float)this.ystart.getValue();
        for (n2 = 0; n2 <= n3; ++n2) {
            int n12;
            float f8 = (float)n2 * f5;
            int n13 = -((int)(f8 * f));
            graphics2D.drawLine(0, n13, -n, n13);
            if (n2 > 0) {
                n12 = (int)((float)n13 + f6 * f);
                graphics2D.drawLine(0, n12, -n / 2, n12);
            }
            string = decimalFormat.format(f7 + (float)n2 * f5);
            n12 = fontMetrics.stringWidth(string);
            graphics2D.drawString(string, -n12 - n, n13);
            if (n12 <= n11) continue;
            n11 = n12;
        }
        graphics2D.translate(-this.xborder, -this.getHeight() + this.yborder);
        if (this.ytitle_field != null) {
            this.ytitle = this.ytitle_field.getText();
        }
        n2 = fontMetrics.stringWidth(this.ytitle);
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
        affineTransform2.rotate(Math.toRadians(-90.0), 0.0, 0.0);
        graphics2D.setTransform(affineTransform2);
        graphics2D.drawString(this.ytitle, (-this.getHeight() + n2) / 2, this.xborder - n11 - n - 3);
        graphics2D.setTransform(affineTransform);
    }

    private int getYLabelWidth(FontMetrics fontMetrics) {
        DecimalFormat decimalFormat = null;
        decimalFormat = this.y_formatList == null || ((String)this.y_formatList.getSelectedItem()).equals("default") ? this.getFormat(this.ymax) : new DecimalFormat((String)this.y_formatList.getSelectedItem());
        int n = fontMetrics.stringWidth(decimalFormat.format(this.ymax));
        if (n < fontMetrics.stringWidth(decimalFormat.format(this.ymin))) {
            n = fontMetrics.stringWidth(decimalFormat.format(this.ymax));
        }
        if (n < fontMetrics.stringWidth(decimalFormat.format(this.xmax))) {
            n = fontMetrics.stringWidth(decimalFormat.format(this.xmax));
        }
        if (n < fontMetrics.stringWidth(decimalFormat.format(this.xmin))) {
            n = fontMetrics.stringWidth(decimalFormat.format(this.xmin));
        }
        return n;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        float f = (float)(point.x - this.xborder) * (this.xmax - this.xmin) / (float)(this.getWidth() - 2 * this.xborder) + (float)this.xstart.getValue();
        float f2 = (float)(this.getHeight() - this.yborder - point.y) * (this.ymax - this.ymin) / (float)(this.getHeight() - 2 * this.yborder) + (float)this.ystart.getValue();
        DecimalFormat decimalFormat = null;
        DecimalFormat decimalFormat2 = null;
        decimalFormat = this.x_formatList == null || ((String)this.x_formatList.getSelectedItem()).equals("default") ? this.getFormat(this.xmax) : new DecimalFormat((String)this.x_formatList.getSelectedItem());
        decimalFormat2 = this.y_formatList == null || ((String)this.y_formatList.getSelectedItem()).equals("default") ? this.getFormat(this.ymax) : new DecimalFormat((String)this.y_formatList.getSelectedItem());
        return decimalFormat.format(f) + "," + decimalFormat2.format(f2);
    }

    private DecimalFormat getFormat(float f) {
        DecimalFormat decimalFormat = null;
        if (f < 10.0f) {
            decimalFormat = new DecimalFormat("##0.00");
        } else if (f < 10000.0f) {
            decimalFormat = new DecimalFormat("##0.0");
        } else if (f < 100000.0f) {
            decimalFormat = new DecimalFormat("##0.#E0");
        } else if (f < 1000000.0f) {
            decimalFormat = new DecimalFormat("#0.##E0");
        }
        return decimalFormat;
    }

    private void drawGraphics(Graphics graphics, FontMetrics fontMetrics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        BasicStroke basicStroke = (BasicStroke)graphics2D.getStroke();
        if (this.graph_line == null) {
            this.graph_line = new TextFieldFloat();
            this.graph_line.setValue(1.0);
        }
        graphics2D.setStroke(new BasicStroke((float)this.graph_line.getValue()));
        int n = this.emboss_data[0].length;
        if (this.xstart == null) {
            this.xstart = new TextFieldFloat();
            this.xstart.setValue(this.xmin);
        }
        if (this.xend == null) {
            this.xend = new TextFieldFloat();
            this.xend.setValue(this.xmax);
        }
        if (this.ystart == null) {
            this.ystart = new TextFieldFloat();
            this.ystart.setValue(this.ymin);
        }
        if (this.yend == null) {
            this.yend = new TextFieldFloat();
            this.yend.setValue(this.ymax);
        }
        float f = (float)(this.getWidth() - 2 * this.xborder) / (float)(this.xend.getValue() - this.xstart.getValue());
        float f2 = (float)(this.getHeight() - 2 * this.yborder) / (float)(this.yend.getValue() - this.ystart.getValue());
        float f3 = (float)(this.xend.getValue() - this.xstart.getValue()) * f;
        float f4 = (float)(this.yend.getValue() - this.ystart.getValue()) * f2;
        graphics2D.translate(this.xborder, this.getHeight() - this.yborder);
        for (int i = 0; i < n; ++i) {
            int n2;
            float f5;
            float f6;
            float f7 = (((Float)this.emboss_data[1][i]).floatValue() - (float)this.xstart.getValue()) * f;
            float f8 = -(((Float)this.emboss_data[2][i]).floatValue() - (float)this.ystart.getValue()) * f2;
            if ((Integer)this.emboss_data[0][i] == LINE) {
                f6 = (((Float)this.emboss_data[3][i]).floatValue() - (float)this.xstart.getValue()) * f;
                f5 = -(((Float)this.emboss_data[4][i]).floatValue() - (float)this.ystart.getValue()) * f2;
                if (!(f7 >= 0.0f && f6 >= 0.0f && f7 <= f3 && f6 <= f3 && f8 <= 0.0f && f5 <= 0.0f && f8 >= -f4 && f5 >= -f4) && this.draw_axes) continue;
                n2 = (int)((Float)this.emboss_data[5][i]).floatValue();
                if (this.graph_colour != null && this.graph_colour != Color.black) {
                    graphics.setColor(this.graph_colour);
                } else if (n2 >= 0 || n2 < 16) {
                    graphics.setColor(this.plplot_colour[n2]);
                }
                graphics.drawLine((int)f7, (int)f8, (int)f6, (int)f5);
                continue;
            }
            if ((Integer)this.emboss_data[0][i] == RECTANGLE || (Integer)this.emboss_data[0][i] == FILLED_RECTANGLE) {
                f6 = (((Float)this.emboss_data[3][i]).floatValue() - (float)this.xstart.getValue()) * f;
                f5 = -(((Float)this.emboss_data[4][i]).floatValue() - (float)this.ystart.getValue()) * f2;
                n2 = (int)((Float)this.emboss_data[5][i]).floatValue();
                if (this.graph_colour != null && this.graph_colour != Color.black) {
                    graphics.setColor(this.graph_colour);
                } else if (n2 >= 0 || n2 < 16) {
                    graphics.setColor(this.plplot_colour[n2]);
                }
                if (f7 > f6) {
                    float f9 = f7;
                    f7 = f6;
                    f6 = f9;
                }
                if ((Integer)this.emboss_data[0][i] == RECTANGLE) {
                    graphics.drawRect((int)f7, (int)f5, (int)Math.abs(f6 - f7), (int)Math.abs(f8 - f5));
                    continue;
                }
                graphics.fillRect((int)f7, (int)f5, (int)Math.abs(f6 - f7), (int)Math.abs(f8 - f5));
                continue;
            }
            if ((Integer)this.emboss_data[0][i] == TEXT) {
                n2 = 1;
                try {
                    String string = (String)this.emboss_data[5][i];
                    Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
                if (f7 >= 0.0f && f8 <= 0.0f && f7 <= f3 && f8 >= -f4) {
                    int n3 = (int)((Float)this.emboss_data[3][i]).floatValue();
                    int n4 = this.justify((String)this.emboss_data[5][i], fontMetrics);
                    graphics.setColor(this.plplot_colour[n3]);
                    graphics.drawString((String)this.emboss_data[5][i], (int)(f7 - (float)n4), (int)f8);
                    continue;
                }
                if (f8 > 0.0f && n2 == 0) {
                    if (this.xtitle_field != null) continue;
                    this.xtitle_field = new JTextField((String)this.emboss_data[5][i]);
                    continue;
                }
                if (!(f8 < f4) || n2 != 0 || this.maintitle_field != null) continue;
                this.maintitle_field = new JTextField((String)this.emboss_data[5][i]);
                continue;
            }
            if ((Integer)this.emboss_data[0][i] != TEXTLINE) continue;
            n2 = 1;
            try {
                String string = (String)this.emboss_data[6][i];
                Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (f7 >= 0.0f && f8 <= 0.0f && f7 <= f3 && f8 >= -f4) {
                int n5 = (int)((Float)this.emboss_data[5][i]).floatValue();
                graphics.setColor(this.plplot_colour[n5]);
                graphics.drawString((String)this.emboss_data[6][i], (int)f7, (int)f8);
                continue;
            }
            if (f8 > 0.0f && n2 == 0) {
                if (this.ytitle_field != null) continue;
                this.ytitle_field = new JTextField((String)this.emboss_data[5][i]);
                continue;
            }
            if (!(f8 < f4) || n2 != 0 || this.maintitle_field != null) continue;
            this.maintitle_field = new JTextField((String)this.emboss_data[5][i]);
        }
        graphics2D.translate(-this.xborder, -this.getHeight() + this.yborder);
        graphics2D.setStroke(basicStroke);
    }

    private int justify(String string, FontMetrics fontMetrics) {
        int n = 0;
        if (string.length() == 1 && this.fileName.indexOf("prettyplot") > -1) {
            return n;
        }
        return fontMetrics.stringWidth(string) / 2;
    }

    private void drawPoints(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.graph_colour);
        BasicStroke basicStroke = (BasicStroke)graphics2D.getStroke();
        if (this.graph_line == null) {
            this.graph_line = new TextFieldFloat();
            this.graph_line.setValue(1.0);
        }
        graphics2D.setStroke(new BasicStroke((float)this.graph_line.getValue()));
        int n = this.emboss_data[0].length;
        if (this.xstart == null) {
            this.xstart = new TextFieldFloat();
            this.xstart.setValue(this.xmin);
        }
        if (this.xend == null) {
            this.xend = new TextFieldFloat();
            this.xend.setValue(this.xmax);
        }
        if (this.ystart == null) {
            this.ystart = new TextFieldFloat();
            this.ystart.setValue(this.ymin);
        }
        if (this.yend == null) {
            this.yend = new TextFieldFloat();
            this.yend.setValue(this.ymax);
        }
        float f = (float)(this.getWidth() - 2 * this.xborder) / (float)(this.xend.getValue() - this.xstart.getValue());
        float f2 = (float)(this.getHeight() - 2 * this.yborder) / (float)(this.yend.getValue() - this.ystart.getValue());
        float f3 = (((Float)this.emboss_data[0][0]).floatValue() - (float)this.xstart.getValue()) * f;
        float f4 = -(((Float)this.emboss_data[1][0]).floatValue() - (float)this.ystart.getValue()) * f2;
        float f5 = (float)(this.xend.getValue() - this.xstart.getValue()) * f;
        float f6 = -((float)(this.yend.getValue() - this.ystart.getValue())) * f2;
        graphics2D.translate(this.xborder, this.getHeight() - this.yborder);
        for (int i = 1; i < n; ++i) {
            float f7 = (((Float)this.emboss_data[0][i]).floatValue() - (float)this.xstart.getValue()) * f;
            float f8 = -(((Float)this.emboss_data[1][i]).floatValue() - (float)this.ystart.getValue()) * f2;
            if (f3 >= 0.0f && f7 >= 0.0f && f4 <= 0.0f && f8 <= 0.0f) {
                graphics.drawLine((int)f3, (int)f4, (int)f7, (int)f8);
            }
            f3 = f7;
            f4 = f8;
        }
        graphics2D.translate(-this.xborder, -this.getHeight() + this.yborder);
        graphics2D.setStroke(basicStroke);
    }

    public Object[][] readGraph(Reader reader) throws IOException {
        Object[][] objectArray;
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        Vector<Object> vector = new Vector<Object>();
        Vector<Float> vector2 = new Vector<Float>();
        this.graph_data = new StringBuffer();
        int n = 0;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            int n2;
            this.graph_data.append(string + "\n");
            if ((string.startsWith("Line") || string.startsWith("Rectangle") || string.startsWith("Filled Rectangle")) && !bl) {
                vector.add(string);
                continue;
            }
            if (string.startsWith("##Points ")) {
                n2 = string.indexOf(" ");
                n = Integer.parseInt(string.substring(n2).trim());
                continue;
            }
            if (string.startsWith("##Screen ")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                this.xmin_screen = Float.parseFloat(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                this.ymin_screen = Float.parseFloat(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                this.xmax_screen = Float.parseFloat(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                this.ymax_screen = Float.parseFloat(stringTokenizer.nextToken());
                this.screen_min_max = true;
                continue;
            }
            if (string.startsWith("##Xmin ")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                stringTokenizer.nextToken();
                this.xmin = Float.parseFloat(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                this.xmax = Float.parseFloat(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                this.ymin = Float.parseFloat(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                this.ymax = Float.parseFloat(stringTokenizer.nextToken());
                continue;
            }
            if (!(string.startsWith("#") || string.equals("") || string.startsWith("Text") || string.startsWith("Line"))) {
                n2 = (string = string.trim()).indexOf("\t");
                if (n2 == -1) {
                    n2 = string.indexOf(" ");
                }
                bl = true;
                vector.add(new Float(string.substring(0, n2).trim()));
                vector2.add(new Float(string.substring(n2).trim()));
                continue;
            }
            if (string.startsWith("##Xtitle")) {
                n2 = string.indexOf(" ");
                this.xtitle = string.substring(n2).trim();
                if (!this.xtitle.equals("<null>")) continue;
                this.xtitle = "x";
                continue;
            }
            if (string.startsWith("##Ytitle")) {
                n2 = string.indexOf(" ");
                this.ytitle = string.substring(n2).trim();
                if (!this.ytitle.equals("<null>")) continue;
                this.ytitle = "y";
                continue;
            }
            if (string.startsWith("##Maintitle ")) {
                n2 = string.indexOf(" ");
                this.maintitle = string.substring(n2).trim();
                continue;
            }
            if (!string.startsWith("Text")) continue;
            vector.add(string);
        }
        n = vector.size();
        if (vector2.size() > 0) {
            objectArray = new Object[2][n];
            for (int i = 0; i < n; ++i) {
                objectArray[0][i] = (Float)vector.get(i);
                objectArray[1][i] = (Float)vector2.get(i);
            }
        } else {
            objectArray = new Object[7][n];
            for (int i = 0; i < n; ++i) {
                this.setGraphicRow(objectArray, (String)vector.get(i), i);
            }
        }
        return objectArray;
    }

    private void setGraphicRow(Object[][] objectArray, String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("Line")) {
            objectArray[0][n] = new Integer(LINE);
        } else if (string2.startsWith("Textline")) {
            objectArray[0][n] = new Integer(TEXTLINE);
        } else if (string2.startsWith("Text")) {
            objectArray[0][n] = new Integer(TEXT);
        } else if (string2.equals("Rectangle")) {
            objectArray[0][n] = new Integer(RECTANGLE);
        } else if (string2.equals("Filled")) {
            objectArray[0][n] = new Integer(FILLED_RECTANGLE);
            stringTokenizer.nextToken();
        }
        stringTokenizer.nextToken();
        objectArray[1][n] = Float.valueOf(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        objectArray[2][n] = Float.valueOf(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        objectArray[3][n] = Float.valueOf(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        objectArray[4][n] = Float.valueOf(stringTokenizer.nextToken());
        if (string2.equals("Line") || string2.equals("Rectangle") || string2.equals("Filled")) {
            stringTokenizer.nextToken();
            objectArray[5][n] = Float.valueOf(stringTokenizer.nextToken());
        } else if (string2.startsWith("Textline")) {
            stringTokenizer.nextToken();
            objectArray[5][n] = Float.valueOf(stringTokenizer.nextToken());
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            String string3 = new String();
            while (stringTokenizer.hasMoreTokens()) {
                string3 = string3 + " " + stringTokenizer.nextToken();
            }
            objectArray[6][n] = string3.trim();
        } else if (string2.startsWith("Text")) {
            String string4 = new String();
            while (stringTokenizer.hasMoreTokens()) {
                string4 = string4 + " " + stringTokenizer.nextToken();
            }
            objectArray[5][n] = string4.trim();
        }
    }

    private boolean isTick(float f, float f2, float f3, float f4, float f5, boolean bl) {
        if (f5 != 0.0f) {
            return false;
        }
        if (f == f3 || f2 == f4) {
            if (bl) {
                if (this.isOutOfXBounds(f) || this.isOutOfXBounds(f3) || this.isOutOfYBounds(f2) || this.isOutOfYBounds(f4)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean isOutOfXBounds(float f) {
        return f < this.xmin || f > this.xmax;
    }

    private boolean isOutOfYBounds(float f) {
        return f < this.ymin || f > this.ymax;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Jemboss Graphics");
        Graph2DPlot graph2DPlot = new Graph2DPlot();
        JScrollPane jScrollPane = new JScrollPane(graph2DPlot);
        jScrollPane.setPreferredSize(new Dimension(400, 400));
        jFrame.getContentPane().add(jScrollPane);
        File file = new File(stringArray[0]);
        graph2DPlot.setFileData(file);
        jFrame.setJMenuBar(graph2DPlot.getMenuBar(false, jFrame));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

