/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.journal.active;

import org.apache.activeio.journal.active.Location;
import org.apache.activeio.journal.active.LogFile;
import org.apache.activeio.journal.active.LogFileNode;
import org.apache.activeio.journal.active.Record;

public final class RecordInfo {
    private final Location location;
    private final Record header;
    private final LogFileNode logFileState;
    private final LogFile logFile;

    public RecordInfo(Location location, Record header, LogFileNode logFileState, LogFile logFile) {
        this.location = location;
        this.header = header;
        this.logFileState = logFileState;
        this.logFile = logFile;
    }

    int getNextLocation() {
        return this.location.getLogFileOffset() + this.header.getPayloadLength() + 36;
    }

    public Record getHeader() {
        return this.header;
    }

    public Location getLocation() {
        return this.location;
    }

    public LogFileNode getLogFileState() {
        return this.logFileState;
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public int getDataOffset() {
        return this.location.getLogFileOffset() + 16;
    }
}

