/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.messaging.message.ParameterMessage;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.log4j.Logger;

public class PayloadMessage
extends ParameterMessage {
    private static final Logger logger = Logger.getLogger(PayloadMessage.class);
    private static final String KEY_PAYLOAD_PREFIX = "payload_";
    private Map<String, URL> payloads = new HashMap<String, URL>();

    public PayloadMessage() {
    }

    public PayloadMessage(List<String> parameters) {
        super(parameters);
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        try {
            Enumeration names = from.getMapNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                logger.debug((Object)("examining " + name));
                if (!name.startsWith(KEY_PAYLOAD_PREFIX)) continue;
                String payloadName = name.substring(KEY_PAYLOAD_PREFIX.length());
                URL url = new URL(from.getString(name));
                this.payloads.put(payloadName, url);
                logger.debug((Object)("Unmarshalled " + name + " -> " + payloadName + ", " + url.toExternalForm()));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void marshal(MapMessage mapMessage) throws JMSException {
        super.marshal(mapMessage);
        try {
            for (String name : this.payloadNames()) {
                String key = KEY_PAYLOAD_PREFIX + name;
                String urlString = this.payloads.get(name).toExternalForm();
                mapMessage.setString(key, urlString);
                logger.debug((Object)("Marshalled " + name + " -> " + key + " " + urlString));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void addPayload(String payloadName, URL payloadURL) {
        this.payloads.put(payloadName, payloadURL);
    }

    public URL getPayload(String name) throws JMSException {
        if (this.payloads.containsKey(name)) {
            return this.payloads.get(name);
        }
        throw new IllegalArgumentException("No payload with name: + name");
    }

    public Set<String> payloadNames() {
        return this.payloads.keySet();
    }

    public Map<String, URL> getPayloads() {
        return this.payloads;
    }

    @Override
    public String toString() {
        return super.toString() + ", payload count: " + this.payloadNames().size();
    }
}

