/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Cigar;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class QualityCoverageTrack
extends Track {
    private long maxBpLength;
    private long minBpLength;
    private Collection<RegionContent> forwardReads = new TreeSet<RegionContent>();
    private Color forwardColor;

    public QualityCoverageTrack(Color forwardColor, long minBpLength, long maxBpLength) {
        this.forwardColor = forwardColor;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
        this.setStrand(Strand.BOTH);
    }

    private Collection<Drawable> getDrawableReads(Collection<RegionContent> reads, Color color) {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        Chromosome chr = this.getView().getBpRegion().start.chr;
        TreeMap<Long, Float> collector = this.getQualities(reads);
        int bpWidth = (int)((long)this.getView().getWidth() / this.getView().getBpRegion().getLength());
        int bottomlineY = 0;
        Iterator<Long> bpLocations = collector.keySet().iterator();
        if (bpLocations.hasNext()) {
            Long lastBpLocation = bpLocations.next();
            int startX = this.getView().bpToTrack(new BpCoord(lastBpLocation, chr));
            long startY = (long)collector.get(lastBpLocation).floatValue();
            drawables.add(new LineDrawable(0, bottomlineY, startX - bpWidth, bottomlineY, color));
            drawables.add(new LineDrawable(startX - bpWidth, bottomlineY, startX, (int)((long)bottomlineY + startY), color));
            while (bpLocations.hasNext()) {
                Long currentBpLocation = bpLocations.next();
                startX = this.getView().bpToTrack(new BpCoord(lastBpLocation, chr));
                startY = (long)collector.get(lastBpLocation).floatValue();
                int endX = this.getView().bpToTrack(new BpCoord(currentBpLocation, chr));
                long endY = (long)collector.get(currentBpLocation).floatValue();
                if (currentBpLocation - lastBpLocation == 1L) {
                    drawables.add(new LineDrawable(startX, (int)((long)bottomlineY + startY), endX, (int)((long)bottomlineY + endY), color));
                } else {
                    drawables.add(new LineDrawable(startX, (int)((long)bottomlineY + startY), startX + bpWidth, bottomlineY, color));
                    drawables.add(new LineDrawable(startX + bpWidth, bottomlineY, endX - bpWidth, bottomlineY, color));
                    drawables.add(new LineDrawable(endX - bpWidth, bottomlineY, endX, (int)((long)bottomlineY + endY), color));
                }
                lastBpLocation = currentBpLocation;
            }
            int endX = this.getView().bpToTrack(new BpCoord(lastBpLocation, chr));
            long endY = (long)collector.get(lastBpLocation).floatValue();
            drawables.add(new LineDrawable(endX, (int)((long)bottomlineY + endY), endX + bpWidth, bottomlineY, color));
            drawables.add(new LineDrawable(endX + bpWidth, bottomlineY, this.getView().getWidth(), bottomlineY, color));
        }
        collector.clear();
        return drawables;
    }

    private TreeMap<Long, Float> getQualities(Collection<RegionContent> reads) {
        TreeMap<Long, Float> collector = new TreeMap<Long, Float>();
        Iterator<RegionContent> iter = reads.iterator();
        while (iter.hasNext()) {
            RegionContent read = iter.next();
            if (!read.region.intersects(this.getView().getBpRegion())) {
                iter.remove();
                continue;
            }
            Cigar cigar = (Cigar)read.values.get((Object)ColumnType.CIGAR);
            String quality = (String)read.values.get((Object)ColumnType.QUALITY);
            if (quality == null) continue;
            for (int i = 0; i < quality.length(); ++i) {
                long refIndex = cigar.getReferenceIndex(i);
                if (refIndex == -1L) continue;
                Long bp = refIndex + read.region.start.bp;
                char qualityChar = quality.charAt(i);
                float qualityValue = (float)(qualityChar - 33) / 25.0f;
                if (!collector.containsKey(bp)) {
                    collector.put(bp, Float.valueOf(qualityValue));
                    continue;
                }
                collector.put(bp, Float.valueOf(collector.get(bp).floatValue() + qualityValue));
            }
        }
        return collector;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        drawables.addAll(this.getDrawableReads(this.forwardReads, this.forwardColor));
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (RegionContent content : areaResult.getContents()) {
            if (this.getStrand() != content.values.get((Object)ColumnType.STRAND) && this.getStrand() != Strand.BOTH) continue;
            this.forwardReads.add(content);
        }
        this.getView().redraw();
    }

    @Override
    public int getHeight() {
        return 100;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<AreaRequestHandler, Set<ColumnType>> requestedData() {
        HashMap<AreaRequestHandler, Set<ColumnType>> datas = new HashMap<AreaRequestHandler, Set<ColumnType>>();
        datas.put(this.areaRequestHandler, new HashSet<ColumnType>(Arrays.asList(ColumnType.ID, ColumnType.STRAND, ColumnType.QUALITY, ColumnType.CIGAR)));
        return datas;
    }

    @Override
    public boolean canExpandDrawables() {
        return true;
    }

    @Override
    public String getName() {
        return "QualityCoverageTrack";
    }
}

