/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CoverageEstimateTrack
extends Track {
    public static final int SAMPLING_GRANULARITY = 200;
    private static final int MAX_VALUE_COUNT = 400;
    private SortedSet<RegionContent> values = new TreeSet<RegionContent>();
    private LinkedList<RegionContent> valueStorageOrder = new LinkedList();
    private long minBpLength;
    private Color color;
    private boolean doLog;
    private boolean removeTooWide;

    public CoverageEstimateTrack(Color c, long maxBpLength, boolean doLog, boolean removeTooWide) {
        this.color = c;
        this.doLog = doLog;
        this.minBpLength = maxBpLength;
        this.removeTooWide = removeTooWide;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        while (this.values.size() > 400) {
            RegionContent oldest = this.valueStorageOrder.pop();
            this.values.remove(oldest);
        }
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            RegionContent regCont = (RegionContent)iterator.next();
            if (!regCont.region.intersects(this.getView().getBpRegion())) {
                iterator.remove();
                continue;
            }
            if (this.removeTooWide && regCont.region.getLength() > this.getView().getBpRegion().getLength() / 200L * 2L) {
                iterator.remove();
                continue;
            }
            int x1 = this.getView().bpToTrack(regCont.region.start);
            int x2 = this.getView().bpToTrack(regCont.region.end) + 2;
            int y = 0;
            double count = this.getStrand() == Strand.FORWARD ? (double)((Integer)regCont.values.get((Object)ColumnType.COVERAGE_ESTIMATE_FORWARD)).intValue() : (double)((Integer)regCont.values.get((Object)ColumnType.COVERAGE_ESTIMATE_REVERSE)).intValue();
            if (this.doLog) {
                count = Math.log(count);
            }
            int height = (int)Math.min(count * 6.0, (double)this.getHeight());
            drawables.add(new RectDrawable(x1, y, x2 - x1, height, this.color, null));
        }
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (RegionContent content : areaResult.getContents()) {
            if (!content.region.intersects(this.getView().getBpRegion()) || !content.values.containsKey((Object)ColumnType.COVERAGE_ESTIMATE_FORWARD)) continue;
            this.values.add(content);
            this.valueStorageOrder.add(content);
        }
        this.getView().redraw();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength;
    }

    @Override
    public Map<AreaRequestHandler, Set<ColumnType>> requestedData() {
        HashMap<AreaRequestHandler, Set<ColumnType>> datas = new HashMap<AreaRequestHandler, Set<ColumnType>>();
        datas.put(this.areaRequestHandler, new HashSet<ColumnType>(Arrays.asList(ColumnType.COVERAGE_ESTIMATE_FORWARD, ColumnType.COVERAGE_ESTIMATE_REVERSE)));
        return datas;
    }

    @Override
    public int getHeight() {
        return 100;
    }
}

