/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.stack;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.TsvLineParser;

public class VcfLineParser
extends TsvLineParser {
    @Override
    public Region getRegion() {
        if (this.isContentLine()) {
            long start = this.getLong(Column.POS.ordinal());
            Chromosome chr = new Chromosome(this.getString(Column.CHROM.ordinal()));
            return new Region(start, start, chr);
        }
        return null;
    }

    public String getQuality() {
        return this.getString(Column.QUAL.ordinal());
    }

    @Override
    public String getHeaderStart() {
        return "#";
    }

    public static enum Column {
        CHROM("chromosome"),
        POS("position"),
        ID("identifiers"),
        REF("references base(s)"),
        ALT("non-reference alleles"),
        QUAL("quality score"),
        FILTER("filter pass"),
        INFO("additional information");

        private final String name;

        private Column(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

