/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.stack;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.BinarySearchIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.Index;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.LineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.SingleThreadAreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;

public class LineToRegionConversion
extends SingleThreadAreaRequestHandler {
    private Index index;
    private LineParser parser;

    public LineToRegionConversion(DataSource file, LineParser parser, Queue<AreaRequest> areaRequestQueue, AreaResultListener areaResultListener) {
        super(areaRequestQueue, areaResultListener);
        this.parser = parser;
        try {
            this.index = new BinarySearchIndex(file, parser);
        }
        catch (UnsortedDataException e) {
            e.printStackTrace();
            this.index = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GBrowserException e) {
            e.printStackTrace();
        }
    }

    public LineToRegionConversion(URL url, LineParser parser) throws FileNotFoundException, URISyntaxException {
        this(new RandomAccessLineDataSource(url), parser, null, null);
    }

    @Override
    protected void processAreaRequest(AreaRequest request) {
        super.processAreaRequest(request);
        if (request.getStatus().poison) {
            return;
        }
        if (this.index == null) {
            return;
        }
        long start = request.start.bp;
        long end = request.end.bp;
        int EXTRA = 1000000;
        start = Math.max(start - (long)EXTRA, 1L);
        Region requestRegion = new Region(start, end += (long)EXTRA, request.start.chr);
        TreeMap<IndexKey, String> lines = null;
        try {
            lines = this.index.getFileLines(new AreaRequest(requestRegion, request.getRequestedContents(), request.getStatus()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GBrowserException e) {
            e.printStackTrace();
        }
        LinkedList<RegionContent> list = new LinkedList<RegionContent>();
        for (Map.Entry entry : lines.entrySet()) {
            String line = (String)entry.getValue();
            this.parser.setLine(line);
            Region region = this.parser.getRegion();
            IndexKey id = (IndexKey)entry.getKey();
            LinkedHashMap<ColumnType, Object> valueMap = new LinkedHashMap<ColumnType, Object>();
            valueMap.put(ColumnType.ID, id);
            valueMap.put(ColumnType.VALUE, line);
            RegionContent regionContent = new RegionContent(region, valueMap);
            list.add(regionContent);
        }
        super.createAreaResult(new AreaResult(request.getStatus(), list));
    }
}

