/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRetrievalStatus;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.SingleThreadAreaRequestHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class QueueManager
implements AreaResultListener {
    private Map<AreaRequestHandler, QueueContext> queues = new HashMap<AreaRequestHandler, QueueContext>();

    private QueueContext createQueue(AreaRequestHandler areaRequestHandler) {
        if (!this.queues.containsKey(areaRequestHandler)) {
            QueueContext context = new QueueContext();
            context.queue = areaRequestHandler instanceof SingleThreadAreaRequestHandler ? new LinkedBlockingQueue<AreaRequest>() : new ConcurrentLinkedQueue<AreaRequest>();
            try {
                areaRequestHandler.setQueue(context.queue);
                areaRequestHandler.setAreaResultListener(this);
                context.requestHandler = areaRequestHandler;
                this.queues.put(areaRequestHandler, context);
                if (context.requestHandler.isAlive()) {
                    System.err.println("Thread '" + context.requestHandler + "' is poisoned, but still alive. " + "A new thread will be started for the upcoming requests.");
                    context.requestHandler = (AreaRequestHandler)context.requestHandler.clone();
                }
                context.requestHandler.runThread();
                return context;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void removeQueue(DataSource file) {
        this.queues.remove(file);
    }

    public void addAreaRequest(AreaRequestHandler areaRequestHandler, AreaRequest req, boolean clearQueues) {
        req.getStatus().areaRequestHandler = areaRequestHandler;
        QueueContext context = this.queues.get(areaRequestHandler);
        req.getStatus().maybeClearQueue(context.queue);
        context.queue.add(req);
        if (context.requestHandler != null && !(context.requestHandler instanceof SingleThreadAreaRequestHandler)) {
            context.requestHandler.notifyAreaRequestHandler();
        }
    }

    public void addResultListener(AreaRequestHandler areaRequestHandler, AreaResultListener listener) {
        QueueContext qContext = this.queues.get(areaRequestHandler);
        if (qContext == null) {
            qContext = this.createQueue(areaRequestHandler);
        }
        qContext.listeners.add(listener);
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (AreaResultListener listener : this.queues.get((Object)areaResult.getStatus().areaRequestHandler).listeners) {
            listener.processAreaResult(areaResult);
        }
    }

    public void poisonAll() {
        for (Map.Entry<AreaRequestHandler, QueueContext> entry : this.queues.entrySet()) {
            DataRetrievalStatus status = new DataRetrievalStatus();
            status.poison = true;
            AreaRequest request = new AreaRequest(new Region(), null, status);
            QueueContext context = entry.getValue();
            context.queue.add(request);
            context.requestHandler.notifyAreaRequestHandler();
        }
    }

    private class QueueContext {
        public Queue<AreaRequest> queue;
        public Collection<AreaResultListener> listeners = new ArrayList<AreaResultListener>();
        public AreaRequestHandler requestHandler;

        private QueueContext() {
        }
    }
}

