/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class WIGConvertingTool {
    private static final String VARIABLE_STEP = "variableStep";
    private static final String FIXED_STEP = "fixedStep";
    HeaderDefinition header;
    float value = -1.0f;
    String line = "";
    String previousLine = "";
    String output;
    int linesCount = 1;

    public void convert(File file) {
        try {
            FileReader fReader = new FileReader(file);
            BufferedReader reader = new BufferedReader(fReader);
            BufferedWriter writer = new BufferedWriter(new FileWriter(file.getAbsolutePath() + ".out"));
            while (!this.line.contains("track")) {
                this.line = reader.readLine();
            }
            this.line = reader.readLine();
            this.header = this.setHeader(this.line);
            this.line = reader.readLine();
            if (this.header.type.equals(VARIABLE_STEP)) {
                this.header.startPosition = Long.parseLong(this.line.split("\t")[0]);
            }
            this.value = this.getValue(this.line);
            while (reader.ready()) {
                this.previousLine = this.line;
                this.line = reader.readLine();
                if (this.line.contains("Step")) {
                    if (this.linesCount != 0) {
                        this.output = this.formLine(this.previousLine, this.linesCount - 1);
                        writer.write(this.output);
                    }
                    this.header = this.setHeader(this.line);
                    this.linesCount = 0;
                    this.previousLine = this.line;
                    this.line = reader.readLine();
                    if (this.header.type.equals(VARIABLE_STEP)) {
                        this.header.startPosition = Long.parseLong(this.line.split("\t")[0]);
                        this.value = this.getValue(this.line);
                        continue;
                    }
                    this.value = Long.parseLong(this.line);
                    continue;
                }
                if (this.header.type.equals(FIXED_STEP)) {
                    if (this.value != this.getValue(this.line)) {
                        this.output = this.formLine(this.previousLine, this.linesCount);
                        writer.write(this.output);
                        this.header.startPosition = this.header.startPosition + (long)this.linesCount * this.header.step;
                        this.linesCount = 0;
                        this.value = this.getValue(this.line);
                    }
                } else if (this.getVarStepPos(this.line) != this.getVarStepPos(this.previousLine) + this.header.span) {
                    this.output = this.formLine(this.previousLine, this.linesCount);
                    writer.write(this.output);
                    this.linesCount = 0;
                    this.value = this.getValue(this.line);
                    this.header.startPosition = this.getVarStepPos(this.line);
                } else if (this.value != this.getValue(this.line)) {
                    this.output = this.formLine(this.previousLine, this.linesCount);
                    writer.write(this.output);
                    this.linesCount = 0;
                    this.value = this.getValue(this.line);
                    this.header.startPosition = this.getVarStepPos(this.line);
                }
                ++this.linesCount;
            }
            this.output = this.formLine(this.line, this.linesCount);
            writer.write(this.output);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HeaderDefinition setHeader(String chunk) {
        HeaderDefinition header = new HeaderDefinition();
        try {
            if (chunk.indexOf("\n") != -1) {
                chunk = chunk.substring(0, chunk.indexOf("\n"));
            }
            String[] cols = chunk.split(" ");
            switch (cols.length) {
                case 2: {
                    header.type = cols[0];
                    header.chr = cols[1].replace("chrom=chr", "");
                    break;
                }
                case 3: {
                    header.type = cols[0];
                    header.chr = cols[1].replace("chrom=chr", "");
                    header.span = Long.parseLong(cols[2].replace("span=", ""));
                    break;
                }
                case 4: {
                    header.type = cols[0];
                    header.chr = cols[1].replace("chrom=", "");
                    header.startPosition = Long.parseLong(cols[2].replace("start=", ""));
                    header.step = Long.parseLong(cols[3].replace("step=", ""));
                    break;
                }
                case 5: {
                    header.type = cols[0];
                    header.chr = cols[1].replace("chrom=", "");
                    header.startPosition = Long.parseLong(cols[2].replace("start=", ""));
                    header.step = Long.parseLong(cols[3].replace("step=", ""));
                    header.span = Long.parseLong(cols[4].replace("span=", ""));
                    break;
                }
            }
            return header;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String formLine(String line, int linesCount) {
        if (this.header.type.startsWith("variable")) {
            String[] splitted = line.split("\t");
            return this.header.chr + "\t" + this.header.startPosition + "\t" + (Long.parseLong(splitted[0]) + this.header.span - 1L) + "\t" + splitted[1] + "\n";
        }
        return this.header.chr + "\t" + this.header.startPosition + "\t" + (this.header.startPosition + (long)linesCount * this.header.span - 1L) + "\t" + line + "\n";
    }

    public float getValue(String value) {
        String[] splitted = value.split("\t");
        switch (splitted.length) {
            case 1: {
                return Float.parseFloat(splitted[0]);
            }
            case 2: {
                return Float.parseFloat(splitted[1]);
            }
        }
        return ((Float)null).floatValue();
    }

    public long getVarStepPos(String value) {
        return Long.parseLong(value.split("\t")[0]);
    }

    private class HeaderDefinition {
        String type;
        String chr;
        Long span;
        Long startPosition;
        Long step;

        private HeaderDefinition() {
        }
    }
}

