/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dialog;

import fi.csc.microarray.client.ServiceAccessor;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.session.UserSession;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.messaging.message.FeedbackMessage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FeedbackDialog
extends JDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(FeedbackDialog.class);
    private SwingClientApplication application;
    private final Dimension BUTTON_SIZE = new Dimension(70, 25);
    private JButton okButton;
    private JButton cancelButton;
    private JTextArea detailArea;
    private JTextField emailField;
    private JCheckBox attachSessionBox;
    private JCheckBox attachLogsBox;
    private String errorMessage;

    public FeedbackDialog(SwingClientApplication application, String errorMessage) {
        this(application, errorMessage, false);
    }

    public FeedbackDialog(SwingClientApplication application, String errorMessage, boolean sendSessionByDefault) {
        super((Frame)application.getMainFrame(), true);
        this.application = application;
        this.setTitle("Contact support");
        this.errorMessage = errorMessage;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)new JLabel("Message"), c);
        this.detailArea = new JTextArea();
        this.detailArea.setPreferredSize(new Dimension(300, 150));
        c.insets.set(0, 10, 10, 10);
        ++c.gridy;
        this.add((Component)this.detailArea, c);
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)new JLabel("Your email"), c);
        this.emailField = new JTextField();
        this.emailField.setPreferredSize(new Dimension(300, 20));
        c.insets.set(0, 10, 10, 10);
        ++c.gridy;
        this.add((Component)this.emailField, c);
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.attachSessionBox = new JCheckBox("Attach data and workflow information");
        this.attachSessionBox.setSelected(sendSessionByDefault);
        this.add((Component)this.attachSessionBox, c);
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.attachLogsBox = new JCheckBox("Attach log files");
        this.attachLogsBox.setSelected(true);
        this.add((Component)this.attachLogsBox, c);
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(this.BUTTON_SIZE);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(this.BUTTON_SIZE);
        this.cancelButton.addActionListener(this);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        c.fill = 2;
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)buttonsPanel, c);
    }

    public void showDialog() {
        this.setLocationRelativeTo(this.application.getMainFrame());
        this.setResizable(false);
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okButton) {
            if (this.detailArea.getText().length() == 0) {
                JOptionPane.showMessageDialog(this.getParent(), "Please, provide some details in the feedback area.", "Info", 1);
                return;
            }
            this.dispose();
            this.application.runBlockingTask("sending feedback, with large session this may take a while", new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String sessionURL;
                        ServiceAccessor serviceAccessor = Session.getSession().getServiceAccessor();
                        if (FeedbackDialog.this.attachSessionBox.isSelected()) {
                            File sessionFile = UserSession.findBackupFile(FeedbackDialog.this.application.getDataManager().getRepository(), true);
                            sessionFile.deleteOnExit();
                            try {
                                FeedbackDialog.this.application.getDataManager().saveFeedbackSession(sessionFile);
                                sessionURL = serviceAccessor.getFileBrokerClient().addFile(new FileInputStream(sessionFile), sessionFile.length(), null).toString();
                            }
                            catch (Exception e) {
                                logger.warn((Object)e);
                                sessionURL = "http://failed-to-create-or-upload-session";
                            }
                            finally {
                                sessionFile.delete();
                            }
                        } else {
                            sessionURL = "";
                        }
                        String messageText = FeedbackDialog.this.detailArea.getText() + "\n\nError message:\n" + FeedbackDialog.this.errorMessage;
                        FeedbackMessage message = new FeedbackMessage(messageText, FeedbackDialog.this.emailField.getText(), sessionURL);
                        if (FeedbackDialog.this.attachLogsBox.isSelected()) {
                            File logDir = DirectoryLayout.getInstance().getLogsDir();
                            for (File logFile : logDir.listFiles()) {
                                FileBrokerClient fileBroker = serviceAccessor.getFileBrokerClient();
                                String logURL = fileBroker.addFile(new FileInputStream(logFile), logFile.length(), null).toString();
                                message.addLog(logFile.getName(), logURL);
                            }
                        }
                        serviceAccessor.sendFeedbackMessage(message);
                    }
                    catch (Exception e) {
                        FeedbackDialog.this.application.reportException(e);
                    }
                }
            });
        } else {
            this.dispose();
        }
    }
}

