/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.emboss;

import fi.csc.microarray.analyser.emboss.ACDParameter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.emboss.jemboss.parser.ParseAcd;

public class ACDDescription {
    private String name;
    private String description;
    private LinkedList<String> groups = new LinkedList();
    private LinkedList<ACDParameter> parameters = new LinkedList();
    private LinkedHashMap<String, String> variableMap = new LinkedHashMap();

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public LinkedList<String> getGroups() {
        return this.groups;
    }

    public void addParameter(ACDParameter param) {
        this.parameters.add(param);
    }

    public ACDParameter getParameter(String name) {
        for (ACDParameter parameter : this.parameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public List<ACDParameter> getOutputParameters() {
        LinkedList<ACDParameter> params = new LinkedList<ACDParameter>();
        for (ACDParameter parameter : this.parameters) {
            if (ACDParameter.detectParameterGroup(parameter.getType()) != ACDParameter.PARAM_GROUP_OUTPUT || parameter.isAdvanced().booleanValue()) continue;
            params.add(parameter);
        }
        return params;
    }

    public List<ACDParameter> getGraphicsParameters() {
        LinkedList<ACDParameter> params = new LinkedList<ACDParameter>();
        for (ACDParameter parameter : this.parameters) {
            if (ACDParameter.detectParameterGroup(parameter.getType()) != ACDParameter.PARAM_GROUP_GRAPHICS || !parameter.isRequired().booleanValue()) continue;
            params.add(parameter);
        }
        return params;
    }

    public LinkedList<ACDParameter> getParameters(String section, String subsection, Boolean recursive) {
        LinkedList<ACDParameter> list = new LinkedList<ACDParameter>();
        for (ACDParameter param : this.parameters) {
            if (!param.getSection().equals(section) || subsection != null && !subsection.equals(param.getSubsection()) || subsection == null && !recursive.booleanValue() && param.getSubsection() != null) continue;
            list.add(param);
        }
        return list;
    }

    public LinkedList<ACDParameter> getParameters() {
        return this.parameters;
    }

    public ACDDescription() {
    }

    public ACDDescription(File file) {
        this.variableMap.put("acdprotein", "Y");
        HashMap<String, String> appAttrs = new HashMap<String, String>();
        appAttrs.put("application", "");
        appAttrs.put("documentation", "");
        appAttrs.put("groups", "");
        try {
            String[] groups;
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] bytes = new byte[(int)file.length()];
            inputStream.read(bytes);
            ParseAcd parser = new ParseAcd(new String(bytes), false);
            Integer numFields = parser.getNumofFields();
            parser.isDependents(null, 0, numFields.intValue());
            Integer numArgs = parser.getNumofParams(0);
            for (int i = 0; i < numArgs; ++i) {
                String key = parser.getParameterAttribute(0, i);
                String val = parser.getParamValueStr(0, i);
                if ((key = (String)ACDDescription.getKeyByPrefix(appAttrs, key)) == null) continue;
                appAttrs.put(key, val);
            }
            this.name = (String)appAttrs.get("application");
            this.description = (String)appAttrs.get("documentation");
            for (String group : groups = appAttrs.get("groups").split(",")) {
                this.groups.add(group.trim());
            }
            String currentSection = null;
            String currentSubsection = null;
            for (int j = 1; j < numFields; ++j) {
                String fieldType = parser.getParameterAttribute(j, 0);
                String fieldName = parser.getParamValueStr(j, 0);
                if ("section".startsWith(fieldType)) {
                    if (currentSection != null) {
                        currentSubsection = fieldName;
                        continue;
                    }
                    currentSection = fieldName;
                    continue;
                }
                if ("endsection".startsWith(fieldType)) {
                    if (currentSubsection == null) {
                        currentSection = null;
                    }
                    currentSubsection = null;
                    continue;
                }
                if ("application".startsWith(fieldType)) continue;
                ACDParameter param = new ACDParameter(this, fieldType, fieldName, currentSection, currentSubsection);
                Integer numAttrs = parser.getNumofParams(j);
                if (fieldType.equals("list") || fieldType.equals("selection")) {
                    param.setList(parser, j);
                }
                for (int k = 1; k < numAttrs; ++k) {
                    String attrName = parser.getParameterAttribute(j, k);
                    String attrValue = parser.getParamValueStr(j, k);
                    attrValue = ACDParameter.resolveExp(attrValue, this.variableMap);
                    param.setAttribute(attrName, attrValue);
                    this.variableMap.put(fieldName + "." + attrName, attrValue);
                    if (!"default".equals(attrName)) continue;
                    this.variableMap.put(fieldName, attrValue);
                }
                this.addParameter(param);
            }
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateVariables(HashMap<String, String> varMap) {
        this.variableMap.putAll(varMap);
        for (ACDParameter param : this.getParameters()) {
            param.updateAttributes(this.variableMap);
        }
    }

    public static Object getKeyByPrefix(HashMap<String, String> map, String prefix) {
        Object[] keys;
        for (Object key : keys = map.keySet().toArray()) {
            if (!((String)key).startsWith(prefix)) continue;
            return key;
        }
        return null;
    }
}

