/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisHandler;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.description.SADLDescription;

public class ToolDescriptionGenerator {
    public ToolDescription generate(SADLDescription source, AnalysisHandler analysisHandler) {
        ToolDescription description = new ToolDescription(analysisHandler);
        description.setID(source.getName().getID());
        description.setDisplayName(source.getName().getDisplayName());
        description.setComment(source.getComment());
        for (SADLDescription.Input input : source.inputs()) {
            description.addInputFile(input.getName().getID());
        }
        for (SADLDescription.Output output : source.outputs()) {
            description.addOutputFile(output.getName(), output.isOptional());
        }
        for (SADLDescription.Parameter parameter : source.parameters()) {
            description.addParameter(new ToolDescription.ParameterDescription(parameter.getName().getID(), parameter.getComment(), parameter.getType().isNumeric()));
        }
        return description;
    }
}

