/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.web.adminweb.ui;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import fi.csc.chipster.web.adminweb.ChipsterAdminUI;
import fi.csc.chipster.web.adminweb.data.JobLogContainer;
import fi.csc.chipster.web.adminweb.ui.JobLogFilter;
import fi.csc.chipster.web.adminweb.ui.JobLogTable;
import java.util.LinkedList;
import org.hibernate.exception.GenericJDBCException;

public class JobLogView
extends VerticalLayout
implements Button.ClickListener,
Property.ValueChangeListener {
    private HorizontalLayout toolbarLayout;
    private Button addFilterButton = new Button();
    private JobLogTable table;
    private JobLogContainer dataSource;
    private ChipsterAdminUI app;
    private LinkedList<JobLogFilter> filters;
    private HorizontalLayout filterLayout;
    private CheckBox ignoreTestAccounts;

    public JobLogView(ChipsterAdminUI app) {
        this.app = app;
        this.init();
    }

    public void init() {
        try {
            this.dataSource = new JobLogContainer(this);
            this.table = new JobLogTable(this);
            this.table.setContainerDataSource((Container)this.dataSource);
        }
        catch (GenericJDBCException e) {
            return;
        }
        this.table.setSortContainerPropertyId("startTime");
        this.table.setSortAscending(false);
        this.table.setVisibleColumns(JobLogContainer.NATURAL_COL_ORDER);
        this.table.setColumnHeaders(JobLogContainer.COL_HEADERS_ENGLISH);
        this.addComponent((Component)this.getToolbar());
        this.addComponent((Component)this.table);
        this.setSizeFull();
        this.setExpandRatio((Component)this.table, 1.0f);
    }

    public HorizontalLayout getToolbar() {
        if (this.toolbarLayout == null) {
            this.toolbarLayout = new HorizontalLayout();
            this.filterLayout = new HorizontalLayout();
            this.addFilter();
            this.toolbarLayout.addComponent((Component)this.filterLayout);
            this.addFilterButton.addClickListener((Button.ClickListener)this);
            this.addFilterButton.setIcon((Resource)new ThemeResource("crystal/edit_add.png"));
            this.addFilterButton.setDescription("Add another filter");
            this.addFilterButton.addStyleName("search-button");
            HorizontalLayout buttonBorder = new HorizontalLayout();
            buttonBorder.addStyleName("search-filter-bg");
            buttonBorder.addComponent((Component)this.addFilterButton);
            this.toolbarLayout.addComponent((Component)buttonBorder);
            Button searchButton = new Button();
            searchButton.setIcon((Resource)new ThemeResource("crystal/mail_find.png"));
            searchButton.setDescription("Search");
            this.toolbarLayout.addComponent((Component)searchButton);
            searchButton.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    JobLogView.this.applyFilters();
                }
            });
            this.ignoreTestAccounts = new CheckBox("Ignore test accounts", true);
            this.ignoreTestAccounts.addStyleName("toolbar-component");
            this.toolbarLayout.addComponent((Component)this.ignoreTestAccounts);
            this.dataSource.setIgnoreTestAccounts((Boolean)this.ignoreTestAccounts.getValue());
            this.ignoreTestAccounts.addValueChangeListener(new Property.ValueChangeListener(){

                public void valueChange(Property.ValueChangeEvent arg0) {
                    JobLogView.this.applyFilters();
                }
            });
            Label spaceEater = new Label(" ");
            this.toolbarLayout.addComponent((Component)spaceEater);
            this.toolbarLayout.setExpandRatio((Component)spaceEater, 1.0f);
            this.toolbarLayout.addComponent(this.app.getTitle());
            this.toolbarLayout.setWidth("100%");
            this.toolbarLayout.setStyleName("toolbar");
        }
        return this.toolbarLayout;
    }

    private void addFilter() {
        if (this.filters == null) {
            this.filters = new LinkedList();
        }
        JobLogFilter filter = new JobLogFilter(this);
        this.filters.add(filter);
        this.filterLayout.addComponent((Component)filter);
    }

    public void buttonClick(Button.ClickEvent event) {
        Button source = event.getButton();
        if (source == this.addFilterButton) {
            this.addFilter();
        }
    }

    public void valueChange(Property.ValueChangeEvent event) {
        Property property = event.getProperty();
        if (property == this.table) {
            // empty if block
        }
    }

    public void applyFilters() {
        this.updateContainerFilters();
        Notification.show((String)("Found " + this.table.getContainerDataSource().size() + " item(s)"), (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
    }

    private void updateContainerFilters() {
        this.dataSource.removeAllContainerFilters();
        this.dataSource.setIgnoreTestAccounts((Boolean)this.ignoreTestAccounts.getValue());
        for (JobLogFilter iteratedSearch : this.filters) {
            if (iteratedSearch.getContainerFilter() == null) continue;
            this.dataSource.addContainerFilter(iteratedSearch.getContainerFilter());
        }
        this.table.refreshRowCache();
    }

    public void clearFilters(JobLogFilter filter) {
        if (this.filters.size() > 1) {
            this.filterLayout.removeComponent((Component)filter);
            this.filters.remove((Object)filter);
        } else {
            this.filters.get(0).clear();
        }
        this.updateContainerFilters();
    }

    public void showOutput(Object itemId) {
        String output = "";
        Property outputProperty = this.dataSource.getContainerProperty(itemId, "outputText");
        if (outputProperty != null) {
            output = (String)outputProperty.getValue();
        }
        this.showTextWindow("Job output", output);
    }

    public void showErrorOutput(Object itemId) {
        String error = "";
        Property errorProperty = this.dataSource.getContainerProperty(itemId, "errorMessage");
        if (errorProperty != null) {
            error = (String)errorProperty.getValue();
        }
        this.showTextWindow("Error message", error);
    }

    private void showTextWindow(String caption, String content) {
        Label textComponent = new Label(content);
        textComponent.setContentMode(ContentMode.PREFORMATTED);
        Window subWindow = new Window(caption);
        subWindow.setContent((Component)textComponent);
        subWindow.setWidth(70.0f, Sizeable.Unit.PERCENTAGE);
        subWindow.setHeight(90.0f, Sizeable.Unit.PERCENTAGE);
        subWindow.center();
        this.getUI().addWindow(subWindow);
    }
}

